/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.bouncycastle.asn1.x9.ValidationParams;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DHAlgorithmParameterGeneratorSpi;
import org.bouncycastle.jcajce.provider.DHAlgorithmParametersSpi;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvDHPrivateKey;
import org.bouncycastle.jcajce.provider.ProvDHPublicKey;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;

class ProvDH
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalDhAttributes = new HashMap<String, String>();
    static final PublicKeyConverter<AsymmetricDHPublicKey> publicKeyConverter;
    static final PrivateKeyConverter<AsymmetricDHPrivateKey> privateKeyConverter;
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.dh.";
    private static final AgreementFactory fipsDHFactory;
    private static final AgreementFactory fipsDHUFactory;
    private static final AgreementFactory fipsMQVFactory;
    private static final ParametersCreator mqvParametersCreator;
    private static final ParametersCreator dhuParametersCreator;
    private static final ParametersCreator parametersCreator;

    ProvDH() {
    }

    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyPairGenerator.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyPairGeneratorSpi", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider);
            }
        });
        provider.addAlias("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
        provider.addAlias("Alg.Alias.KeyPairGenerator.MQV", "DH");
        provider.addAlias("Alg.Alias.KeyPairGenerator.DHU", "DH");
        provider.addAlgorithmImplementation("KeyAgreement.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(new FipsDH.DHAgreementFactory(), publicKeyConverter, privateKeyConverter, parametersCreator);
            }
        });
        provider.addAlias("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
        provider.addAlgorithmImplementation("KeyFactory.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyFactorySpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi();
            }
        });
        provider.addAlias("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
        provider.addAlias("Alg.Alias.KeyFactory.MQV", "DH");
        KeyFactorySpi converter = new KeyFactorySpi();
        this.registerOid(provider, X9ObjectIdentifiers.dhpublicnumber, "DH", converter);
        this.registerOid(provider, PKCSObjectIdentifiers.dhKeyAgreement, "DH", converter);
        provider.addAlgorithmImplementation("AlgorithmParameters.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.AlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new AlgorithmParametersSpi("DH");
            }
        });
        provider.addAlias("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.AlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new DHAlgorithmParameterGeneratorSpi(provider, "DH");
            }
        });
        provider.addAlias("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
        provider.addAlgorithmImplementation("AlgorithmParameters.MQV", "org.bouncycastle.jcajce.provider.asymmetric.dh.MQVAlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new MQVAlgorithmParametersSpi();
            }
        });
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator.MQV", "org.bouncycastle.jcajce.provider.asymmetric.dh.MQVAlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new DHAlgorithmParameterGeneratorSpi(provider, "MQV");
            }
        });
        provider.addAlgorithmImplementation("AlgorithmParameters.DHU", "org.bouncycastle.jcajce.provider.asymmetric.dh.DHUAlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new AlgorithmParametersSpi("DHU");
            }
        });
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator.DHU", "org.bouncycastle.jcajce.provider.asymmetric.dh.DHUAlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new DHAlgorithmParameterGeneratorSpi(provider, "MQV");
            }
        });
        this.addX963DHAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addX963DHAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addX963DHAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addX963DHAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addX963DHAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addX963DHAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addX963DHAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addX963DHUAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addX963DHUAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addX963DHUAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addX963DHUAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addX963DHUAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addX963DHUAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addX963DHUAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addX963MQVAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addX963MQVAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addX963MQVAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addX963MQVAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addX963MQVAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addX963MQVAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addX963MQVAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addConcatDHAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addConcatDHAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addConcatDHAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addConcatDHAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addConcatDHAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addConcatDHAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addConcatDHAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addConcatDHAlgorithm(provider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224);
        this.addConcatDHAlgorithm(provider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256);
        this.addConcatDHAlgorithm(provider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384);
        this.addConcatDHAlgorithm(provider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512);
        this.addConcatDHUAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addConcatDHUAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addConcatDHUAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addConcatDHUAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addConcatDHUAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addConcatDHUAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addConcatDHUAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addConcatDHUAlgorithm(provider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224);
        this.addConcatDHUAlgorithm(provider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256);
        this.addConcatDHUAlgorithm(provider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384);
        this.addConcatDHUAlgorithm(provider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512);
        this.addConcatMQVAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addConcatMQVAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addConcatMQVAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addConcatMQVAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addConcatMQVAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addConcatMQVAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addConcatMQVAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
    }

    private void addX963DHAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "DHWITH" + digest + "KDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DH" + digest + "KDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
    }

    private void addX963DHUAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "DHUWITH" + digest + "KDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHU" + digest + "KDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHUFactory, publicKeyConverter, privateKeyConverter, dhuParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
    }

    private void addX963MQVAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "MQVWITH" + digest + "KDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQV" + digest + "KDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
    }

    private void addConcatDHAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "DHWITH" + digest + "CKDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DH" + digest + "CKDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    private void addConcatDHUAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "DHUWITH" + digest + "CKDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DHU" + digest + "CKDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHUFactory, publicKeyConverter, privateKeyConverter, dhuParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    private void addConcatMQVAlgorithm(BouncyCastleFipsProvider provider, String digest, final FipsKDF.AgreementKDFPRF prf) {
        this.addKeyAgreementAlgorithm(provider, "MQVWITH" + digest + "CKDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQV" + digest + "CKDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    static {
        generalDhAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        generalDhAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        publicKeyConverter = new PublicKeyConverter<AsymmetricDHPublicKey>(){

            @Override
            public AsymmetricDHPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof DHPublicKey) {
                    if (key instanceof ProvDHPublicKey) {
                        return ((ProvDHPublicKey)key).getBaseKey();
                    }
                    return new ProvDHPublicKey(algorithm, (DHPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricDHPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify DH public key: " + e.getMessage(), e);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricDHPrivateKey>(){

            @Override
            public AsymmetricDHPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof DHPrivateKey) {
                    if (key instanceof ProvDHPrivateKey) {
                        return ((ProvDHPrivateKey)key).getBaseKey();
                    }
                    return new ProvDHPrivateKey(algorithm, (DHPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricDHPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify DH private key: " + e.getMessage(), e);
                }
            }
        };
        fipsDHFactory = new FipsDH.DHAgreementFactory();
        fipsDHUFactory = new FipsDH.DHUAgreementFactory();
        fipsMQVFactory = new FipsDH.MQVAgreementFactory();
        mqvParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                try {
                    if (!(spec instanceof MQVParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("MQV can only take an MQVParameterSpec");
                    }
                    MQVParameterSpec mqvSpec = (MQVParameterSpec)spec;
                    if (mqvSpec.getEphemeralPublicKey() != null) {
                        return FipsDH.MQV.using(publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mqvSpec.getEphemeralPublicKey()), privateKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mqvSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mqvSpec.getOtherPartyEphemeralKey()));
                    }
                    return FipsDH.MQV.using(privateKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mqvSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mqvSpec.getOtherPartyEphemeralKey()));
                }
                catch (InvalidKeyException e) {
                    throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + e.getMessage(), e);
                }
            }
        };
        dhuParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                try {
                    if (!(spec instanceof DHUParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("DHU can only take an DHUParameterSpec");
                    }
                    DHUParameterSpec dhuSpec = (DHUParameterSpec)spec;
                    if (dhuSpec.getEphemeralPublicKey() != null) {
                        return FipsDH.DHU.using(publicKeyConverter.convertKey(FipsDH.DHU.getAlgorithm(), dhuSpec.getEphemeralPublicKey()), privateKeyConverter.convertKey(FipsDH.DHU.getAlgorithm(), dhuSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.DHU.getAlgorithm(), dhuSpec.getOtherPartyEphemeralKey()));
                    }
                    return FipsDH.DHU.using(privateKeyConverter.convertKey(FipsDH.DHU.getAlgorithm(), dhuSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.DHU.getAlgorithm(), dhuSpec.getOtherPartyEphemeralKey()));
                }
                catch (InvalidKeyException e) {
                    throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + e.getMessage(), e);
                }
            }
        };
        parametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                if (spec != null && !(spec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("DH can only take a UserKeyingMaterialSpec");
                }
                return FipsDH.DH;
            }
        };
    }

    static class AlgorithmParametersSpi
    extends DHAlgorithmParametersSpi {
        AlgorithmParametersSpi(String algorithm) {
            super(algorithm);
        }

        protected byte[] localGetEncoded() throws IOException {
            DHParameter param = new DHParameter(this.currentSpec.getP(), this.currentSpec.getG(), this.currentSpec.getL());
            return param.toASN1Primitive().getEncoded("DER");
        }

        protected void localInit(byte[] params) throws IOException {
            DHParameter param = DHParameter.getInstance(params);
            this.currentSpec = param.getL() == null ? new DHDomainParameterSpec(param.getP(), null, param.getG()) : new DHDomainParameterSpec(param.getP(), null, param.getG(), param.getL().intValue());
        }

        protected String engineToString() {
            return "DH Parameters";
        }
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPrivateKeySpec) {
                return new ProvDHPrivateKey((Algorithm)FipsDH.ALGORITHM, (DHPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPublicKeySpec) {
                try {
                    return new ProvDHPublicKey((Algorithm)FipsDH.ALGORITHM, (DHPublicKeySpec)keySpec);
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException("invalid KeySpec: " + e.getMessage(), e);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (spec.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
                DHPrivateKey k = (DHPrivateKey)key;
                return new DHPrivateKeySpec(k.getX(), k.getParams().getP(), k.getParams().getG());
            }
            if (spec.isAssignableFrom(DHPublicKeySpec.class) && key instanceof DHPublicKey) {
                DHPublicKey k = (DHPublicKey)key;
                return new DHPublicKeySpec(k.getY(), k.getParams().getP(), k.getParams().getG());
            }
            return super.engineGetKeySpec(key, spec);
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvDHPublicKey(publicKeyConverter.convertKey(FipsDH.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvDHPrivateKey(privateKeyConverter.convertKey(FipsDH.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        public PrivateKey generatePrivate(PrivateKeyInfo info) throws IOException {
            return new ProvDHPrivateKey(new AsymmetricDHPrivateKey((Algorithm)FipsDH.ALGORITHM, info));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo info) throws IOException {
            return new ProvDHPublicKey(new AsymmetricDHPublicKey((Algorithm)FipsDH.ALGORITHM, info));
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private FipsDH.KeyGenParameters param;
        private FipsDH.KeyPairGenerator engine;
        private int strength = 2048;
        private SecureRandom random = null;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider fipsProvider) {
            super("DH");
            this.fipsProvider = fipsProvider;
            this.random = fipsProvider.getDefaultSecureRandom();
        }

        public void initialize(int strength) {
            this.initialize(strength, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            this.param = dhParams instanceof DHDomainParameterSpec ? new FipsDH.KeyGenParameters(new DHDomainParameters(dhParams.getP(), ((DHDomainParameterSpec)dhParams).getQ(), dhParams.getG(), dhParams.getL())) : new FipsDH.KeyGenParameters(new DHDomainParameters(dhParams.getP(), null, dhParams.getG(), dhParams.getL()));
            try {
                this.engine = new FipsDH.KeyPairGenerator(this.param, random);
            }
            catch (FipsUnapprovedOperationError e) {
                throw new InvalidAlgorithmParameterException(e.getMessage(), (Throwable)((Object)e));
            }
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DHDomainParameters dhParams = (DHDomainParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, this.strength);
                if (dhParams != null) {
                    this.param = new FipsDH.KeyGenParameters(dhParams);
                } else {
                    FipsDH.DomainParametersGenerator gen = new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.random);
                    this.param = new FipsDH.KeyGenParameters(gen.generateDomainParameters());
                }
                this.engine = new FipsDH.KeyPairGenerator(this.param, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> pair = this.engine.generateKeyPair();
            AsymmetricDHPublicKey pub = pair.getPublicKey();
            AsymmetricDHPrivateKey priv = pair.getPrivateKey();
            return new KeyPair(new ProvDHPublicKey(pub), new ProvDHPrivateKey(priv));
        }
    }

    static class MQVAlgorithmParametersSpi
    extends DHAlgorithmParametersSpi {
        MQVAlgorithmParametersSpi() {
            super("MQV");
        }

        protected byte[] localGetEncoded() throws IOException {
            DomainParameters param;
            DHDomainParameterSpec domainParameterSpec = this.currentSpec;
            DHValidationParameters dhValidationParameters = domainParameterSpec.getValidationParameters();
            try {
                param = dhValidationParameters != null ? new DomainParameters(this.currentSpec.getP(), this.currentSpec.getG(), domainParameterSpec.getQ(), domainParameterSpec.getJ(), new ValidationParams(dhValidationParameters.getSeed(), dhValidationParameters.getCounter())) : new DomainParameters(this.currentSpec.getP(), this.currentSpec.getG(), domainParameterSpec.getQ(), domainParameterSpec.getJ(), null);
            }
            catch (Exception e) {
                throw new ProvIOException("Exception creating parameters: " + e.getMessage(), e);
            }
            return param.toASN1Primitive().getEncoded("DER");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof DHDomainParameterSpec)) {
                throw new InvalidParameterSpecException("DHDomainParameterSpec required to initialise a MQV/X9 AlgorithmParameters");
            }
            this.currentSpec = (DHDomainParameterSpec)paramSpec;
        }

        protected void localInit(byte[] params) throws IOException {
            DomainParameters param = DomainParameters.getInstance(params);
            this.currentSpec = param.getValidationParams() != null ? new DHDomainParameterSpec(param.getP(), param.getQ(), param.getG(), param.getJ(), 0, new DHValidationParameters(param.getValidationParams().getSeed(), param.getValidationParams().getPgenCounter().intValue())) : new DHDomainParameterSpec(param.getP(), param.getQ(), param.getG(), param.getJ(), 0, null);
        }

        protected String engineToString() {
            return "MQV/X9 DH Parameters";
        }
    }
}

