/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.PEMUtil;
import org.bouncycastle.jcajce.provider.PKIXCertPath;
import org.bouncycastle.jcajce.provider.X509CRLObject;
import org.bouncycastle.jcajce.provider.X509CertificateObject;
import org.bouncycastle.util.io.Streams;

class CertificateFactory
extends CertificateFactorySpi {
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private final BouncyCastleFipsProvider fipsProvider;
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1StreamParser currentAsn1Parser = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;
    private SignedDataParser signedDataParser = null;

    CertificateFactory(BouncyCastleFipsProvider fipsProvider) {
        this.fipsProvider = fipsProvider;
    }

    private java.security.cert.Certificate readDERCertificate() throws IOException, CertificateParsingException {
        ASN1Encodable o;
        ASN1SequenceParser seq = (ASN1SequenceParser)this.currentAsn1Parser.readObject();
        ASN1Encodable first = seq.readObject();
        if (first instanceof ASN1ObjectIdentifier && first.equals(PKCSObjectIdentifiers.signedData)) {
            ASN1SetParser setParser;
            this.signedDataParser = SignedDataParser.getInstance(((BERTaggedObjectParser)seq.readObject()).getObjectParser(1, true));
            this.signedDataParser.getDigestAlgorithms().toASN1Primitive();
            ASN1Encodable content = this.signedDataParser.getEncapContentInfo().getContent(0);
            if (content != null) {
                content.toASN1Primitive();
            }
            if ((setParser = this.signedDataParser.getCertificates()) != null) {
                this.sData = this.pruneSet(setParser);
                return this.getCertificate();
            }
            return null;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(first.toASN1Primitive());
        while ((o = seq.readObject()) != null) {
            v.add(o.toASN1Primitive());
        }
        return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(new DERSequence(v)));
    }

    private ASN1Set pruneSet(ASN1SetParser setParser) {
        ASN1Set certs = ASN1Set.getInstance(setParser.toASN1Primitive());
        ASN1EncodableVector v = new ASN1EncodableVector();
        Enumeration en = certs.getObjects();
        while (en.hasMoreElements()) {
            ASN1Encodable obj = (ASN1Encodable)en.nextElement();
            if (!(obj instanceof ASN1Sequence)) continue;
            v.add(obj);
        }
        return new DERSet(v);
    }

    private java.security.cert.Certificate getCertificate() throws CertificateParsingException, IOException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                ASN1Encodable obj;
                if (!((obj = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                if (this.sDataObjectCount == this.sData.size()) {
                    ASN1SetParser setParser = this.signedDataParser.getCrls();
                    if (setParser != null) {
                        setParser.toASN1Primitive();
                    }
                    if ((setParser = this.signedDataParser.getSignerInfos()) != null) {
                        setParser.toASN1Primitive();
                    }
                }
                return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(obj));
            }
        }
        return null;
    }

    private java.security.cert.Certificate readPEMCertificate(InputStream in) throws IOException, CertificateParsingException {
        ASN1Sequence seq = PEM_CERT_PARSER.readPEMObject(in);
        if (seq != null) {
            return new X509CertificateObject(this.fipsProvider, Certificate.getInstance(seq));
        }
        return null;
    }

    protected CRL createCRL(CertificateList c) throws CRLException {
        return new X509CRLObject(this.fipsProvider, c);
    }

    private CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        ASN1Sequence seq = PEM_CRL_PARSER.readPEMObject(in);
        if (seq != null) {
            return this.createCRL(CertificateList.getInstance(seq));
        }
        return null;
    }

    private CRL readDERCRL() throws IOException, CRLException {
        ASN1Encodable o;
        ASN1SequenceParser seq = (ASN1SequenceParser)this.currentAsn1Parser.readObject();
        ASN1Encodable first = seq.readObject();
        if (first instanceof ASN1ObjectIdentifier && first.equals(PKCSObjectIdentifiers.signedData)) {
            this.signedDataParser = SignedDataParser.getInstance(((BERTaggedObjectParser)seq.readObject()).getObjectParser(1, true));
            this.signedDataParser.getDigestAlgorithms().toASN1Primitive();
            ASN1Encodable content = this.signedDataParser.getEncapContentInfo().getContent(0);
            if (content != null) {
                content.toASN1Primitive();
            }
            this.signedDataParser.getCertificates().toASN1Primitive();
            ASN1SetParser setParser = this.signedDataParser.getCrls();
            if (setParser != null) {
                this.sCrlData = this.pruneSet(setParser);
                return this.getCRL();
            }
            return null;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(first.toASN1Primitive());
        while ((o = seq.readObject()) != null) {
            v.add(o.toASN1Primitive());
        }
        return this.createCRL(CertificateList.getInstance(new DERSequence(v)));
    }

    private CRL getCRL() throws CRLException, IOException {
        if (this.sCrlData != null) {
            while (this.sCrlDataObjectCount < this.sCrlData.size()) {
                ASN1SetParser setParser;
                ASN1Encodable obj;
                if (!((obj = this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)) instanceof ASN1Sequence)) continue;
                if (this.sCrlDataObjectCount == this.sCrlData.size() && (setParser = this.signedDataParser.getSignerInfos()) != null) {
                    setParser.toASN1Primitive();
                }
                return this.createCRL(CertificateList.getInstance(obj));
            }
        }
        return null;
    }

    private java.security.cert.Certificate readCertificate(InputStream in) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != in) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        java.security.cert.Certificate certificate = null;
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    certificate = this.getCertificate();
                } else {
                    this.sData = null;
                    this.sDataObjectCount = 0;
                }
            }
            if (certificate == null) {
                InputStream pis = in.markSupported() ? in : new ByteArrayInputStream(Streams.readAll(in));
                pis.mark(1);
                int tag = pis.read();
                if (tag == -1) {
                    return null;
                }
                pis.reset();
                if (tag != 48) {
                    certificate = this.readPEMCertificate(pis);
                } else {
                    this.currentAsn1Parser = new ASN1StreamParser(pis);
                    certificate = this.readDERCertificate();
                }
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e.getMessage(), e);
        }
        return certificate;
    }

    public java.security.cert.Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        java.security.cert.Certificate certificate = this.readCertificate(in);
        if (certificate != null) {
            return certificate;
        }
        throw new CertificateException("Unexpected data detected in stream");
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        java.security.cert.Certificate certificate;
        ArrayList<java.security.cert.Certificate> certs = new ArrayList<java.security.cert.Certificate>();
        BufferedInputStream in = new BufferedInputStream(inStream);
        while ((certificate = this.readCertificate(in)) != null) {
            certs.add(certificate);
        }
        return certs;
    }

    private CRL readCrl(InputStream inStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inStream) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        CRL crl = null;
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    crl = this.getCRL();
                } else {
                    this.sCrlData = null;
                    this.sCrlDataObjectCount = 0;
                }
            }
            if (crl == null) {
                InputStream pis = inStream.markSupported() ? inStream : new ByteArrayInputStream(Streams.readAll(inStream));
                pis.mark(1);
                int tag = pis.read();
                if (tag == -1) {
                    return null;
                }
                pis.reset();
                if (tag != 48) {
                    crl = this.readPEMCRL(pis);
                } else {
                    this.currentAsn1Parser = new ASN1StreamParser(pis);
                    crl = this.readDERCRL();
                }
            }
        }
        catch (CRLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CRLException(e.toString(), e);
        }
        return crl;
    }

    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        CRL crl = this.readCrl(inStream);
        if (crl != null) {
            return crl;
        }
        throw new CRLException("unexpected data detected in stream");
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        CRL crl;
        ArrayList<CRL> crls = new ArrayList<CRL>();
        BufferedInputStream in = new BufferedInputStream(inStream);
        while ((crl = this.readCrl(in)) != null) {
            crls.add(crl);
        }
        return crls;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        return new PKIXCertPath(this.fipsProvider, inStream, encoding);
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        for (Object obj : certificates) {
            if (obj == null || obj instanceof X509Certificate) continue;
            throw new CertificateException("List contains non X509Certificate object while creating CertPath\n" + obj.toString());
        }
        return new PKIXCertPath(this.fipsProvider, certificates);
    }
}

