/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.general.DRBG;
import org.bouncycastle.crypto.general.X931RNG;

class X931PseudoRandom
implements DRBG {
    private final X931RNG drbg;

    X931PseudoRandom(X931RNG drbg) {
        this.drbg = drbg;
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        if (additionalInput != null) {
            throw new IllegalArgumentException("X9.31 PRNG does not use additionalInput");
        }
        X931PseudoRandom x931PseudoRandom = this;
        synchronized (x931PseudoRandom) {
            if (this.drbg.generate(output, predictionResistant) < 0) {
                this.drbg.reseed();
                return this.drbg.generate(output, predictionResistant);
            }
            return output.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reseed(byte[] additionalInput) {
        if (additionalInput != null) {
            throw new IllegalArgumentException("X9.31 PRNG does not use additionalInput");
        }
        X931PseudoRandom x931PseudoRandom = this;
        synchronized (x931PseudoRandom) {
            this.drbg.reseed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reseed() {
        X931PseudoRandom x931PseudoRandom = this;
        synchronized (x931PseudoRandom) {
            this.drbg.reseed();
        }
    }
}

