/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PKCS5S1ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    private Digest digest;

    public PKCS5S1ParametersGenerator(T parameters, Digest digest) {
        super(parameters);
        this.digest = digest;
    }

    private byte[] generateDerivedKey() {
        byte[] digestBytes = new byte[this.digest.getDigestSize()];
        this.digest.update(this.password, 0, this.password.length);
        this.digest.update(this.salt, 0, this.salt.length);
        this.digest.doFinal(digestBytes, 0);
        for (int i = 1; i < this.iterationCount; ++i) {
            this.digest.update(digestBytes, 0, digestBytes.length);
            this.digest.doFinal(digestBytes, 0);
        }
        return digestBytes;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        if ((keySize /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + keySize + " bytes long.");
        }
        byte[] dKey = this.generateDerivedKey();
        return new KeyParameterImpl(Arrays.copyOfRange(dKey, 0, keySize));
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        if ((keySize /= 8) + (ivSize /= 8) > this.digest.getDigestSize()) {
            throw new IllegalArgumentException("Can't generate a derived key " + (keySize + ivSize) + " bytes long.");
        }
        byte[] dKey = this.generateDerivedKey();
        return new ParametersWithIV(new KeyParameterImpl(Arrays.copyOfRange(dKey, 0, keySize)), dKey, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
        return ((KeyParameter)this.generateDerivedParameters(keySizeInBytes * 8)).getKey();
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
        ParametersWithIV params = (ParametersWithIV)this.generateDerivedParameters(keySizeInBytes * 8, ivSizeInBytes * 8);
        byte[][] rv = new byte[][]{((KeyParameter)params.getParameters()).getKey(), params.getIV()};
        return rv;
    }
}

