/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final Ed25519 ed25519 = new Ed25519(){

        protected Digest createDigest() {
            return Register.createDigest(FipsSHS.Algorithm.SHA512);
        }
    };
    private final byte[] data = new byte[32];

    public Ed25519PrivateKeyParameters(SecureRandom random) {
        super(true);
        this.ed25519.generatePrivateKey(random, this.data);
    }

    public Ed25519PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.data, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (32 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] publicKey = new byte[32];
        this.ed25519.generatePublicKey(this.data, 0, publicKey, 0);
        return new Ed25519PublicKeyParameters(publicKey, 0);
    }

    public void sign(int algorithm, Ed25519PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        byte[] pk = new byte[32];
        if (null == publicKey) {
            this.ed25519.generatePublicKey(this.data, 0, pk, 0);
        } else {
            publicKey.encode(pk, 0);
        }
        switch (algorithm) {
            case 0: {
                if (null != ctx) {
                    throw new IllegalArgumentException("ctx");
                }
                this.ed25519.sign(this.data, 0, pk, 0, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                this.ed25519.sign(this.data, 0, pk, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 2: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed25519.signPrehash(this.data, 0, pk, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

