/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.DhParametersHelper;
import org.bouncycastle.crypto.internal.params.DhParameters;

class DhParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    DhParametersGenerator() {
    }

    public void init(int size, int certainty, SecureRandom random) {
        this.size = size;
        this.certainty = certainty;
        this.random = random;
    }

    public DhParameters generateParameters() {
        BigInteger[] safePrimes = DhParametersHelper.generateSafePrimes(this.size, this.certainty, this.random);
        BigInteger p = safePrimes[0];
        BigInteger q = safePrimes[1];
        BigInteger g = DhParametersHelper.selectGenerator(p, q, this.random);
        return new DhParameters(p, g, q, TWO);
    }
}

