/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.ProvAES;
import org.bouncycastle.jcajce.provider.ProvARC4;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvBlowfish;
import org.bouncycastle.jcajce.provider.ProvCAST5;
import org.bouncycastle.jcajce.provider.ProvCamellia;
import org.bouncycastle.jcajce.provider.ProvChaCha20;
import org.bouncycastle.jcajce.provider.ProvDES;
import org.bouncycastle.jcajce.provider.ProvDESede;
import org.bouncycastle.jcajce.provider.ProvDH;
import org.bouncycastle.jcajce.provider.ProvDSA;
import org.bouncycastle.jcajce.provider.ProvDSTU4145;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.ProvECGOST3410;
import org.bouncycastle.jcajce.provider.ProvEdEC;
import org.bouncycastle.jcajce.provider.ProvElgamal;
import org.bouncycastle.jcajce.provider.ProvFipsKS;
import org.bouncycastle.jcajce.provider.ProvGOST28147;
import org.bouncycastle.jcajce.provider.ProvGOST3410;
import org.bouncycastle.jcajce.provider.ProvIDEA;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.ProvOpenSSLPBKDF;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.ProvPKIX;
import org.bouncycastle.jcajce.provider.ProvPoly1305;
import org.bouncycastle.jcajce.provider.ProvRC2;
import org.bouncycastle.jcajce.provider.ProvRSA;
import org.bouncycastle.jcajce.provider.ProvRandom;
import org.bouncycastle.jcajce.provider.ProvSEED;
import org.bouncycastle.jcajce.provider.ProvSHACAL2;
import org.bouncycastle.jcajce.provider.ProvSHS;
import org.bouncycastle.jcajce.provider.ProvSecureHash;
import org.bouncycastle.jcajce.provider.ProvSerpent;
import org.bouncycastle.jcajce.provider.ProvSipHash;
import org.bouncycastle.jcajce.provider.ProvSunTLSKDF;
import org.bouncycastle.jcajce.provider.ProvTwofish;
import org.bouncycastle.jcajce.provider.ProvX509;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import sun.security.provider.SecureRandom;
import sun.security.provider.Sun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BouncyCastleFipsProvider
extends Provider {
    private static final String info = "BouncyCastle Security Provider (FIPS edition) v1.0.2.6";
    public static final String PROVIDER_NAME = "BCFIPS";
    private static final Map<String, FipsDRBG.Base> drbgTable = new HashMap<String, FipsDRBG.Base>();
    private static final Map<String, Integer> drbgStrengthTable = new HashMap<String, Integer>();
    private volatile java.security.SecureRandom entropySource;
    private Thread entropyThread = null;
    private EntropyDaemon entropyDaemon = null;
    private FipsDRBG.Base providerDefaultRandomBuilder = FipsDRBG.SHA512;
    private int providerDefaultSecurityStrength = 256;
    private boolean providerDefaultPredictionResistance = true;
    private boolean useThreadLocal = false;
    private int providerRandomPoolSize = 16;
    private boolean hybridSource = false;
    private int providerDefaultRandomSecurityStrength = this.providerDefaultSecurityStrength;
    private final SecureRandomProvider providerDefaultSecureRandomProvider;
    private Map<String, BcService> serviceMap = new HashMap<String, BcService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new HashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();
    private final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public BouncyCastleFipsProvider() {
        this((String)null);
    }

    public BouncyCastleFipsProvider(String config) {
        this(config, null);
    }

    public BouncyCastleFipsProvider(String config, java.security.SecureRandom entropySource) {
        super(PROVIDER_NAME, 1.000206, info);
        if (config != null) {
            if (config.startsWith("C:") || config.startsWith("c:")) {
                this.processConfigString(Strings.toUpperCase(config));
            } else {
                throw new IllegalArgumentException("Unrecognized config string passed to BCFIPS provider.");
            }
        }
        this.entropySource = entropySource;
        this.providerDefaultSecureRandomProvider = this.useThreadLocal ? new ThreadLocalSecureRandomProvider() : new PooledSecureRandomProvider();
        new ProvRandom().configure(this);
        new ProvSHS.SHA1().configure(this);
        new ProvSHS.SHA224().configure(this);
        new ProvSHS.SHA256().configure(this);
        new ProvSHS.SHA384().configure(this);
        new ProvSHS.SHA512().configure(this);
        new ProvSHS.SHA3_224().configure(this);
        new ProvSHS.SHA3_256().configure(this);
        new ProvSHS.SHA3_384().configure(this);
        new ProvSHS.SHA3_512().configure(this);
        if (!this.isDisabled("MD5")) {
            new ProvSecureHash.MD5().configure(this);
        }
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvSecureHash.GOST3411().configure(this);
            new ProvSecureHash.RIPEMD128().configure(this);
            new ProvSecureHash.RIPEMD160().configure(this);
            new ProvSecureHash.RIPEMD256().configure(this);
            new ProvSecureHash.RIPEMD320().configure(this);
            new ProvSecureHash.Tiger().configure(this);
            new ProvSecureHash.Whirlpool().configure(this);
        }
        new ProvDH().configure(this);
        new ProvDSA().configure(this);
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            new ProvEC().configure(this);
        }
        new ProvRSA().configure(this);
        new ProvPBEPBKDF2().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvPBEPBKDF1().configure(this);
            new ProvOpenSSLPBKDF().configure(this);
            new ProvPKCS12().configure(this);
        }
        new ProvAES().configure(this);
        new ProvDESede().configure(this);
        new ProvX509().configure(this);
        new ProvBCFKS().configure(this);
        new ProvFipsKS().configure(this);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            new ProvEdEC().configure(this);
            new ProvDSTU4145().configure(this);
            new ProvElgamal().configure(this);
            new ProvGOST3410().configure(this);
            new ProvECGOST3410().configure(this);
            new ProvBlowfish().configure(this);
            new ProvCAST5().configure(this);
            new ProvRC2().configure(this);
            new ProvGOST28147().configure(this);
            new ProvSEED().configure(this);
            new ProvCamellia().configure(this);
            new ProvChaCha20().configure(this);
            new ProvDES().configure(this);
            new ProvIDEA().configure(this);
            new ProvSerpent().configure(this);
            new ProvSHACAL2().configure(this);
            new ProvTwofish().configure(this);
            new ProvARC4().configure(this);
            new ProvSipHash().configure(this);
            new ProvPoly1305().configure(this);
        }
        if (!Properties.isOverrideSet("org.bouncycastle.jsse.disable_kdf")) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsKeyMaterialParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsKeyMaterialSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsMasterSecretParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsPrfParameterSpec") && BouncyCastleFipsProvider.classExists("sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec")) {
                        new ProvSunTLSKDF().configure(BouncyCastleFipsProvider.this);
                    }
                    return null;
                }
            });
        }
        if (!Properties.isOverrideSet("org.bouncycastle.pkix.disable_certpath")) {
            new ProvPKIX().configure(this);
        }
        if (Properties.isOverrideSet("org.bouncycastle.jca.enable_jks")) {
            new ProvJKS().configure(this);
        }
    }

    @Override
    public Provider configure(String configArg) {
        return new BouncyCastleFipsProvider(configArg);
    }

    private void processConfigString(String config) {
        String[] commands = config.substring(2).split(";");
        boolean enableAllFound = false;
        for (String command : commands) {
            if (command.startsWith("DEFRND")) {
                String rndConfig = this.extractString('[', ']', command).trim();
                while (rndConfig != null) {
                    String rnd;
                    int commaPos = rndConfig.indexOf(",");
                    if (commaPos > 0) {
                        rnd = rndConfig.substring(0, commaPos).trim();
                        rndConfig = rndConfig.substring(commaPos + 1);
                    } else {
                        rnd = rndConfig;
                        rndConfig = null;
                    }
                    if (rnd.equals("TRUE") || rnd.equals("FALSE")) {
                        this.providerDefaultPredictionResistance = Boolean.valueOf(rnd);
                        continue;
                    }
                    if (rnd.equals("LOCAL")) {
                        this.useThreadLocal = true;
                        continue;
                    }
                    if (rnd.startsWith("POOL=")) {
                        this.providerRandomPoolSize = Integer.parseInt(rnd.substring(5));
                        continue;
                    }
                    this.providerDefaultRandomBuilder = drbgTable.get(rnd);
                    if (drbgStrengthTable.containsKey(rnd)) {
                        this.providerDefaultSecurityStrength = drbgStrengthTable.get(rnd);
                    }
                    if (this.providerDefaultRandomBuilder != null) continue;
                    throw new IllegalArgumentException("Unknown DEFRND - " + rnd + " - found in config string.");
                }
                continue;
            }
            if (command.startsWith("HYBRID")) {
                this.hybridSource = true;
                this.entropyDaemon = new EntropyDaemon();
                this.entropyThread = new Thread((Runnable)this.entropyDaemon, "BC FIPS Entropy Daemon");
                this.entropyThread.setDaemon(true);
                this.entropyThread.start();
                continue;
            }
            if (!command.startsWith("ENABLE") || !"ENABLE{ALL}".equals(command)) continue;
            enableAllFound = true;
        }
        if (!enableAllFound) {
            throw new IllegalArgumentException("No ENABLE command found in config string.");
        }
    }

    private String extractString(char startC, char endC, String command) {
        int start = command.indexOf(startC);
        int end = command.indexOf(endC);
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("Unable to parse config: ('" + startC + "', '" + endC + "') missing.");
        }
        return command.substring(start + 1, end);
    }

    int getProviderDefaultSecurityStrength() {
        return this.providerDefaultSecurityStrength;
    }

    FipsDRBG.Base getProviderDefaultRandomBuilder() {
        return this.providerDefaultRandomBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.security.SecureRandom getDefaultSecureRandom() {
        java.security.SecureRandom defRandom = CryptoServicesRegistrar.getSecureRandomIfSet(this.providerDefaultSecureRandomProvider);
        BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
        synchronized (bouncyCastleFipsProvider) {
            if (defRandom instanceof FipsSecureRandom) {
                int securityStrength = ((FipsSecureRandom)defRandom).getSecurityStrength();
                if (securityStrength < this.providerDefaultRandomSecurityStrength) {
                    this.providerDefaultRandomSecurityStrength = securityStrength;
                }
            } else {
                this.providerDefaultRandomSecurityStrength = -1;
            }
        }
        return defRandom;
    }

    EntropySourceProvider getEntropySourceProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                if (BouncyCastleFipsProvider.this.hybridSource) {
                    return new EntropySourceProvider(){

                        public EntropySource get(int bitsRequired) {
                            return new HybridEntropySource(BouncyCastleFipsProvider.this.entropyDaemon, bitsRequired);
                        }
                    };
                }
                if (BouncyCastleFipsProvider.this.entropySource != null) {
                    return new BasicEntropySourceProvider(BouncyCastleFipsProvider.this.entropySource, true);
                }
                return new BasicEntropySourceProvider(BouncyCastleFipsProvider.getCoreSecureRandom(), true);
            }
        });
    }

    private static java.security.SecureRandom getCoreSecureRandom() {
        boolean hasGetInstanceStrong = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<java.security.SecureRandom> def = java.security.SecureRandom.class;
                    return def.getMethod("getInstanceStrong", new Class[0]) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        if (hasGetInstanceStrong) {
            return AccessController.doPrivileged(new PrivilegedAction<java.security.SecureRandom>(){

                @Override
                public java.security.SecureRandom run() {
                    try {
                        return (java.security.SecureRandom)java.security.SecureRandom.class.getMethod("getInstanceStrong", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        return new CoreSecureRandom();
                    }
                }
            });
        }
        return new CoreSecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultRandomSecurityStrength() {
        BouncyCastleFipsProvider bouncyCastleFipsProvider = this;
        synchronized (bouncyCastleFipsProvider) {
            return this.providerDefaultRandomSecurityStrength;
        }
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAttribute(String type, ASN1ObjectIdentifier oid, String attributeName, String attributeValue) {
        String attributeKey = type + "." + oid + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAttributes(String key, Map<String, String> attributes) {
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            this.addAttribute(key, attrEntry.getKey(), attrEntry.getValue());
        }
    }

    void addAttributes(String type, ASN1ObjectIdentifier oid, Map<String, String> attributes) {
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            this.addAttribute(type, oid, attrEntry.getKey(), attrEntry.getValue());
        }
    }

    void addAlgorithmImplementation(String key, String className, Map<String, String> attributes, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.addAttributes(key, attributes);
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlgorithmImplementation(String type, ASN1ObjectIdentifier oid, String className, EngineCreator creator) {
        String key1 = type + "." + oid;
        if (this.containsKey(key1)) {
            throw new IllegalStateException("duplicate provider key (" + key1 + ") found");
        }
        this.addAttribute(type, oid, "ImplementedIn", "Software");
        this.put(key1, className);
        this.creatorMap.put(className, creator);
        this.addAlias(type, oid.getId(), "OID." + oid.getId());
    }

    void addAlgorithmImplementation(String type, ASN1ObjectIdentifier oid, String className, Map<String, String> attributes, EngineCreator creator) {
        String key1 = type + "." + oid;
        if (this.containsKey(key1)) {
            throw new IllegalStateException("duplicate provider key (" + key1 + ") found");
        }
        this.addAttributes(type, oid, attributes);
        this.addAttribute(type, oid, "ImplementedIn", "Software");
        this.put(key1, className);
        this.creatorMap.put(className, creator);
        this.addAlias(type, oid.getId(), "OID." + oid.getId());
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    void addAlias(String type, String name, String ... aliases) {
        if (!this.containsKey(type + "." + name)) {
            throw new IllegalStateException("primary key (" + type + "." + name + ") not found");
        }
        for (String alias : aliases) {
            this.doPut("Alg.Alias." + type + "." + alias, name);
        }
    }

    void addAlias(String type, String name, ASN1ObjectIdentifier ... oids) {
        if (!this.containsKey(type + "." + name)) {
            throw new IllegalStateException("primary key (" + type + "." + name + ") not found");
        }
        for (ASN1ObjectIdentifier oid : oids) {
            this.doPut("Alg.Alias." + type + "." + oid, name);
            this.doPut("Alg.Alias." + type + ".OID." + oid, name);
        }
    }

    private void doPut(String key, String name) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, name);
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase(algorithm);
        BcService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + realName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String sKey = (String)entry.getKey();
                if (sKey.startsWith(aliasString) && entry.getValue().equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)entry.getValue());
            }
            service = new BcService(this, type, upperCaseAlgName, className, aliases, this.getAttributeMap(attributes), this.creatorMap.get(className));
            this.serviceMap.put(type + "." + upperCaseAlgName, service);
        }
        return service;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> serviceSet = super.getServices();
        LinkedHashSet<Provider.Service> bcServiceSet = new LinkedHashSet<Provider.Service>();
        for (Provider.Service service : serviceSet) {
            bcServiceSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return bcServiceSet;
    }

    void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        this.keyInfoConverters.put(oid, keyInfoConverter);
    }

    private boolean isDisabled(String algName) {
        String disabled = Properties.getPropertyValue("org.bouncycastle.disabledAlgorithms");
        return disabled != null && disabled.indexOf(algName) >= 0;
    }

    private byte[] generatePersonalizationString(int rngIndex) {
        return Arrays.concatenate(Pack.intToBigEndian(rngIndex), Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = this.attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        this.attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    private static boolean classExists(String className) {
        try {
            Class def = ClassUtil.lookup(className);
            return def != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = this.keyInfoConverters.get(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = this.keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }

    static {
        drbgTable.put("SHA1", FipsDRBG.SHA1);
        drbgTable.put("SHA224", FipsDRBG.SHA224);
        drbgTable.put("SHA256", FipsDRBG.SHA256);
        drbgTable.put("SHA384", FipsDRBG.SHA384);
        drbgTable.put("SHA512", FipsDRBG.SHA512);
        drbgTable.put("SHA512(224)", FipsDRBG.SHA512_224);
        drbgTable.put("SHA512(256)", FipsDRBG.SHA512_256);
        drbgTable.put("HMACSHA1", FipsDRBG.SHA1_HMAC);
        drbgTable.put("HMACSHA224", FipsDRBG.SHA224_HMAC);
        drbgTable.put("HMACSHA256", FipsDRBG.SHA256_HMAC);
        drbgTable.put("HMACSHA384", FipsDRBG.SHA384_HMAC);
        drbgTable.put("HMACSHA512", FipsDRBG.SHA512_HMAC);
        drbgTable.put("HMACSHA512(224)", FipsDRBG.SHA512_224_HMAC);
        drbgTable.put("HMACSHA512(256)", FipsDRBG.SHA512_256_HMAC);
        drbgTable.put("CTRAES128", FipsDRBG.CTR_AES_128);
        drbgTable.put("CTRAES192", FipsDRBG.CTR_AES_192);
        drbgTable.put("CTRAES256", FipsDRBG.CTR_AES_256);
        drbgTable.put("CTRDESEDE", FipsDRBG.CTR_Triple_DES_168);
        drbgStrengthTable.put("SHA1", 128);
        drbgStrengthTable.put("SHA224", 192);
        drbgStrengthTable.put("SHA256", 256);
        drbgStrengthTable.put("SHA384", 256);
        drbgStrengthTable.put("SHA512", 256);
        drbgStrengthTable.put("SHA512(224)", 192);
        drbgStrengthTable.put("SHA512(256)", 256);
        drbgStrengthTable.put("HMACSHA1", 128);
        drbgStrengthTable.put("HMACSHA224", 192);
        drbgStrengthTable.put("HMACSHA256", 256);
        drbgStrengthTable.put("HMACSHA384", 256);
        drbgStrengthTable.put("HMACSHA512", 256);
        drbgStrengthTable.put("HMACSHA512(224)", 192);
        drbgStrengthTable.put("HMACSHA512(256)", 256);
        drbgStrengthTable.put("CTRAES128", 128);
        drbgStrengthTable.put("CTRAES192", 192);
        drbgStrengthTable.put("CTRAES256", 256);
        drbgStrengthTable.put("CTRDESEDE", 112);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BcService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                FipsStatus.isReady();
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }

    private static class CoreSecureRandom
    extends java.security.SecureRandom {
        CoreSecureRandom() {
            super(new SecureRandom(), CoreSecureRandom.getSunProvider());
        }

        private static Provider getSunProvider() {
            try {
                Class<?> provClass = Class.forName("sun.security.jca.Providers");
                Method method = provClass.getMethod("getSunProvider", new Class[0]);
                return (Provider)method.invoke(provClass, new Object[0]);
            }
            catch (Exception e) {
                return new Sun();
            }
        }
    }

    private static class EntropyDaemon
    implements Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();

        private EntropyDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTask(Runnable task) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.add(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                }
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class HybridEntropySource
    implements EntropySource {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final FipsSecureRandom drbg;
        private final SignallingEntropySource entropySource;
        private final int bytesRequired;

        HybridEntropySource(EntropyDaemon entropyDaemon, int bitsRequired) {
            java.security.SecureRandom baseRandom = BouncyCastleFipsProvider.getCoreSecureRandom();
            this.bytesRequired = (bitsRequired + 7) / 8;
            this.entropySource = new SignallingEntropySource(entropyDaemon, this.seedAvailable, baseRandom, 256);
            this.drbg = FipsDRBG.SHA512.fromEntropySource(new EntropySourceProvider(){

                public EntropySource get(int bitsRequired) {
                    return HybridEntropySource.this.entropySource;
                }
            }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).build(baseRandom.generateSeed(32), false, null);
        }

        public boolean isPredictionResistant() {
            return true;
        }

        public byte[] getEntropy() {
            byte[] entropy = new byte[this.bytesRequired];
            if (this.samples.getAndIncrement() > 20) {
                if (this.seedAvailable.getAndSet(false)) {
                    this.samples.set(0);
                    this.drbg.reseed();
                } else {
                    this.entropySource.schedule();
                }
            }
            this.drbg.nextBytes(entropy);
            return entropy;
        }

        public int entropySize() {
            return this.bytesRequired * 8;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntropyGatherer
        implements Runnable {
            private final int numBytes;
            private final java.security.SecureRandom baseRandom;
            private final AtomicBoolean seedAvailable;
            private final AtomicReference<byte[]> entropy;

            EntropyGatherer(int numBytes, java.security.SecureRandom baseRandom, AtomicBoolean seedAvailable, AtomicReference<byte[]> entropy) {
                this.numBytes = numBytes;
                this.baseRandom = baseRandom;
                this.seedAvailable = seedAvailable;
                this.entropy = entropy;
            }

            private void sleep(long ms) {
                try {
                    Thread.sleep(ms);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void run() {
                byte[] rn;
                long ms;
                String pause = Properties.getPropertyValue("org.bouncycastle.drbg.gather_pause_secs");
                if (pause != null) {
                    try {
                        ms = Long.parseLong(pause) * 1000L;
                    }
                    catch (Exception e) {
                        ms = 5000L;
                    }
                } else {
                    ms = 5000L;
                }
                byte[] seed = new byte[this.numBytes];
                for (int i = 0; i < this.numBytes / 8; ++i) {
                    this.sleep(ms);
                    rn = this.baseRandom.generateSeed(8);
                    System.arraycopy(rn, 0, seed, i * 8, rn.length);
                }
                int extra = this.numBytes - this.numBytes / 8 * 8;
                if (extra != 0) {
                    this.sleep(ms);
                    rn = this.baseRandom.generateSeed(extra);
                    System.arraycopy(rn, 0, seed, seed.length - rn.length, rn.length);
                }
                this.entropy.set(seed);
                this.seedAvailable.set(true);
            }
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final EntropyDaemon entropyDaemon;
            private final AtomicBoolean seedAvailable;
            private final java.security.SecureRandom baseRandom;
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(EntropyDaemon entropyDaemon, AtomicBoolean seedAvailable, java.security.SecureRandom baseRandom, int bitsRequired) {
                this.entropyDaemon = entropyDaemon;
                this.seedAvailable = seedAvailable;
                this.baseRandom = baseRandom;
                this.byteLength = (bitsRequired + 7) / 8;
            }

            public boolean isPredictionResistant() {
                return true;
            }

            public byte[] getEntropy() {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                this.schedule();
                return seed;
            }

            void schedule() {
                if (!this.scheduled.getAndSet(true)) {
                    this.entropyDaemon.addTask(new EntropyGatherer(this.byteLength, this.baseRandom, this.seedAvailable, this.entropy));
                }
            }

            public int entropySize() {
                return this.byteLength * 8;
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<java.security.SecureRandom>[] providerDefaultRandom;
        private final AtomicInteger providerDefaultRandomCount;

        PooledSecureRandomProvider() {
            this.providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.this.providerRandomPoolSize];
            this.providerDefaultRandomCount = new AtomicInteger(0);
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public java.security.SecureRandom get() {
            int rngIndex = this.providerDefaultRandomCount.getAndSet((this.providerDefaultRandomCount.get() + 1) % this.providerDefaultRandom.length);
            if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
            AtomicReference<java.security.SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.providerDefaultRandom[rngIndex].compareAndSet(null, BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString(rngIndex)).build(seedSource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[rngIndex].get();
            }
        }
    }

    private class ThreadLocalSecureRandomProvider
    implements SecureRandomProvider {
        final ThreadLocal<FipsSecureRandom> defaultRandoms = new ThreadLocal();

        private ThreadLocalSecureRandomProvider() {
        }

        public java.security.SecureRandom get() {
            if (this.defaultRandoms.get() == null) {
                EntropySourceProvider entropySourceProvider = BouncyCastleFipsProvider.this.getEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(BouncyCastleFipsProvider.this.providerDefaultSecurityStrength / 2 + 1);
                this.defaultRandoms.set(BouncyCastleFipsProvider.this.providerDefaultRandomBuilder.fromEntropySource(entropySourceProvider).setPersonalizationString(BouncyCastleFipsProvider.this.generatePersonalizationString((int)Thread.currentThread().getId())).build(seedSource.getEntropy(), BouncyCastleFipsProvider.this.providerDefaultPredictionResistance, Strings.toByteArray("Bouncy Castle FIPS Provider")));
            }
            return this.defaultRandoms.get();
        }
    }
}

