/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBGUtils;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.SP80090DRBG;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.encoders.Hex;

class HashSP800DRBG
implements SP80090DRBG {
    private static final byte[] ZERO = new byte[]{0};
    private static final byte[] ONE = new byte[]{1};
    private static final long RESEED_MAX = 0x800000000000L;
    private static final int MAX_BITS_REQUEST = 262144;
    private static final Hashtable seedlens = new Hashtable();
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[]> reseedVs = new HashMap<String, byte[]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private Digest _digest;
    private byte[] _V;
    private byte[] _C;
    private long _reseedCounter;
    private EntropySource _entropySource;
    private int _securityStrength;
    private int _seedLength;

    public HashSP800DRBG(Digest digest, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        this.init(digest, securityStrength, entropySource, personalizationString, nonce);
    }

    private void init(Digest digest, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        if (securityStrength > DRBGUtils.getMaxSecurityStrength(digest)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < securityStrength) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._digest = digest;
        this._entropySource = entropySource;
        this._securityStrength = securityStrength;
        this._seedLength = (Integer)seedlens.get(digest.getAlgorithmName());
        byte[] entropy = this.getEntropy();
        byte[] seedMaterial = Arrays.concatenate(entropy, nonce, personalizationString);
        Arrays.fill(entropy, (byte)0);
        this.reseedFromSeedMaterial(seedMaterial);
    }

    public int getBlockSize() {
        return this._digest.getDigestSize() * 8;
    }

    public int getSecurityStrength() {
        return this._securityStrength;
    }

    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        int numberOfBits = output.length * 8;
        if (numberOfBits > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (predictionResistant) {
            this.reseed(additionalInput);
            additionalInput = null;
        }
        if (this._reseedCounter > 0x800000000000L) {
            return -1;
        }
        if (additionalInput != null) {
            byte[] newInput = new byte[1 + this._V.length + additionalInput.length];
            newInput[0] = 2;
            System.arraycopy(this._V, 0, newInput, 1, this._V.length);
            System.arraycopy(additionalInput, 0, newInput, 1 + this._V.length, additionalInput.length);
            byte[] w = this.hash(newInput);
            this.addTo(this._V, w);
        }
        byte[] rv = this.hashgen(this._V, numberOfBits);
        byte[] subH = new byte[this._V.length + 1];
        System.arraycopy(this._V, 0, subH, 1, this._V.length);
        subH[0] = 3;
        byte[] H = this.hash(subH);
        this.addTo(this._V, H);
        this.addTo(this._V, this._C);
        byte[] c = new byte[]{(byte)(this._reseedCounter >> 24), (byte)(this._reseedCounter >> 16), (byte)(this._reseedCounter >> 8), (byte)this._reseedCounter};
        this.addTo(this._V, c);
        ++this._reseedCounter;
        System.arraycopy(rv, 0, output, 0, output.length);
        return numberOfBits;
    }

    private void addTo(byte[] longer, byte[] shorter) {
        int res;
        int i;
        int carry = 0;
        for (i = 1; i <= shorter.length; ++i) {
            res = (longer[longer.length - i] & 0xFF) + (shorter[shorter.length - i] & 0xFF) + carry;
            carry = res > 255 ? 1 : 0;
            longer[longer.length - i] = (byte)res;
        }
        for (i = shorter.length + 1; i <= longer.length; ++i) {
            res = (longer[longer.length - i] & 0xFF) + carry;
            carry = res > 255 ? 1 : 0;
            longer[longer.length - i] = (byte)res;
        }
    }

    public void reseed(byte[] additionalInput) {
        byte[] entropy = this.getEntropy();
        byte[] seedMaterial = Arrays.concatenate(ONE, this._V, entropy, additionalInput);
        Arrays.fill(entropy, (byte)0);
        this.reseedFromSeedMaterial(seedMaterial);
    }

    private void reseedFromSeedMaterial(byte[] seedMaterial) {
        this._V = this.hashSeedMaterial(seedMaterial);
        this._C = this.hashSeedMaterial(Arrays.concatenate(ZERO, this._V));
        this._reseedCounter = 1L;
    }

    private byte[] hashSeedMaterial(byte[] seedMaterial) {
        try {
            byte[] byArray = DRBGUtils.hash_df(this._digest, seedMaterial, this._seedLength);
            return byArray;
        }
        finally {
            Arrays.fill(seedMaterial, (byte)0);
        }
    }

    private byte[] getEntropy() {
        byte[] entropy = this._entropySource.getEntropy();
        if (entropy == null || entropy.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return entropy;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Arrays.fill(this._V, (byte)0);
        Arrays.fill(this._C, (byte)0);
    }

    public VariantInternalKatTest createSelfTest(FipsAlgorithm algorithm) {
        return new VariantInternalKatTest(algorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] origV = HashSP800DRBG.this._V;
                byte[] origC = HashSP800DRBG.this._C;
                long origReseedCounter = HashSP800DRBG.this._reseedCounter;
                EntropySource origEntropySource = HashSP800DRBG.this._entropySource;
                int origSeedLength = HashSP800DRBG.this._seedLength;
                int origSecurityStrength = HashSP800DRBG.this._securityStrength;
                try {
                    int entropyStrength;
                    byte[] nonce;
                    byte[] personalization;
                    block16: {
                        block15: {
                            block14: {
                                personalization = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                nonce = Hex.decode("2021222324");
                                entropyStrength = DRBGUtils.getMaxSecurityStrength(HashSP800DRBG.this._digest);
                                byte[][] expected = (byte[][])kats.get(this.algorithm.getName());
                                HashSP800DRBG.this.init(HashSP800DRBG.this._digest, HashSP800DRBG.this._securityStrength, new DRBGUtils.KATEntropyProvider().get(entropyStrength), personalization, nonce);
                                byte[] output = new byte[expected[0].length];
                                HashSP800DRBG.this.generate(output, null, true);
                                if (!Arrays.areEqual(expected[0], output)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                output = new byte[expected[1].length];
                                HashSP800DRBG.this.generate(output, null, true);
                                if (!Arrays.areEqual(expected[1], output)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    HashSP800DRBG.this.init(HashSP800DRBG.this._digest, HashSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(entropyStrength), personalization, nonce);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException e) {
                                    if (e.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                HashSP800DRBG.this.init(HashSP800DRBG.this._digest, HashSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(20), personalization, nonce);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException e) {
                                if (e.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            HashSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(entropyStrength);
                            HashSP800DRBG.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException e) {
                            if (e.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        HashSP800DRBG.this.init(HashSP800DRBG.this._digest, entropyStrength + 1, new DRBGUtils.KATEntropyProvider().get(entropyStrength), personalization, nonce);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException e) {
                        if (!e.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    HashSP800DRBG.access$002(HashSP800DRBG.this, origV);
                    HashSP800DRBG.access$102(HashSP800DRBG.this, origC);
                    HashSP800DRBG.this._reseedCounter = origReseedCounter;
                    HashSP800DRBG.this._entropySource = origEntropySource;
                    HashSP800DRBG.this._seedLength = origSeedLength;
                    HashSP800DRBG.this._securityStrength = origSecurityStrength;
                }
            }
        };
    }

    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm algorithm) {
        return new VariantInternalKatTest(algorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] origV = HashSP800DRBG.this._V;
                byte[] origC = HashSP800DRBG.this._C;
                long origReseedCounter = HashSP800DRBG.this._reseedCounter;
                EntropySource origEntropySource = HashSP800DRBG.this._entropySource;
                int origSeedLength = HashSP800DRBG.this._seedLength;
                int origSecurityStrength = HashSP800DRBG.this._securityStrength;
                try {
                    byte[] additionalInput = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int entropyStrength = DRBGUtils.getMaxSecurityStrength(HashSP800DRBG.this._digest);
                    byte[][] expected = (byte[][])reseedKats.get(this.algorithm.getName());
                    HashSP800DRBG.access$002(HashSP800DRBG.this, Arrays.clone((byte[])reseedVs.get(this.algorithm.getName())));
                    HashSP800DRBG.this._entropySource = new DRBGUtils.KATEntropyProvider().get(entropyStrength);
                    HashSP800DRBG.this.reseed(additionalInput);
                    if (HashSP800DRBG.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byte[] output = new byte[expected[0].length];
                    HashSP800DRBG.this.generate(output, null, false);
                    if (!Arrays.areEqual(expected[0], output)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    output = new byte[expected[1].length];
                    HashSP800DRBG.this.generate(output, null, false);
                    if (!Arrays.areEqual(expected[1], output)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        HashSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(entropyStrength);
                        HashSP800DRBG.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected on reseed");
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    HashSP800DRBG.access$002(HashSP800DRBG.this, origV);
                    HashSP800DRBG.access$102(HashSP800DRBG.this, origC);
                    HashSP800DRBG.this._reseedCounter = origReseedCounter;
                    HashSP800DRBG.this._entropySource = origEntropySource;
                    HashSP800DRBG.this._seedLength = origSeedLength;
                    HashSP800DRBG.this._securityStrength = origSecurityStrength;
                }
            }
        };
    }

    private byte[] hash(byte[] input) {
        byte[] hash = new byte[this._digest.getDigestSize()];
        this.doHash(input, hash);
        return hash;
    }

    private void doHash(byte[] input, byte[] output) {
        this._digest.update(input, 0, input.length);
        this._digest.doFinal(output, 0);
    }

    private byte[] hashgen(byte[] input, int lengthInBits) {
        int digestSize = this._digest.getDigestSize();
        int m = lengthInBits / 8 / digestSize;
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, input.length);
        byte[] W = new byte[lengthInBits / 8];
        byte[] dig = new byte[this._digest.getDigestSize()];
        for (int i = 0; i <= m; ++i) {
            this.doHash(data, dig);
            int bytesToCopy = W.length - i * dig.length > dig.length ? dig.length : W.length - i * dig.length;
            System.arraycopy(dig, 0, W, i * dig.length, bytesToCopy);
            this.addTo(data, ONE);
        }
        return W;
    }

    static /* synthetic */ byte[] access$002(HashSP800DRBG x0, byte[] x1) {
        x0._V = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(HashSP800DRBG x0, byte[] x1) {
        x0._C = x1;
        return x1;
    }

    static {
        seedlens.put("SHA-1", Integers.valueOf(440));
        seedlens.put("SHA-224", Integers.valueOf(440));
        seedlens.put("SHA-256", Integers.valueOf(440));
        seedlens.put("SHA-512/256", Integers.valueOf(440));
        seedlens.put("SHA-512/224", Integers.valueOf(440));
        seedlens.put("SHA-384", Integers.valueOf(888));
        seedlens.put("SHA-512", Integers.valueOf(888));
        kats.put("SHA-1", new byte[][]{Hex.decode("61a50e3970bdb72c7ebf2a6225519ea2f324148123a3503443ec80993a62c4ea6528ff4f5f4fe778"), Hex.decode("71adf1e44be3e0a6af022d6e79aad42a99d8261ef41e06c3efed4ac8bf9687e8e1bab92da552e109")});
        kats.put("SHA-224", new byte[][]{Hex.decode("5be6d688ee42f489506a5a3407380325c633627f8c2458c1d82fc9a3db5787565c9d6c5e0e32b5f0"), Hex.decode("3726e8c434f91c2fdd6d80621e79005f38320932ca9da5edad095eeff18693b7908f936268e20b58")});
        kats.put("SHA-256", new byte[][]{Hex.decode("788dd696649d97295de7ed10a2c55104abb36cd0f262abdc2b8b2b183a3602c3f7513d2a4893b759"), Hex.decode("3db6a852f92035e4890fa53438cf8070020a95ae19f1098f98a4d4bdb65f3c5c2dd4c9fb5483410d")});
        kats.put("SHA-384", new byte[][]{Hex.decode("0536f72f4123b8e438981912b3c60b09d1303a93b7cbe4af13cd3ae01d389720ff687916135bb254"), Hex.decode("80ae6b3d1a120d9f58d427a178c7d73d429758f6039962b66f8afbc7fa758228b13b8f5829588cd6")});
        kats.put("SHA-512", new byte[][]{Hex.decode("ca8387ba70bc7f8cb71e5d25703972ed58c7b5c81649050cdc17a9f646f7bd57857ca715e411d2ca"), Hex.decode("ce2fe5ba54cde888bee0f4863ca70b258ab6e2be31523542a4da66033433fb8e7e394b28198daa1e")});
        kats.put("SHA-512(224)", new byte[][]{Hex.decode("d2a49d96a75e30d65da621aaf5e3e84b1c3d5313aefa2d276c9e1d836615217b67d766ccd342e956"), Hex.decode("32195006d69ed3cdef3d6e5af94ae91c0c3282202b0bfebdc11cc9d4c02f534b0f6bb9a8b8f2b7fe")});
        kats.put("SHA-512(256)", new byte[][]{Hex.decode("881b2a06f0f23921341819bf9cf78ed122850a80ae6c6eaf84e84600d756486c442305a495db0d96"), Hex.decode("c9351dfad36fd8309a5bd598ac4ee9ca22297263f21c21d8481acefea97f5e508134f43959ac7f90")});
        reseedVs.put("SHA-1", Hex.decode("3c01bdbb26f358bab27f267924aa2c9a03fcfdb8"));
        reseedVs.put("SHA-224", Hex.decode("107c5072b799c4771f328304cfe1ebb375eb6ea7f35a3aa753836fad"));
        reseedVs.put("SHA-256", Hex.decode("b5d4045c3f466fa91fe2cc6abe79232a1a57cdf104f7a26e716e0a1e2789df78"));
        reseedVs.put("SHA-384", Hex.decode("1e02dc92a41db610c9bcdc9b5935d1fb9be5639116f6c67e97bc1a3ac649753baba7ba021c813e1fe20c0480213ad371"));
        reseedVs.put("SHA-512", Hex.decode("397118fdac8d83ad98813c50759c85b8c47565d8268bf10da483153b747a74743a58a90e85aa9f705ce6984ffc128db567489817e4092d050d8a1cc596ddc119"));
        reseedVs.put("SHA-512(224)", Hex.decode("2a2aa10c3ca33a979d6cc7d36f94425fb72a09d3d7137c8b9b5b4474"));
        reseedVs.put("SHA-512(256)", Hex.decode("625c3e642852cb343b9b06eae14b47a7da0fd292a7be7b8a251208a65271af36"));
        reseedKats.put("SHA-1", new byte[][]{Hex.decode("657d09ba244bf82e69ee1f860d9bfbf53aebd25827aab770e1f33d4d7bd34596d5f1be2ff0dcde4c"), Hex.decode("01b3e73d42c180963004e6d4d31f38f1bfa3a815c8571f4d9bbed56d5f8afc8f1da145d36232554f")});
        reseedKats.put("SHA-224", new byte[][]{Hex.decode("267c1bc6462b4157320dfe212118370788cff8124af984c3aac5f543228ad69ebdbbf401db50de77"), Hex.decode("9b7b7b267d3d7bd6cead4242b9bae3bcdf812901bcff06dca582dfa01e2db3cada2e77f665db1e20")});
        reseedKats.put("SHA-256", new byte[][]{Hex.decode("05e4940b7cbb02e2bfa3cb03e369379f068ff7d51595403c41579791ee585605b8c4a676bf3a9b52"), Hex.decode("dbb50e0e562f3d83fee0c1f020ffbc04f2eaa8e78009cae0eb8c40628a25dcb4ac096732cc2fa1b4")});
        reseedKats.put("SHA-384", new byte[][]{Hex.decode("5ad1f8c6d18dc235cdb306613926eb9ba67fc910ee7d5483ccc4c9717c576342945aaead78a99bbb"), Hex.decode("03a45f886270781455ff6242d2052b5d84fcea57d95de31fdbd7f973d4027586972da7028fa4c820")});
        reseedKats.put("SHA-512", new byte[][]{Hex.decode("147abe77d9b19bf6331691eeb3571e55afb406d1ddcd7aa5f1b3de71f0d3eb6949ea580764588000"), Hex.decode("59c18dd408b82f930411bfdeea503d0154a77263c934d7888677ce34018307d4dd035effed210979")});
        reseedKats.put("SHA-512(224)", new byte[][]{Hex.decode("b8517f43fb91321ee4b6e2d9478970b4fa727518e0176e97536dbb3a55cba46a29557a8dd9db26d4"), Hex.decode("d9d32c83c6586c3ab235830367733fa405ade3c8ff6d24ea28bf6ba3f4ab4784336a32a2a8535be5")});
        reseedKats.put("SHA-512(256)", new byte[][]{Hex.decode("a33a0d6840f8be385f9aa683cb01e0e0b4d36a1de33e2ea931c015f86f231f574569452950537db7"), Hex.decode("e862780ba48bab8df070be0ca429299a9c744cfa84acb578be5f86155719a23aab6c92b432e9f85b")});
    }
}

