/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.util.Arrays;

public class FipsAgreementParameters
extends FipsParameters {
    final FipsAlgorithm digestAlgorithm;
    final FipsKDF.PRF prfAlgorithm;
    final byte[] salt;
    final FipsKDF.AgreementKDFParametersBuilder kdfType;
    final int outputSize;

    FipsAgreementParameters(FipsAlgorithm agreementAlgorithm, FipsAlgorithm digestAlgorithm) {
        super(agreementAlgorithm);
        this.digestAlgorithm = digestAlgorithm;
        this.prfAlgorithm = null;
        this.salt = null;
        this.kdfType = null;
        this.outputSize = 0;
    }

    FipsAgreementParameters(FipsAlgorithm agreementAlgorithm, FipsKDF.PRF prfAlgorithm, byte[] salt) {
        super(agreementAlgorithm);
        if (prfAlgorithm == null) {
            throw new NullPointerException("prfAlgorithm cannot be null");
        }
        if (salt == null) {
            throw new NullPointerException("salt cannot be null");
        }
        this.digestAlgorithm = null;
        this.prfAlgorithm = prfAlgorithm;
        this.salt = Arrays.clone(salt);
        this.kdfType = null;
        this.outputSize = 0;
    }

    FipsAgreementParameters(FipsAlgorithm agreementAlgorithm, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
        super(agreementAlgorithm);
        if (kdfType == null) {
            throw new NullPointerException("kdfType cannot be null");
        }
        if (outputSize <= 0) {
            throw new IllegalArgumentException("outputSize must be greater than zero");
        }
        this.digestAlgorithm = null;
        this.prfAlgorithm = null;
        this.salt = Arrays.clone(iv);
        this.kdfType = kdfType;
        this.outputSize = outputSize;
    }

    public FipsAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public FipsKDF.PRF getPrfAlgorithm() {
        return this.prfAlgorithm;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }
}

