/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.internal.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.internal.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private List lookupPowX2;

    public void init(byte[] x) {
        int[] y = GCMUtil.asInts(x);
        if (this.lookupPowX2 != null && Arrays.areEqual(y, (int[])this.lookupPowX2.get(0))) {
            return;
        }
        this.lookupPowX2 = new ArrayList(8);
        this.lookupPowX2.add(y);
    }

    public void exponentiateX(long pow, byte[] output) {
        int[] y = GCMUtil.oneAsInts();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                GCMUtil.multiply(y, this.getMultiplier(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        GCMUtil.asBytes(y, output);
    }

    private int[] getMultiplier(int bit) {
        this.ensureAvailable(bit);
        return (int[])this.lookupPowX2.get(bit);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            int[] tmp = (int[])this.lookupPowX2.get(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                GCMUtil.multiply(tmp, tmp);
                this.lookupPowX2.add(tmp);
            } while (++count <= bit);
        }
    }
}

