/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.Shacal2Engine;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public final class SHACAL2 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("SHACAL-2");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB256;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters EAX;
    public static final AuthParameters CMAC;

    private SHACAL2() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm paramAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (SHACAL2.invalidKeySize(keyLength)) {
            throw new IllegalKeyException("SHACAL-2 key must be 128 - 512 bits and a multiple of 64");
        }
        Utils.checkKeyAlgorithm(vKey, ALGORITHM, paramAlgorithm);
        return vKey;
    }

    private static boolean invalidKeySize(int keyLength) {
        return keyLength == 0 || keyLength > 512 || keyLength < 128 || keyLength % 64 != 0;
    }

    static {
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB256 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB256));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB256));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardAEADCipher(forEncryption, SHACAL2.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm, 32, iv, macLenInBits);
        }

        AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 256));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, iv, macSizeInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new Shacal2Engine(), new VariantKatTest<Shacal2Engine>(){

                @Override
                public void evaluate(Shacal2Engine engine) {
                    byte[] input = Hex.decode("00112233445566778899aabbccddeeffaf527210eb79c7a023abf348e70c9045");
                    byte[] output = Hex.decode("a70f7778411101607576d051ad03280690cbe213c7d457388e54fb4f9ed925bb");
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    engine.init(true, key);
                    engine.processBlock(input, 0, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    engine.init(false, key);
                    engine.processBlock(tmp, 0, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(GeneralParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this((GeneralAlgorithm)parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(GeneralAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            this.algorithm = algorithm;
            if (SHACAL2.invalidKeySize(keySizeInBits)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardMac(SHACAL2.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)parameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return Utils.bitsToBytes(parameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardCipher(forEncryption, SHACAL2.validateKey(key, parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, random);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm, 32, algorithm.checkIv(iv, 32));
        }

        Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm algorithm, byte[] iv) {
            return new Parameters(algorithm, iv);
        }
    }
}

