/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private final Ed448 ed448 = new Ed448(){

        protected Xof createXof() {
            return (Xof)Register.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };
    private final byte[] data = new byte[57];

    public Ed448PrivateKeyParameters(SecureRandom random) {
        super(true);
        this.ed448.generatePrivateKey(random, this.data);
    }

    public Ed448PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.data, 0, 57);
    }

    public Ed448PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (57 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed448PublicKeyParameters generatePublicKey() {
        byte[] publicKey = new byte[57];
        this.ed448.generatePublicKey(this.data, 0, publicKey, 0);
        return new Ed448PublicKeyParameters(publicKey, 0);
    }

    public void sign(int algorithm, Ed448PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        byte[] pk = new byte[57];
        if (null == publicKey) {
            this.ed448.generatePublicKey(this.data, 0, pk, 0);
        } else {
            publicKey.encode(pk, 0);
        }
        switch (algorithm) {
            case 0: {
                this.ed448.sign(this.data, 0, pk, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed448.signPrehash(this.data, 0, pk, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

