/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.DsaKCalculator;
import org.bouncycastle.crypto.general.RandomDsaKCalculator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;

class EcDsaSigner
implements ECConstants,
DSA {
    private final DsaKCalculator kCalculator;
    private EcKeyParameters key;
    private SecureRandom random;

    public EcDsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public EcDsaSigner(DsaKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (EcPrivateKeyParameters)rParam.getParameters();
            } else {
                if (this.kCalculator instanceof RandomDsaKCalculator) {
                    throw new IllegalArgumentException("No random provided where one required.");
                }
                this.key = (EcPrivateKeyParameters)param;
            }
        } else {
            this.key = (EcPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        BigInteger k;
        ECPoint p;
        BigInteger r;
        EcDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger d = ((EcPrivateKeyParameters)this.key).getD();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(n, d, message);
        } else {
            this.kCalculator.init(n, this.random);
        }
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        do {
            k = this.kCalculator.nextK();
        } while ((r = (p = basePointMultiplier.multiply(ec.getG(), k).normalize()).getAffineXCoord().toBigInteger().mod(n)).equals(ZERO) || (s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(ZERO));
        return new BigInteger[]{r, s};
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        EcDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        ECPoint G = ec.getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q = ((EcPublicKeyParameters)this.key).getQ(), u2).normalize();
        if (point.isInfinity()) {
            return false;
        }
        BigInteger v = point.getAffineXCoord().toBigInteger().mod(n);
        return v.equals(r);
    }

    protected BigInteger calculateE(BigInteger n, byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

