/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;

class RsaBlindingParameters
implements CipherParameters {
    private RsaKeyParameters publicKey;
    private BigInteger blindingFactor;

    public RsaBlindingParameters(RsaKeyParameters publicKey, BigInteger blindingFactor) {
        if (publicKey instanceof RsaPrivateCrtKeyParameters) {
            throw new IllegalArgumentException("RSA parameters should be for a public key");
        }
        this.publicKey = publicKey;
        this.blindingFactor = blindingFactor;
    }

    public RsaKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getBlindingFactor() {
        return this.blindingFactor;
    }
}

