/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.AESEngine;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAEADOperatorFactory;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputAEADEncryptor;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.AEADCipherMac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.GMac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapWithPaddingEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsAES {
    static final FipsEngineProvider<BlockCipher> ENGINE_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB128;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;

    private FipsAES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm algorithm) {
        FipsEngineProvider<Mac> macProvider;
        switch ((Mode)algorithm.basicVariation()) {
            case CMAC: {
                macProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            case GMAC: {
                macProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new GMac(new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES MAC Provider: " + algorithm);
            }
        }
        return macProvider;
    }

    static Mac makeMAC(AuthParameters parameters) {
        Mac mac;
        switch ((Mode)parameters.getAlgorithm().basicVariation()) {
            case CCM: {
                mac = new AEADCipherMac(new CCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()), parameters.macLenInBits);
                break;
            }
            case CMAC: {
                mac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), parameters.macLenInBits);
                break;
            }
            case GMAC: {
                mac = new GMac(new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()), parameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.OperatorFactory.createMACCalculator: " + parameters.getAlgorithm());
            }
        }
        return mac;
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, FipsAlgorithm fipsAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalKeyException("AES key must be of length 128, 192, or 256");
        }
        Algorithm algorithm = vKey.getAlgorithm();
        if (!algorithm.equals(ALGORITHM) && !algorithm.equals(fipsAlgorithm)) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return vKey;
    }

    private static void ccmStartUpTest(EngineProvider provider) {
        SelfTestExecutor.validate(CCM.getAlgorithm(), provider, new VariantKatTest<EngineProvider>(){

            @Override
            public void evaluate(EngineProvider provider) throws Exception {
                byte[] K = Hex.decode("404142434445464748494a4b4c4d4e4f");
                byte[] N = Hex.decode("10111213141516");
                byte[] A = Hex.decode("0001020304050607");
                byte[] P = Hex.decode("20212223");
                byte[] C = Hex.decode("7162015b4dac255d");
                byte[] T = Hex.decode("6084341b");
                BlockCipher aesCipher = provider.createEngine();
                CCMBlockCipher encCipher = new CCMBlockCipher(aesCipher);
                int macSize = T.length * 8;
                KeyParameterImpl keyParam = new KeyParameterImpl(K);
                encCipher.init(true, new AEADParameters(keyParam, macSize, N, A));
                byte[] enc = new byte[C.length];
                int len = encCipher.processBytes(P, 0, P.length, enc, 0);
                encCipher.doFinal(enc, len);
                if (!Arrays.areEqual(C, enc)) {
                    this.fail("Encrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(T, encCipher.getMac())) {
                    this.fail("MAC fails to match in self test encrypt");
                }
                CCMBlockCipher decCipher = new CCMBlockCipher(aesCipher);
                decCipher.init(false, new AEADParameters(keyParam, macSize, N, A));
                byte[] tmp = new byte[enc.length];
                len = decCipher.processBytes(enc, 0, enc.length, tmp, 0);
                len += decCipher.doFinal(tmp, len);
                byte[] dec = new byte[len];
                System.arraycopy(tmp, 0, dec, 0, len);
                if (!Arrays.areEqual(P, dec)) {
                    this.fail("Decrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(T, decCipher.getMac())) {
                    this.fail("MAC fails to match in self test");
                }
            }
        });
    }

    private static void cmacStartUpTest(final EngineProvider provider) {
        SelfTestExecutor.validate(CMAC.getAlgorithm(), provider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider engine) {
                byte[] keyBytes128 = Hex.decode("2b7e151628aed2a6abf7158809cf4f3c");
                byte[] input16 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] output_k128_m16 = Hex.decode("070a16b46b4d4144f79bdd9dd04a287c");
                CMac mac = new CMac(provider.createEngine(), 128);
                KeyParameterImpl key = new KeyParameterImpl(keyBytes128);
                mac.init(key);
                mac.update(input16, 0, input16.length);
                byte[] out = new byte[16];
                mac.doFinal(out, 0);
                return Arrays.areEqual(out, output_k128_m16);
            }
        });
    }

    private static void gcmStartUpTest(EngineProvider provider) {
        SelfTestExecutor.validate(GCM.getAlgorithm(), provider, new VariantKatTest<EngineProvider>(){

            @Override
            public void evaluate(EngineProvider provider) throws Exception {
                BlockCipher aesCipher = provider.createEngine();
                GCMBlockCipher encCipher = new GCMBlockCipher(aesCipher);
                byte[] K = Hex.decode("feffe9928665731c6d6a8f9467308308");
                byte[] P = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39");
                byte[] A = Hex.decode("feedfacedeadbeeffeedfacedeadbeefabaddad2");
                byte[] IV = Hex.decode("cafebabefacedbaddecaf888");
                byte[] C = Hex.decode("42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091");
                byte[] T = Hex.decode("5bc94fbc3221a5db94fae95ae7121a47");
                AEADParameters params = new AEADParameters(new KeyParameterImpl(K), T.length * 8, IV, A);
                encCipher.init(true, params);
                byte[] enc = new byte[encCipher.getOutputSize(P.length)];
                int len = encCipher.processBytes(P, 0, P.length, enc, 0);
                len += encCipher.doFinal(enc, len);
                if (enc.length != len) {
                    this.fail("Encryption reported incorrect length");
                }
                byte[] mac = encCipher.getMac();
                byte[] data = new byte[P.length];
                System.arraycopy(enc, 0, data, 0, data.length);
                byte[] tail = new byte[enc.length - P.length];
                System.arraycopy(enc, P.length, tail, 0, tail.length);
                if (!Arrays.areEqual(C, data)) {
                    this.fail("Incorrect encrypt");
                }
                if (!Arrays.areEqual(T, mac)) {
                    this.fail("getMac() returned wrong MAC");
                }
                if (!Arrays.areEqual(T, tail)) {
                    this.fail("Stream contained wrong MAC");
                }
                GCMBlockCipher decCipher = new GCMBlockCipher(aesCipher);
                decCipher.init(false, params);
                byte[] dec = new byte[decCipher.getOutputSize(enc.length)];
                len = decCipher.processBytes(enc, 0, enc.length, dec, 0);
                decCipher.doFinal(dec, len);
                mac = decCipher.getMac();
                data = new byte[C.length];
                System.arraycopy(dec, 0, data, 0, data.length);
                if (!Arrays.areEqual(P, data)) {
                    this.fail("Incorrect decrypt");
                }
                if (!Arrays.areEqual(T, mac)) {
                    this.fail("Incorrect MAC on decrypt");
                }
            }
        });
    }

    static {
        ALGORITHM = new FipsAlgorithm("AES");
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB128 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        OFB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        FipsAES.ccmStartUpTest(provider);
        FipsAES.cmacStartUpTest(provider);
        FipsAES.gcmStartUpTest(provider);
        ENGINE_PROVIDER = provider;
        FipsRegister.registerEngineProvider(ALGORITHM, provider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends FipsAEADOperatorFactory<AuthParameters> {
        @Override
        public FipsOutputAEADEncryptor<AuthParameters> createOutputAEADEncryptor(SymmetricKey key, AuthParameters parameter) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameter.getAlgorithm());
            return new OutEncryptor(sKey, parameter);
        }

        @Override
        public FipsOutputAEADDecryptor<AuthParameters> createOutputAEADDecryptor(SymmetricKey key, final AuthParameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final AEADBlockCipher cipher = BlockCipherUtils.createAEADCipher(parameters.getAlgorithm(), ENGINE_PROVIDER);
            if (parameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            cipher.init(false, Utils.getAEADParameters(sKey, parameters.iv, parameters.macLenInBits));
            return new FipsOutputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int inputLen) {
                    return cipher.getOutputSize(inputLen);
                }

                @Override
                public int getUpdateOutputSize(int inputLen) {
                    return cipher.getUpdateOutputSize(inputLen);
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(cipher);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream out) {
                    return new CipherOutputStreamImpl(out, cipher);
                }

                @Override
                public byte[] getMAC() {
                    return cipher.getMac();
                }
            };
        }

        @Override
        public FipsInputAEADDecryptor<AuthParameters> createInputAEADDecryptor(SymmetricKey key, final AuthParameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final AEADBlockCipher cipher = BlockCipherUtils.createAEADCipher(parameters.getAlgorithm(), ENGINE_PROVIDER);
            if (parameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            cipher.init(false, Utils.getAEADParameters(sKey, parameters.iv, parameters.macLenInBits));
            return new FipsInputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(cipher);
                }

                @Override
                public InputStream getDecryptingStream(InputStream in) {
                    return new CipherInputStream(in, cipher);
                }

                @Override
                public byte[] getMAC() {
                    return cipher.getMac();
                }
            };
        }

        private static class AADStream
        extends UpdateOutputStream {
            private AEADBlockCipher cipher;

            public AADStream(AEADBlockCipher cipher) {
                this.cipher = cipher;
            }

            public void write(byte[] buf, int off, int len) throws IOException {
                this.cipher.processAADBytes(buf, off, len);
            }

            public void write(int b) throws IOException {
                this.cipher.processAADByte((byte)b);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class OutEncryptor
        extends FipsOutputAEADEncryptor<AuthParameters> {
            private final AuthParameters parameters;
            private final AEADBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey key, AuthParameters parameters) {
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createAEADCipher(parameters.getAlgorithm(), ENGINE_PROVIDER);
                if (parameters.iv == null) {
                    throw new IllegalArgumentException("AEAD encryption requires an iv/nonce to be provided.");
                }
                this.cipher.init(true, Utils.getAEADParameters(key, parameters.iv, parameters.macLenInBits));
            }

            @Override
            public AuthParameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return this.cipher.getOutputSize(inputLen);
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return this.cipher.getUpdateOutputSize(inputLen);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.cipher);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream out) {
                return new CipherOutputStreamImpl(out, this.cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.cipher.getMac();
            }
        }
    }

    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 128));
        }

        private AuthParameters(FipsAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm);
            this.iv = iv;
            this.macLenInBits = macLenInBits;
        }

        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public AuthParameters withIV(byte[] iv) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(iv), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(random, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, random), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom random, int ivLen) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(random, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
                if (ivLen < 12) {
                    throw new FipsUnapprovedOperationError("GCM IV must be at least 96 bits", GCM.getAlgorithm());
                }
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(ivLen, random), this.macLenInBits);
        }

        public AuthParameters withMACSize(int macSizeInBits) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), macSizeInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    extends FipsEngineProvider<BlockCipher> {
        private static final byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
        private static final byte[] output = Hex.decode("69c4e0d86a7b0430d8cdb78070b4c55a");
        private static final byte[] keyBytes = Hex.decode("000102030405060708090a0b0c0d0e0f");

        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new AESEngine(), new VariantKatTest<AESEngine>(){

                @Override
                public void evaluate(AESEngine aesEngine) {
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(keyBytes);
                    aesEngine.init(true, key);
                    aesEngine.processBlock(input, 0, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    aesEngine.init(false, key);
                    aesEngine.processBlock(tmp, 0, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator<SymmetricSecretKey> {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(FipsParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this(parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(FipsAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(random, keySizeInBits, algorithm);
            }
            if (keySizeInBits != 128 && keySizeInBits != 192 && keySizeInBits != 256) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.algorithm = algorithm;
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricSecretKey generateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm algorithm, boolean useInverse) {
            SP80038FWrapper cipher;
            switch ((Mode)algorithm.basicVariation()) {
                case WRAP: {
                    cipher = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), useInverse);
                    break;
                }
                case WRAPPAD: {
                    cipher = new SP80038FWrapWithPaddingEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), useInverse);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.KeyWrapOperatorFactory: " + algorithm.getName());
                }
            }
            return cipher;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(true, Utils.getKeyParameter(sKey));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] wrap(byte[] in, int inOff, int inLen) throws PlainInputProcessingException {
                    try {
                        return wrapper.wrap(in, inOff, inLen);
                    }
                    catch (Exception e) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + e.getMessage(), e);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(false, Utils.getKeyParameter(sKey));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(in, inOff, inLen);
                    }
                    catch (InvalidCipherTextException e) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return FipsAES.makeMAC(parameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            Mac mac = FipsAES.makeMAC(parameters);
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            if (parameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(sKey, parameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(sKey));
            }
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        private final SecureRandom random;

        public OperatorFactory() {
            this(null);
        }

        private OperatorFactory(SecureRandom random) {
            this.random = random;
        }

        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey key, Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            return new OutEncryptor(sKey, parameters, null);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, this.random);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int inputLen) {
                    return cipher.getOutputSize(inputLen);
                }

                @Override
                public int getUpdateOutputSize(int inputLen) {
                    return cipher.getUpdateOutputSize(inputLen);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream out) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherOutputStreamImpl(out, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return new CipherOutputStreamImpl(out, cipher);
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsAES.validateKey(key, parameters.getAlgorithm());
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, this.random);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream in) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(in, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(in, cipher);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey key, Parameters parameters, SecureRandom random) {
                this.key = key;
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createStandardCipher(true, key, ENGINE_PROVIDER, parameters, random);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream out) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return new CipherOutputStreamImpl(out, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return new CipherOutputStreamImpl(out, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom random) {
                return new OutEncryptor(this.key, this.parameters, random);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return this.cipher.getOutputSize(inputLen);
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return this.cipher.getUpdateOutputSize(inputLen);
            }
        }
    }

    public static final class Parameters
    extends FipsParameters
    implements ParametersWithIV {
        private final byte[] iv;

        Parameters(FipsAlgorithm algorithm) {
            this(algorithm, null);
        }

        private Parameters(FipsAlgorithm algorithm, byte[] iv) {
            super(algorithm);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 16);
            this.iv = iv;
        }

        public Parameters withIV(byte[] iv) {
            return new Parameters(this.getAlgorithm(), Arrays.clone(iv));
        }

        public Parameters withIV(SecureRandom random) {
            return new Parameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, random));
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm algorithm) {
            this(algorithm, false);
        }

        private WrapParameters(FipsAlgorithm algorithm, boolean useInverse) {
            super(algorithm);
            this.useInverse = useInverse;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean useInverse) {
            return new WrapParameters(this.getAlgorithm(), useInverse);
        }
    }
}

