/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

class DhBasicAgreement
implements BasicAgreement {
    private DhPrivateKeyParameters key;
    private DhParameters dhParams;

    DhBasicAgreement() {
    }

    public void init(CipherParameters param) {
        DhPrivateKeyParameters kParam;
        this.key = kParam = (DhPrivateKeyParameters)param;
        this.dhParams = this.key.getParameters();
    }

    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        DhPublicKeyParameters pub = (DhPublicKeyParameters)pubKey;
        DhParameters pubParams = pub.getParameters();
        if (!pubParams.getG().equals(this.dhParams.getG()) || !pubParams.getP().equals(this.dhParams.getP())) {
            throw new IllegalKeyException("DH public key has wrong domain parameters");
        }
        return pub.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

