/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145Key;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricKeyPair<P extends AsymmetricPublicKey, S extends AsymmetricPrivateKey> {
    private final P publicKey;
    private final S privateKey;

    public AsymmetricKeyPair(P publicKey, S privateKey) {
        AccessController.doPrivileged(new PrivilegedAction((AsymmetricPublicKey)publicKey, (AsymmetricPrivateKey)privateKey){
            final /* synthetic */ AsymmetricPublicKey val$publicKey;
            final /* synthetic */ AsymmetricPrivateKey val$privateKey;
            {
                this.val$publicKey = asymmetricPublicKey;
                this.val$privateKey = asymmetricPrivateKey;
            }

            public Object run() {
                AsymmetricKeyPair.this.checkKeyPairForConsistency(this.val$publicKey, this.val$privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(P publicKey, S privateKey) {
        if (publicKey instanceof AsymmetricECKey && privateKey instanceof AsymmetricECKey) {
            AsymmetricECPrivateKey priv = (AsymmetricECPrivateKey)privateKey;
            AsymmetricECPublicKey pub = (AsymmetricECPublicKey)publicKey;
            if (!priv.getDomainParameters().equals(pub.getDomainParameters())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            if (priv.getDomainParameters().getG().multiply(priv.getS()).normalize().equals(pub.getW())) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof AsymmetricDHKey && privateKey instanceof AsymmetricDHKey) {
            AsymmetricDHPrivateKey priv = (AsymmetricDHPrivateKey)privateKey;
            AsymmetricDHPublicKey pub = (AsymmetricDHPublicKey)publicKey;
            DHDomainParameters dhParameters = priv.getDomainParameters();
            if (!dhParameters.equals(pub.getDomainParameters())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dhParameters.getG().modPow(priv.getX(), dhParameters.getP()).equals(pub.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof AsymmetricDSAKey && privateKey instanceof AsymmetricDSAKey) {
            AsymmetricDSAPrivateKey priv = (AsymmetricDSAPrivateKey)privateKey;
            AsymmetricDSAPublicKey pub = (AsymmetricDSAPublicKey)publicKey;
            DSADomainParameters dsaParameters = priv.getDomainParameters();
            if (!dsaParameters.equals(pub.getDomainParameters())) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dsaParameters.getG().modPow(priv.getX(), dsaParameters.getP()).equals(pub.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof AsymmetricRSAKey && privateKey instanceof AsymmetricRSAKey) {
            AsymmetricRSAPrivateKey priv = (AsymmetricRSAPrivateKey)privateKey;
            AsymmetricRSAPublicKey pub = (AsymmetricRSAPublicKey)publicKey;
            if (!priv.getModulus().equals(pub.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger val = BigInteger.valueOf(2L);
            if (val.modPow(priv.getPrivateExponent(), priv.getModulus()).modPow(pub.getPublicExponent(), priv.getModulus()).equals(val)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof AsymmetricGOST3410Key && privateKey instanceof AsymmetricGOST3410Key) {
            if (!((AsymmetricGOST3410Key)publicKey).getParameters().equals(((AsymmetricGOST3410Key)privateKey).getParameters())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof AsymmetricGOST3410PublicKey && privateKey instanceof AsymmetricGOST3410PrivateKey) {
                AsymmetricGOST3410PrivateKey priv = (AsymmetricGOST3410PrivateKey)privateKey;
                AsymmetricGOST3410PublicKey pub = (AsymmetricGOST3410PublicKey)publicKey;
                GOST3410Parameters<GOST3410DomainParameters> gostParameters = priv.getParameters();
                GOST3410DomainParameters gParams = gostParameters.getDomainParameters();
                if (gParams.getA().modPow(priv.getX(), gParams.getP()).equals(pub.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof AsymmetricECGOST3410PublicKey) || !(privateKey instanceof AsymmetricECGOST3410PrivateKey)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            AsymmetricECGOST3410PrivateKey priv = (AsymmetricECGOST3410PrivateKey)privateKey;
            AsymmetricECGOST3410PublicKey pub = (AsymmetricECGOST3410PublicKey)publicKey;
            GOST3410Parameters<ECDomainParameters> gostParameters = priv.getParameters();
            ECDomainParameters gParams = gostParameters.getDomainParameters();
            if (gParams.getG().multiply(priv.getS()).normalize().equals(pub.getW())) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (publicKey instanceof AsymmetricDSTU4145Key && privateKey instanceof AsymmetricDSTU4145Key) {
            AsymmetricDSTU4145PrivateKey priv = (AsymmetricDSTU4145PrivateKey)privateKey;
            AsymmetricDSTU4145PublicKey pub = (AsymmetricDSTU4145PublicKey)publicKey;
            if (!priv.getParameters().equals(pub.getParameters())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            if (priv.getParameters().getDomainParameters().getG().multiply(priv.getS()).negate().normalize().equals(pub.getW())) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (publicKey instanceof AsymmetricEdDSAKey && privateKey instanceof AsymmetricEdDSAKey) {
            AsymmetricEdDSAPrivateKey priv = (AsymmetricEdDSAPrivateKey)privateKey;
            AsymmetricEdDSAPublicKey pub = (AsymmetricEdDSAPublicKey)publicKey;
            if (!priv.getAlgorithm().equals(pub.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (Arrays.areEqual(priv.getPublicData(), pub.getPublicData())) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (!(publicKey instanceof AsymmetricXDHKey) || !(privateKey instanceof AsymmetricXDHKey)) throw new IllegalArgumentException("Key pair inconsistent");
        AsymmetricXDHPrivateKey priv = (AsymmetricXDHPrivateKey)privateKey;
        AsymmetricXDHPublicKey pub = (AsymmetricXDHPublicKey)publicKey;
        if (!priv.getAlgorithm().equals(pub.getAlgorithm())) {
            throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
        }
        if (Arrays.areEqual(priv.getPublicData(), pub.getPublicData())) return;
        throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
    }

    public P getPublicKey() {
        return this.publicKey;
    }

    public S getPrivateKey() {
        return this.privateKey;
    }
}

