/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PrivateKey;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.ECGOST3410PrivateKeySpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECGOST3410PrivateKey
implements Destroyable,
ECGOST3410PrivateKey,
ProvKey<AsymmetricECGOST3410PrivateKey> {
    private static final long serialVersionUID = 7245981689601667138L;
    private transient AsymmetricECGOST3410PrivateKey baseKey;

    ProvECGOST3410PrivateKey(Algorithm algorithm, ECGOST3410PrivateKey key) {
        GOST3410ParameterSpec<ECDomainParameterSpec> params = key.getParams();
        this.baseKey = new AsymmetricECGOST3410PrivateKey(algorithm, GOST3410Util.convertToECParams(params), key.getS());
    }

    ProvECGOST3410PrivateKey(Algorithm algorithm, ECGOST3410PrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricECGOST3410PrivateKey(algorithm, GOST3410Util.convertToECParams(keySpec.getParams()), keySpec.getS());
    }

    ProvECGOST3410PrivateKey(AsymmetricECGOST3410PrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricECGOST3410PrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public GOST3410ParameterSpec<ECDomainParameterSpec> getParams() {
        return GOST3410Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvECGOST3410PrivateKey)) {
            return false;
        }
        ProvECGOST3410PrivateKey other = (ProvECGOST3410PrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("ECGOST3410");
        }
        try {
            return KeyUtil.privateKeyToString("ECGOST3410", this.baseKey.getS(), this.baseKey.getParameters().getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("ECGOST3410");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricECGOST3410PrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

