/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PrivateKey;
import org.bouncycastle.jcajce.provider.DSTU4145Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.DSTU4145PrivateKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSTU4145PrivateKey
implements Destroyable,
DSTU4145PrivateKey,
ProvKey<AsymmetricDSTU4145PrivateKey> {
    private static final long serialVersionUID = 7245981689601667138L;
    private transient AsymmetricDSTU4145PrivateKey baseKey;

    ProvDSTU4145PrivateKey(Algorithm algorithm, DSTU4145PrivateKey key) {
        DSTU4145ParameterSpec params = key.getParams();
        this.baseKey = new AsymmetricDSTU4145PrivateKey(algorithm, DSTU4145Util.convertToECParams(params), key.getS());
    }

    ProvDSTU4145PrivateKey(Algorithm algorithm, DSTU4145PrivateKeySpec keySpec) {
        this.baseKey = new AsymmetricDSTU4145PrivateKey(algorithm, DSTU4145Util.convertToECParams(keySpec.getParams()), keySpec.getS());
    }

    ProvDSTU4145PrivateKey(AsymmetricDSTU4145PrivateKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricDSTU4145PrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public DSTU4145ParameterSpec getParams() {
        return DSTU4145Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvDSTU4145PrivateKey)) {
            return false;
        }
        ProvDSTU4145PrivateKey other = (ProvDSTU4145PrivateKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("DSTU4145");
        }
        try {
            return KeyUtil.privateKeyToString("DSTU4145", this.baseKey.getS(), this.baseKey.getParameters().getDomainParameters());
        }
        catch (Exception e) {
            return KeyUtil.restrictedToString("DSTU4145");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDSTU4145PrivateKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

