/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PKIXNameConstraintValidator;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.provider.AnnotatedException;
import org.bouncycastle.jcajce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jcajce.provider.PKIXPolicyNode;
import org.bouncycastle.jcajce.provider.RFC3280CertPathUtilities;

class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private final Provider fipsProvider;

    PKIXCertPathValidatorSpi(Provider fipsProvider) {
        this.fipsProvider = fipsProvider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        PublicKey workingPublicKey;
        X500Principal workingIssuerName;
        TrustAnchor trust;
        PKIXExtendedParameters paramsPKIX;
        if (params instanceof PKIXExtendedParameters) {
            paramsPKIX = (PKIXExtendedParameters)params;
        } else if (params instanceof PKIXExtendedBuilderParameters) {
            paramsPKIX = ((PKIXExtendedBuilderParameters)params).getBaseParameters();
        } else if (params instanceof PKIXParameters) {
            paramsPKIX = new PKIXExtendedParameters.Builder((PKIXParameters)params).build();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + PKIXExtendedParameters.class.getName() + " instance.");
        }
        if (paramsPKIX.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> certs = certPath.getCertificates();
        int n = certs.size();
        if (certs.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set userInitialPolicySet = paramsPKIX.getInitialPolicies();
        try {
            trust = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)certs.get(certs.size() - 1), paramsPKIX.getTrustAnchors(), paramsPKIX.getSigProvider());
        }
        catch (AnnotatedException e) {
            throw new CertPathValidatorException(e.getMessage(), (Throwable)e, certPath, certs.size() - 1);
        }
        if (trust == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        paramsPKIX = new PKIXExtendedParameters.Builder(paramsPKIX).setTrustAnchor(trust).build();
        int index = 0;
        List[] policyNodes = new ArrayList[n + 1];
        for (int j = 0; j < policyNodes.length; ++j) {
            policyNodes[j] = new ArrayList();
        }
        HashSet<String> policySet = new HashSet<String>();
        policySet.add("2.5.29.32.0");
        PKIXPolicyNode validPolicyTree = new PKIXPolicyNode(new ArrayList(), 0, policySet, null, new HashSet(), "2.5.29.32.0", false);
        policyNodes[0].add(validPolicyTree);
        PKIXNameConstraintValidator nameConstraintValidator = new PKIXNameConstraintValidator();
        HashSet acceptablePolicies = new HashSet();
        int explicitPolicy = paramsPKIX.isExplicitPolicyRequired() ? 0 : n + 1;
        int inhibitAnyPolicy = paramsPKIX.isAnyPolicyInhibited() ? 0 : n + 1;
        int policyMapping = paramsPKIX.isPolicyMappingInhibited() ? 0 : n + 1;
        X509Certificate sign = trust.getTrustedCert();
        try {
            if (sign != null) {
                workingIssuerName = CertPathValidatorUtilities.getSubjectPrincipal(sign);
                workingPublicKey = sign.getPublicKey();
            } else {
                workingIssuerName = new X500Principal(trust.getCAName());
                workingPublicKey = trust.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException ex) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)ex, certPath, -1);
        }
        AlgorithmIdentifier workingAlgId = null;
        try {
            workingAlgId = CertPathValidatorUtilities.getAlgorithmIdentifier(workingPublicKey);
        }
        catch (CertPathValidatorException e) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)e, certPath, -1);
        }
        ASN1ObjectIdentifier workingPublicKeyAlgorithm = workingAlgId.getAlgorithm();
        ASN1Encodable workingPublicKeyParameters = workingAlgId.getParameters();
        int maxPathLength = n;
        if (paramsPKIX.getTargetConstraints() != null && !paramsPKIX.getTargetConstraints().match((X509Certificate)certs.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List pathCheckers = paramsPKIX.getCertPathCheckers();
        Iterator certIter = pathCheckers.iterator();
        while (certIter.hasNext()) {
            ((PKIXCertPathChecker)certIter.next()).init(false);
        }
        X509Certificate cert = null;
        for (index = certs.size() - 1; index >= 0; --index) {
            boolean verificationAlreadyPerformed;
            int i = n - index;
            cert = (X509Certificate)certs.get(index);
            boolean bl = verificationAlreadyPerformed = index == certs.size() - 1;
            if (cert == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, index);
            }
            RFC3280CertPathUtilities.processCertA(certPath, paramsPKIX, index, workingPublicKey, verificationAlreadyPerformed, workingIssuerName, sign, this.fipsProvider);
            RFC3280CertPathUtilities.processCertBC(certPath, index, nameConstraintValidator);
            validPolicyTree = RFC3280CertPathUtilities.processCertD(certPath, index, acceptablePolicies, validPolicyTree, policyNodes, inhibitAnyPolicy);
            validPolicyTree = RFC3280CertPathUtilities.processCertE(certPath, index, validPolicyTree);
            RFC3280CertPathUtilities.processCertF(certPath, index, validPolicyTree, explicitPolicy);
            if (i == n) continue;
            if (cert.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, index);
            }
            RFC3280CertPathUtilities.prepareNextCertA(certPath, index);
            validPolicyTree = RFC3280CertPathUtilities.prepareCertB(certPath, index, policyNodes, validPolicyTree, policyMapping);
            RFC3280CertPathUtilities.prepareNextCertG(certPath, index, nameConstraintValidator);
            explicitPolicy = RFC3280CertPathUtilities.prepareNextCertH1(certPath, index, explicitPolicy);
            policyMapping = RFC3280CertPathUtilities.prepareNextCertH2(certPath, index, policyMapping);
            inhibitAnyPolicy = RFC3280CertPathUtilities.prepareNextCertH3(certPath, index, inhibitAnyPolicy);
            explicitPolicy = RFC3280CertPathUtilities.prepareNextCertI1(certPath, index, explicitPolicy);
            policyMapping = RFC3280CertPathUtilities.prepareNextCertI2(certPath, index, policyMapping);
            inhibitAnyPolicy = RFC3280CertPathUtilities.prepareNextCertJ(certPath, index, inhibitAnyPolicy);
            RFC3280CertPathUtilities.prepareNextCertK(certPath, index);
            maxPathLength = RFC3280CertPathUtilities.prepareNextCertL(certPath, index, maxPathLength);
            maxPathLength = RFC3280CertPathUtilities.prepareNextCertM(certPath, index, maxPathLength);
            RFC3280CertPathUtilities.prepareNextCertN(certPath, index);
            Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
            if (criticalExtensions != null) {
                criticalExtensions = new HashSet<String>(criticalExtensions);
                criticalExtensions.removeAll(RFC3280CertPathUtilities.CERT_SUPPORTED_CRITICAL_EXTENSIONS);
            } else {
                criticalExtensions = new HashSet<String>();
            }
            RFC3280CertPathUtilities.prepareNextCertO(certPath, index, criticalExtensions, pathCheckers);
            sign = cert;
            workingIssuerName = CertPathValidatorUtilities.getSubjectPrincipal(sign);
            try {
                workingPublicKey = CertPathValidatorUtilities.getNextWorkingKey(certPath.getCertificates(), index, this.fipsProvider);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)e, certPath, index);
            }
            workingAlgId = CertPathValidatorUtilities.getAlgorithmIdentifier(workingPublicKey);
            workingPublicKeyAlgorithm = workingAlgId.getAlgorithm();
            workingPublicKeyParameters = workingAlgId.getParameters();
        }
        explicitPolicy = RFC3280CertPathUtilities.wrapupCertA(explicitPolicy, cert);
        explicitPolicy = RFC3280CertPathUtilities.wrapupCertB(certPath, index + 1, explicitPolicy);
        Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
        if (criticalExtensions != null) {
            criticalExtensions = new HashSet<String>(criticalExtensions);
            criticalExtensions.removeAll(RFC3280CertPathUtilities.CERT_SUPPORTED_CRITICAL_EXTENSIONS);
            criticalExtensions.remove(Extension.extendedKeyUsage.getId());
        } else {
            criticalExtensions = new HashSet<String>();
        }
        RFC3280CertPathUtilities.wrapupCertF(certPath, index + 1, pathCheckers, criticalExtensions);
        PKIXPolicyNode intersection = RFC3280CertPathUtilities.wrapupCertG(certPath, paramsPKIX, userInitialPolicySet, index + 1, policyNodes, validPolicyTree, acceptablePolicies);
        if (explicitPolicy > 0 || intersection != null) {
            return new PKIXCertPathValidatorResult(trust, intersection, cert.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, index);
    }
}

