/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.DSAOutputSigner;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.EcDHAgreement;
import org.bouncycastle.crypto.fips.EcDHUAgreement;
import org.bouncycastle.crypto.fips.EcDhBasicAgreement;
import org.bouncycastle.crypto.fips.EcDhcBasicAgreement;
import org.bouncycastle.crypto.fips.EcDhcuBasicAgreement;
import org.bouncycastle.crypto.fips.EcDsaSigner;
import org.bouncycastle.crypto.fips.EcKeyGenerationParameters;
import org.bouncycastle.crypto.fips.EcKeyPairGenerator;
import org.bouncycastle.crypto.fips.EcMqvBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementFactory;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.NullDigest;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.params.EcDhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcDhuPublicParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.TestRandomBigInteger;
import org.bouncycastle.util.test.TestRandomData;

public final class FipsEC {
    private static final int MIN_FIPS_FIELD_SIZE = 224;
    private static final BigInteger TEST_D_OFFSET = new BigInteger("deadbeef", 16);
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("EC");
    private static final FipsAlgorithm ALGORITHM_MQV = new FipsAlgorithm("ECMQV", (Enum)Variations.ECMQV);
    private static final FipsAlgorithm ALGORITHM_DHU = new FipsAlgorithm("ECCDHU", (Enum)Variations.ECCDHU);
    public static final DSAParameters DSA = new DSAParameters(new FipsAlgorithm("ECDSA", (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final AgreementParameters DH = new AgreementParameters(new FipsAlgorithm("ECDH", (Enum)Variations.ECDH));
    public static final AgreementParameters CDH = new AgreementParameters(new FipsAlgorithm("ECCDH", (Enum)Variations.ECCDH));
    public static final MQVAgreementParametersBuilder MQV = new MQVAgreementParametersBuilder();
    public static final DHUAgreementParametersBuilder CDHU = new DHUAgreementParametersBuilder();
    private static final FipsEngineProvider<EcDsaSigner> DSA_PROVIDER = new DsaProvider();
    private static final FipsEngineProvider<EcDhBasicAgreement> DH_PROVIDER = new DhProvider();
    private static final FipsEngineProvider<EcDhcBasicAgreement> CDH_PROVIDER = new DhcProvider();
    private static final FipsEngineProvider<EcMqvBasicAgreement> MQV_PROVIDER = new MqvProvider();
    private static final FipsEngineProvider<EcDhcuBasicAgreement> DHU_PROVIDER = new DhuProvider();

    private FipsEC() {
    }

    private static void checkEnabled() {
        if (Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            throw new UnsupportedOperationException("EC has been disabled by setting \"org.bouncycastle.ec.disable\"");
        }
    }

    private static void validateKeyPair(FipsAlgorithm algorithm, AsymmetricCipherKeyPair kp) {
        Variations variation = algorithm == ALGORITHM ? Variations.ECDSA : (Variations)algorithm.basicVariation();
        switch (variation) {
            case ECDSA: {
                SelfTestExecutor.validate(algorithm, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        EcDsaSigner signer = new EcDsaSigner();
                        signer.init(true, new ParametersWithRandom(kp.getPrivate(), Utils.testRandom));
                        byte[] message = new byte[32];
                        message[1] = 1;
                        BigInteger[] rs = signer.generateSignature(message);
                        signer.init(false, kp.getPublic());
                        return signer.verifySignature(message, rs[0], rs[1]);
                    }
                });
                break;
            }
            case ECDH: {
                SelfTestExecutor.validate(algorithm, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        EcDhBasicAgreement agreement = new EcDhBasicAgreement();
                        agreement.init(kp.getPrivate());
                        BigInteger agree1 = agreement.calculateAgreement(kp.getPublic());
                        AsymmetricCipherKeyPair testKP = FipsEC.getTestKeyPair(kp);
                        agreement.init(testKP.getPrivate());
                        BigInteger agree2 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(kp.getPrivate());
                        BigInteger agree3 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(testKP.getPrivate());
                        BigInteger agree4 = agreement.calculateAgreement(kp.getPublic());
                        return !agree1.equals(agree2) && !agree1.equals(agree3) && agree3.equals(agree4);
                    }
                });
                break;
            }
            case ECCDH: {
                SelfTestExecutor.validate(algorithm, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        EcDhcBasicAgreement agreement = new EcDhcBasicAgreement();
                        agreement.init(kp.getPrivate());
                        BigInteger agree1 = agreement.calculateAgreement(kp.getPublic());
                        AsymmetricCipherKeyPair testKP = FipsEC.getTestKeyPair(kp);
                        agreement.init(testKP.getPrivate());
                        BigInteger agree2 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(kp.getPrivate());
                        BigInteger agree3 = agreement.calculateAgreement(testKP.getPublic());
                        agreement.init(testKP.getPrivate());
                        BigInteger agree4 = agreement.calculateAgreement(kp.getPublic());
                        return !agree1.equals(agree2) && !agree1.equals(agree3) && agree3.equals(agree4);
                    }
                });
                break;
            }
            case ECMQV: {
                SelfTestExecutor.validate(algorithm, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        EcMqvBasicAgreement agreement = new EcMqvBasicAgreement();
                        agreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                        BigInteger agree1 = agreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)kp.getPublic(), (EcPublicKeyParameters)kp.getPublic()));
                        AsymmetricCipherKeyPair testSKP = FipsEC.getTestKeyPair(kp);
                        AsymmetricCipherKeyPair testEKP = FipsEC.getTestKeyPair(kp);
                        agreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                        BigInteger agree2 = agreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)testSKP.getPublic(), (EcPublicKeyParameters)testEKP.getPublic()));
                        agreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)testSKP.getPrivate(), (EcPrivateKeyParameters)testEKP.getPrivate()));
                        BigInteger agree3 = agreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)kp.getPublic(), (EcPublicKeyParameters)kp.getPublic()));
                        return !agree1.equals(agree2) && agree2.equals(agree3);
                    }
                });
                break;
            }
            case ECCDHU: {
                SelfTestExecutor.validate(algorithm, kp, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair kp) throws Exception {
                        EcDhcuBasicAgreement agreement = new EcDhcuBasicAgreement();
                        agreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                        byte[] agree1 = agreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)kp.getPublic(), (EcPublicKeyParameters)kp.getPublic()));
                        AsymmetricCipherKeyPair testSKP = FipsEC.getTestKeyPair(kp);
                        AsymmetricCipherKeyPair testEKP = FipsEC.getTestKeyPair(kp);
                        agreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                        byte[] agree2 = agreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)testSKP.getPublic(), (EcPublicKeyParameters)testEKP.getPublic()));
                        agreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)testSKP.getPrivate(), (EcPrivateKeyParameters)testEKP.getPrivate()));
                        byte[] agree3 = agreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)kp.getPublic(), (EcPublicKeyParameters)kp.getPublic()));
                        return !Arrays.areEqual(agree1, agree2) && Arrays.areEqual(agree2, agree3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled EC algorithm: " + algorithm.getName());
            }
        }
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        X9ECParameters p = NISTNamedCurves.getByName("P-256");
        EcDomainParameters params = new EcDomainParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH(), p.getSeed()));
        EcPrivateKeyParameters priKey = new EcPrivateKeyParameters(new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008"), params);
        EcPublicKeyParameters pubKey = new EcPublicKeyParameters(params.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D")), params);
        return new AsymmetricCipherKeyPair(pubKey, priKey);
    }

    private static void ecPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            void evaluate() throws Exception {
                X9ECParameters p = NISTNamedCurves.getByName("P-256");
                ECDomainParameters params = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH(), p.getSeed());
                BigInteger dValue = new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008");
                ECPoint Q = params.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D"));
                if (!Q.equals(params.getG().multiply(dValue))) {
                    this.fail("EC primitive 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair kp) {
        EcPrivateKeyParameters privKey = (EcPrivateKeyParameters)kp.getPrivate();
        EcDomainParameters ecDomainParameters = privKey.getParameters();
        BigInteger testD = privKey.getD().add(TEST_D_OFFSET).mod(ecDomainParameters.getN());
        if (testD.compareTo(ECConstants.TWO) < 0) {
            testD = testD.add(TEST_D_OFFSET);
        }
        EcPrivateKeyParameters testPriv = new EcPrivateKeyParameters(testD, ecDomainParameters);
        EcPublicKeyParameters testPub = new EcPublicKeyParameters(ecDomainParameters.getG().multiply(testD), ecDomainParameters);
        return new AsymmetricCipherKeyPair(testPub, testPriv);
    }

    private static void validateCurveSize(Algorithm algorithm, ECDomainParameters domainParameters) {
        if (domainParameters.getCurve().getFieldSize() < 224) {
            throw new FipsUnapprovedOperationError("Attempt to use curve with field size less than 224 bits", algorithm);
        }
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams);
        }
        return new EcDomainParameters(curveParams);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(privKey.getS(), FipsEC.getDomainParams(privKey.getDomainParameters()));
            }
        });
    }

    private static EcDomainParameters getDomainParamsWithInv(ECDomainParameters curveParams) {
        if (curveParams instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)curveParams, curveParams.getInverseH());
        }
        return new EcDomainParameters(curveParams, curveParams.getInverseH());
    }

    private static EcPrivateKeyParameters getLwKeyWithInv(final AsymmetricECPrivateKey privKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(privKey.getS(), FipsEC.getDomainParamsWithInv(privKey.getDomainParameters()));
            }
        });
    }

    private static AsymmetricCipherKeyPair getF2mKATKeyPair() {
        X9ECParameters p = NISTNamedCurves.getByName("B-233");
        EcDomainParameters params = new EcDomainParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH(), p.getSeed()));
        EcPrivateKeyParameters priKey = new EcPrivateKeyParameters(new BigInteger("20186677036482506115567393538695075300175221296989956723148347484984008"), params);
        EcPublicKeyParameters pubKey = new EcPublicKeyParameters(params.getCurve().decodePoint(Hex.decode("03000518bce3b1b492c23094dcd7674c8ea6a3bcb7861bd2fb11be1999b796")), params);
        return new AsymmetricCipherKeyPair(pubKey, priKey);
    }

    private static void f2mDsaTest(EcDsaSigner signer) {
        SelfTestExecutor.validate(ALGORITHM, signer, new VariantKatTest<EcDsaSigner>(){

            @Override
            void evaluate(EcDsaSigner dsa) throws Exception {
                BigInteger f2mR = new BigInteger(1, Hex.decode("d001312179360f7a557d4686e2faf9740fd3289edbafb5e551402cf1b0"));
                BigInteger f2mS = new BigInteger(1, Hex.decode("9d4c2f24b50ce6b9ac725c7833c495fe703296c038dab05ea7af06cafe"));
                AsymmetricCipherKeyPair kp = FipsEC.getF2mKATKeyPair();
                TestRandomData k = new TestRandomData("a0640d4957f27d091ab1aebc69949d96e5ac2bb283ed5284a5674758b12f08df");
                byte[] M = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                dsa.init(true, new ParametersWithRandom(kp.getPrivate(), k));
                BigInteger[] sig = dsa.generateSignature(M);
                if (!sig[0].equals(f2mR) || !sig[1].equals(f2mS)) {
                    this.fail("F2m signature incorrect");
                }
                dsa.init(false, kp.getPublic());
                if (!dsa.verifySignature(M, sig[0], sig[1])) {
                    this.fail("F2m signature fails");
                }
            }
        });
    }

    static {
        EcDsaSigner signer = (EcDsaSigner)DSA_PROVIDER.createEngine();
        FipsEC.f2mDsaTest(signer);
        FipsEC.ecPrimitiveZTest();
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters(FipsAlgorithm agreementAlgorithm) {
            this(agreementAlgorithm, null);
        }

        private AgreementParameters(FipsAlgorithm agreementAlgorithm, FipsAlgorithm digestAlgorithm) {
            super(agreementAlgorithm, digestAlgorithm);
        }

        private AgreementParameters(FipsAlgorithm agreementAlgorithm, FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(agreementAlgorithm, prfAlgorithm, salt);
        }

        private AgreementParameters(FipsAlgorithm agreementAlgorithm, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(agreementAlgorithm, kdfType, iv, outputSize);
        }

        public AgreementParameters withDigest(FipsDigestAlgorithm digestAlgorithm) {
            return new AgreementParameters(this.getAlgorithm(), digestAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new AgreementParameters(this.getAlgorithm(), prfAlgorithm, salt);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new AgreementParameters(this.getAlgorithm(), kdfType, iv, outputSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        public DHAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey key, AgreementParameters parameters) {
            if (parameters.getAlgorithm() == DH.getAlgorithm()) {
                AsymmetricECPrivateKey ecKey = (AsymmetricECPrivateKey)key;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    if (!BigInteger.ONE.equals(ecKey.getDomainParameters().getH())) {
                        throw new FipsUnapprovedOperationError("ECDH can only be executed on curves with a co-factor of 1 in approved mode", key.getAlgorithm());
                    }
                    FipsEC.validateCurveSize(key.getAlgorithm(), ecKey.getDomainParameters());
                }
                EcPrivateKeyParameters lwECKey = !BigInteger.ONE.equals(ecKey.getDomainParameters().getH()) ? FipsEC.getLwKeyWithInv(ecKey) : FipsEC.getLwKey(ecKey);
                EcDhBasicAgreement ecdh = (EcDhBasicAgreement)DH_PROVIDER.createEngine();
                ecdh.init(lwECKey);
                return new EcDHAgreement<AgreementParameters>(ecdh, parameters);
            }
            if (parameters.getAlgorithm() == CDH.getAlgorithm()) {
                AsymmetricECPrivateKey ecKey = (AsymmetricECPrivateKey)key;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    FipsEC.validateCurveSize(key.getAlgorithm(), ecKey.getDomainParameters());
                }
                EcPrivateKeyParameters lwECKey = FipsEC.getLwKey(ecKey);
                EcDhcBasicAgreement ecdh = (EcDhcBasicAgreement)CDH_PROVIDER.createEngine();
                ecdh.init(lwECKey);
                return new EcDHAgreement<AgreementParameters>(ecdh, parameters);
            }
            throw new IllegalArgumentException("Incorrect algorithm in parameters for EC DH: " + parameters.getAlgorithm().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        public DHUAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey key, DHUAgreementParameters parameters) {
            AsymmetricECPrivateKey ecKey = (AsymmetricECPrivateKey)key;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(key.getAlgorithm(), ecKey.getDomainParameters());
            }
            EcPrivateKeyParameters lwECKey = FipsEC.getLwKey(ecKey);
            EcDhcuBasicAgreement ecdh = (EcDhcuBasicAgreement)DHU_PROVIDER.createEngine();
            ecdh.init(new EcDhuPrivateParameters(lwECKey, parameters.ephemeralPrivateKey == null ? lwECKey : FipsEC.getLwKey(parameters.ephemeralPrivateKey)));
            return new EcDHUAgreement<DHUAgreementParameters>(ecdh, parameters);
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsAlgorithm digestAlgorithm) {
            super(ALGORITHM_DHU, digestAlgorithm);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(ALGORITHM_DHU, prfAlgorithm, salt);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(ALGORITHM_DHU, kdfType, iv, outputSize);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm digestAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, digestAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, prfAlgorithm, salt);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, kdfType, iv, outputSize);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair ephemeralKeyPair, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters((AsymmetricECPublicKey)ephemeralKeyPair.getPublicKey(), (AsymmetricECPrivateKey)ephemeralKeyPair.getPrivateKey(), otherPartyEphemeralKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters(null, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new DHUAgreementParameters(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DSAOperatorFactory
    extends FipsSignatureOperatorFactory<DSAParameters> {
        public DSAOperatorFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsOutputSignerUsingSecureRandom<DSAParameters> createSigner(AsymmetricPrivateKey key, DSAParameters parameters) {
            AsymmetricECPrivateKey k = (AsymmetricECPrivateKey)key;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(key.getAlgorithm(), k.getDomainParameters());
            }
            EcDsaSigner ecdsaSigner = (EcDsaSigner)DSA_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            final EcPrivateKeyParameters privateKeyParameters = FipsEC.getLwKey(k);
            return new DSAOutputSigner<DSAParameters>(ecdsaSigner, digest, parameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA signer, SecureRandom random) {
                    signer.init(true, new ParametersWithRandom(privateKeyParameters, random));
                }
            });
        }

        @Override
        public FipsOutputVerifier<DSAParameters> createVerifier(AsymmetricPublicKey key, DSAParameters parameters) {
            EcDsaSigner ecdsaSigner = (EcDsaSigner)DSA_PROVIDER.createEngine();
            Digest digest = parameters.digestAlgorithm != null ? FipsSHS.createDigest(parameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey k = (AsymmetricECPublicKey)key;
            EcPublicKeyParameters publicKeyParameters = new EcPublicKeyParameters(k.getW(), FipsEC.getDomainParams(k.getDomainParameters()));
            ecdsaSigner.init(false, publicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecdsaSigner, digest, parameters);
        }
    }

    public static final class DSAParameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        DSAParameters(FipsAlgorithm algorithm, FipsDigestAlgorithm digestAlgorithm) {
            super(algorithm);
            if (digestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(FipsDigestAlgorithm digestAlgorithm) {
            return new DSAParameters(this.getAlgorithm(), digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhProvider
    extends FipsEngineProvider<EcDhBasicAgreement> {
        static BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhProvider() {
        }

        @Override
        public EcDhBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhBasicAgreement(), new VariantKatTest<EcDhBasicAgreement>(){

                @Override
                void evaluate(EcDhBasicAgreement agreement) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair testOther = FipsEC.getTestKeyPair(kp);
                    agreement.init(kp.getPrivate());
                    if (!expected.equals(agreement.calculateAgreement(testOther.getPublic()))) {
                        this.fail("KAT ECDH agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhcProvider
    extends FipsEngineProvider<EcDhcBasicAgreement> {
        static final BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhcProvider() {
        }

        @Override
        public EcDhcBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcBasicAgreement(), new VariantKatTest<EcDhcBasicAgreement>(){

                @Override
                void evaluate(EcDhcBasicAgreement agreement) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair testOther = FipsEC.getTestKeyPair(kp);
                    agreement.init(kp.getPrivate());
                    if (!expected.equals(agreement.calculateAgreement(testOther.getPublic()))) {
                        this.fail("KAT ECDH agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DhuProvider
    extends FipsEngineProvider<EcDhcuBasicAgreement> {
        static final byte[] expected = Hex.decode("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17");

        private DhuProvider() {
        }

        @Override
        public EcDhcuBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcuBasicAgreement(), new VariantKatTest<EcDhcuBasicAgreement>(){

                @Override
                void evaluate(EcDhcuBasicAgreement agreement) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair testSKP = FipsEC.getTestKeyPair(kp);
                    AsymmetricCipherKeyPair testEKP = FipsEC.getTestKeyPair(kp);
                    agreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                    byte[] calculated = agreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)testSKP.getPublic(), (EcPublicKeyParameters)testEKP.getPublic()));
                    if (!Arrays.areEqual(expected, calculated)) {
                        this.fail("KAT ECCDHU agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DomainParameterID implements ECDomainParametersID
    {
        B571("B-571"),
        B409("B-409"),
        B283("B-283"),
        B233("B-233"),
        B163("B-163"),
        K571("K-571"),
        K409("K-409"),
        K283("K-283"),
        K233("K-233"),
        K163("K-163"),
        P521("P-521"),
        P384("P-384"),
        P256("P-256"),
        P224("P-224"),
        P192("P-192");

        private final String curveName;

        private DomainParameterID(String curveName) {
            this.curveName = curveName;
        }

        @Override
        public String getCurveName() {
            return this.curveName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DsaProvider
    extends FipsEngineProvider<EcDsaSigner> {
        private DsaProvider() {
        }

        @Override
        public EcDsaSigner createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDsaSigner(), new VariantKatTest<EcDsaSigner>(){

                @Override
                void evaluate(EcDsaSigner dsa) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsEC.getKATKeyPair();
                    TestRandomBigInteger k = new TestRandomBigInteger("72546832179840998877302529996971396893172522460793442785601695562409154906335");
                    byte[] M = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                    dsa.init(true, new ParametersWithRandom(kp.getPrivate(), k));
                    BigInteger[] sig = dsa.generateSignature(M);
                    dsa.init(false, kp.getPublic());
                    if (!dsa.verifySignature(M, sig[0], sig[1])) {
                        this.fail("signature fails");
                    }
                }
            });
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters domainParameters) {
            this(ALGORITHM, domainParameters);
        }

        public KeyGenParameters(DSAParameters parameters, ECDomainParameters domainParameters) {
            this(parameters.getAlgorithm(), domainParameters);
        }

        public KeyGenParameters(AgreementParameters parameters, ECDomainParameters domainParameters) {
            this(parameters.getAlgorithm(), domainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder builder, ECDomainParameters domainParameters) {
            this(ALGORITHM_MQV, domainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder builder, ECDomainParameters domainParameters) {
            this(ALGORITHM_DHU, domainParameters);
        }

        KeyGenParameters(FipsAlgorithm algorithm, ECDomainParameters domainParameters) {
            super(algorithm);
            this.domainParameters = domainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECPublicKey, AsymmetricECPrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final ECDomainParameters domainParameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            FipsEC.checkEnabled();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(keyGenParameters.getAlgorithm(), keyGenParameters.getDomainParameters());
                Utils.validateKeyPairGenRandom(random, Utils.getECCurveSecurityStrength(keyGenParameters.getDomainParameters().getCurve()), ALGORITHM);
            }
            this.param = ((KeyGenParameters)this.getParameters()).getAlgorithm().equals(DH.getAlgorithm()) && !ECConstants.ONE.equals(keyGenParameters.domainParameters.getH()) ? new EcKeyGenerationParameters(FipsEC.getDomainParamsWithInv(keyGenParameters.getDomainParameters()), random) : new EcKeyGenerationParameters(FipsEC.getDomainParams(keyGenParameters.getDomainParameters()), random);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
            EcPublicKeyParameters pubKey = (EcPublicKeyParameters)kp.getPublic();
            EcPrivateKeyParameters prvKey = (EcPrivateKeyParameters)kp.getPrivate();
            FipsAlgorithm algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsEC.validateKeyPair(algorithm, kp);
            return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey((Algorithm)algorithm, this.domainParameters, pubKey.getQ()), new AsymmetricECPrivateKey((Algorithm)algorithm, this.domainParameters, prvKey.getD(), pubKey.getQ()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        public MQVAgreementFactory() {
            FipsEC.checkEnabled();
            if (Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv")) {
                throw new UnsupportedOperationException("EC MQV has been disabled by setting \"org.bouncycastle.ec.disable_mqv\"");
            }
        }

        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey key, MQVAgreementParameters parameters) {
            AsymmetricECPrivateKey ecKey = (AsymmetricECPrivateKey)key;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateCurveSize(key.getAlgorithm(), ecKey.getDomainParameters());
            }
            EcPrivateKeyParameters lwECKey = FipsEC.getLwKey(ecKey);
            EcMqvBasicAgreement ecdh = (EcMqvBasicAgreement)MQV_PROVIDER.createEngine();
            ecdh.init(new EcMqvPrivateParameters(lwECKey, parameters.ephemeralPrivateKey == null ? lwECKey : FipsEC.getLwKey(parameters.ephemeralPrivateKey)));
            return new EcDHAgreement<MQVAgreementParameters>(ecdh, parameters);
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsAlgorithm digestAlgorithm) {
            super(ALGORITHM_MQV, digestAlgorithm);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsKDF.PRF prfAlgorithm, byte[] salt) {
            super(ALGORITHM_MQV, prfAlgorithm, salt);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey, FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            super(ALGORITHM_MQV, kdfType, iv, outputSize);
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.otherPartyEphemeralKey = otherPartyEphemeralKey;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm digestAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, digestAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF prfAlgorithm, byte[] salt) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, prfAlgorithm, salt);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder kdfType, byte[] iv, int outputSize) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, kdfType, iv, outputSize);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair ephemeralKeyPair, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters((AsymmetricECPublicKey)ephemeralKeyPair.getPublicKey(), (AsymmetricECPrivateKey)ephemeralKeyPair.getPrivateKey(), otherPartyEphemeralKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters(null, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPublicKey ephemeralPublicKey, AsymmetricECPrivateKey ephemeralPrivateKey, AsymmetricECPublicKey otherPartyEphemeralKey) {
            return new MQVAgreementParameters(ephemeralPublicKey, ephemeralPrivateKey, otherPartyEphemeralKey, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MqvProvider
    extends FipsEngineProvider<EcMqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("8cae3483c0d3dac87d1c1d32be8e7b7a3c1558bd01cb7e7bb37c1c81126b0f98", 16);

        private MqvProvider() {
        }

        @Override
        public EcMqvBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcMqvBasicAgreement(), new VariantKatTest<EcMqvBasicAgreement>(){

                @Override
                void evaluate(EcMqvBasicAgreement agreement) throws Exception {
                    AsymmetricCipherKeyPair kp = FipsEC.getKATKeyPair();
                    AsymmetricCipherKeyPair testSKP = FipsEC.getTestKeyPair(kp);
                    AsymmetricCipherKeyPair testEKP = FipsEC.getTestKeyPair(kp);
                    agreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)kp.getPrivate(), (EcPrivateKeyParameters)kp.getPrivate()));
                    BigInteger calculated = agreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)testSKP.getPublic(), (EcPublicKeyParameters)testEKP.getPublic()));
                    if (!expected.equals(calculated)) {
                        this.fail("KAT ECMQV agreement not verified");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECDSA,
        ECDH,
        ECCDH,
        ECMQV,
        ECCDHU;

    }
}

