/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DesEdeParameters;
import org.bouncycastle.crypto.internal.params.DesParameters;

class DesEdeKeyGenerator
extends CipherKeyGenerator {
    private final FipsAlgorithm algorithm;

    public DesEdeKeyGenerator(FipsAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.strength = (param.getStrength() + 7) / 8;
        if (this.strength == 0 || this.strength == 21) {
            this.strength = 24;
        } else if (this.strength == 14) {
            this.strength = 16;
        } else if (this.strength != 24 && this.strength != 16) {
            throw new IllegalArgumentException("Key must be 192 or 128 bits long: " + this.algorithm.getName());
        }
    }

    public byte[] generateKey() {
        byte[] newKey = new byte[this.strength];
        int count = 0;
        do {
            this.random.nextBytes(newKey);
            DesParameters.setOddParity(newKey);
        } while (DesEdeParameters.isWeakKey(newKey, 0, newKey.length) && !DesEdeParameters.isRealEDEKey(newKey) && count++ < 10);
        if (DesEdeParameters.isWeakKey(newKey, 0, newKey.length) || !DesEdeParameters.isRealEDEKey(newKey)) {
            throw new FipsOperationError("Failed to generate a valid TripleDES key: " + this.algorithm.getName());
        }
        return newKey;
    }
}

