/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBGUtils;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.SP80090DRBG;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

class CTRSP800DRBG
implements SP80090DRBG {
    private static final long TDEA_RESEED_MAX = 0x80000000L;
    private static final long AES_RESEED_MAX = 0x800000000000L;
    private static final int TDEA_MAX_BITS_REQUEST = 4096;
    private static final int AES_MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedValues = new HashMap<String, byte[][]>();
    private EntropySource _entropySource;
    private BlockCipher _engine;
    private int _keySizeInBits;
    private int _seedLength;
    private boolean _isTDEA = false;
    private int _securityStrength;
    private byte[] _Key;
    private byte[] _V;
    private long _reseedCounter = 0L;
    private static final byte[] K_BITS;

    public CTRSP800DRBG(BlockCipher engine, int keySizeInBits, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        this._engine = engine;
        this._keySizeInBits = keySizeInBits;
        this._seedLength = keySizeInBits + engine.getBlockSize() * 8;
        this._isTDEA = this.isTDEA(engine);
        if (!FipsStatus.isBooting() && this._isTDEA && CryptoServicesRegistrar.isInApprovedOnlyMode() && !Properties.isOverrideSet("org.bouncycastle.tripledes.allow_drbg")) {
            throw new FipsUnapprovedOperationError("Triple-DES CTRDRBG disallowed");
        }
        this.init(securityStrength, entropySource, personalizationString, nonce);
    }

    private void init(int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        if (securityStrength > 256) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (this.getMaxSecurityStrength(this._engine, this._keySizeInBits) < securityStrength) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < securityStrength) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._entropySource = entropySource;
        this._securityStrength = securityStrength;
        this.CTR_DRBG_Instantiate_algorithm(personalizationString, nonce);
    }

    private void CTR_DRBG_Instantiate_algorithm(byte[] personalisationString, byte[] nonce) {
        byte[] entropy = this.getEntropy();
        byte[] input = Arrays.concatenate(entropy, nonce, personalisationString);
        Arrays.fill(entropy, (byte)0);
        byte[] seedMaterial = this.Block_Cipher_df(input, this._seedLength);
        Arrays.fill(input, (byte)0);
        int outlen = this._engine.getBlockSize();
        this._Key = new byte[this.getExpandedKeySizeInBytes()];
        this._V = new byte[outlen];
        this.expandKey(this._Key);
        this.CTR_DRBG_Update(seedMaterial);
        Arrays.fill(seedMaterial, (byte)0);
        this._reseedCounter = 1L;
    }

    private void CTR_DRBG_Update(byte[] seedMaterial) {
        byte[] temp = new byte[seedMaterial.length];
        byte[] outputBlock = new byte[this._engine.getBlockSize()];
        int i = 0;
        int outLen = this._engine.getBlockSize();
        this._engine.init(true, new KeyParameterImpl(this._Key));
        while (i * outLen < seedMaterial.length) {
            this.addOneTo(this._V);
            this._engine.processBlock(this._V, 0, outputBlock, 0);
            int bytesToCopy = temp.length - i * outLen > outLen ? outLen : temp.length - i * outLen;
            System.arraycopy(outputBlock, 0, temp, i * outLen, bytesToCopy);
            ++i;
        }
        Arrays.fill(outputBlock, (byte)0);
        this.XOR(temp, seedMaterial, temp, 0);
        System.arraycopy(temp, 0, this._Key, 0, this.getKeySizeInBytes());
        System.arraycopy(temp, this.getKeySizeInBytes(), this._V, 0, this._V.length);
        Arrays.fill(temp, (byte)0);
        this.expandKey(this._Key);
    }

    private void CTR_DRBG_Reseed_algorithm(byte[] additionalInput) {
        byte[] entropy = this.getEntropy();
        byte[] input = Arrays.concatenate(entropy, additionalInput);
        Arrays.fill(entropy, (byte)0);
        byte[] seedMaterial = this.Block_Cipher_df(input, this._seedLength);
        Arrays.fill(input, (byte)0);
        this.CTR_DRBG_Update(seedMaterial);
        Arrays.fill(seedMaterial, (byte)0);
        this._reseedCounter = 1L;
    }

    private void XOR(byte[] out, byte[] a, byte[] b, int bOff) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)(a[i] ^ b[i + bOff]);
        }
    }

    private void addOneTo(byte[] longer) {
        int carry = 1;
        for (int i = 1; i <= longer.length; ++i) {
            int res = (longer[longer.length - i] & 0xFF) + carry;
            carry = res > 255 ? 1 : 0;
            longer[longer.length - i] = (byte)res;
        }
    }

    private byte[] Block_Cipher_df(byte[] inputString, int bitLength) {
        int outLen = this._engine.getBlockSize();
        int L = inputString.length;
        int N = bitLength / 8;
        int sLen = 8 + L + 1;
        int blockLen = (sLen + outLen - 1) / outLen * outLen;
        byte[] S = new byte[blockLen];
        this.copyIntToByteArray(S, L, 0);
        this.copyIntToByteArray(S, N, 4);
        System.arraycopy(inputString, 0, S, 8, L);
        S[8 + L] = -128;
        byte[] temp = new byte[this.getKeySizeInBytes() + outLen];
        byte[] bccOut = new byte[outLen];
        byte[] IV = new byte[outLen];
        int i = 0;
        byte[] K = new byte[this.getExpandedKeySizeInBytes()];
        System.arraycopy(K_BITS, 0, K, 0, this.getKeySizeInBytes());
        this.expandKey(K);
        KeyParameterImpl bccKey = new KeyParameterImpl(K);
        while (i * outLen * 8 < this._keySizeInBits + outLen * 8) {
            this.copyIntToByteArray(IV, i, 0);
            this.BCC(bccOut, bccKey, IV, S);
            int bytesToCopy = temp.length - i * outLen > outLen ? outLen : temp.length - i * outLen;
            System.arraycopy(bccOut, 0, temp, i * outLen, bytesToCopy);
            ++i;
        }
        Arrays.fill(S, (byte)0);
        Arrays.fill(bccOut, (byte)0);
        Arrays.fill(IV, (byte)0);
        byte[] X = new byte[outLen];
        System.arraycopy(temp, 0, K, 0, this.getKeySizeInBytes());
        System.arraycopy(temp, this.getKeySizeInBytes(), X, 0, X.length);
        Arrays.fill(temp, (byte)0);
        this.expandKey(K);
        temp = new byte[bitLength / 2];
        i = 0;
        this._engine.init(true, new KeyParameterImpl(K));
        while (i * outLen < temp.length) {
            this._engine.processBlock(X, 0, X, 0);
            int bytesToCopy = temp.length - i * outLen > outLen ? outLen : temp.length - i * outLen;
            System.arraycopy(X, 0, temp, i * outLen, bytesToCopy);
            ++i;
        }
        Arrays.fill(X, (byte)0);
        Arrays.fill(K, (byte)0);
        return temp;
    }

    private void BCC(byte[] bccOut, KeyParameter k, byte[] iV, byte[] data) {
        int outlen = this._engine.getBlockSize();
        byte[] chainingValue = new byte[outlen];
        int n = data.length / outlen;
        byte[] inputBlock = new byte[outlen];
        this._engine.init(true, k);
        this._engine.processBlock(iV, 0, chainingValue, 0);
        for (int i = 0; i < n; ++i) {
            this.XOR(inputBlock, chainingValue, data, i * outlen);
            this._engine.processBlock(inputBlock, 0, chainingValue, 0);
        }
        System.arraycopy(chainingValue, 0, bccOut, 0, bccOut.length);
    }

    private void copyIntToByteArray(byte[] buf, int value, int offSet) {
        buf[offSet + 0] = (byte)(value >> 24);
        buf[offSet + 1] = (byte)(value >> 16);
        buf[offSet + 2] = (byte)(value >> 8);
        buf[offSet + 3] = (byte)value;
    }

    public int getBlockSize() {
        return this._V.length * 8;
    }

    public int getSecurityStrength() {
        return this._securityStrength;
    }

    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        byte[] seedMaterial;
        if (predictionResistant) {
            this.CTR_DRBG_Reseed_algorithm(additionalInput);
            additionalInput = null;
        }
        if (this._isTDEA) {
            if (this._reseedCounter > 0x80000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(output, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this._reseedCounter > 0x800000000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(output, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (additionalInput != null) {
            seedMaterial = this.Block_Cipher_df(additionalInput, this._seedLength);
            this.CTR_DRBG_Update(seedMaterial);
        } else {
            seedMaterial = new byte[this._seedLength];
        }
        byte[] out = new byte[this._V.length];
        this._engine.init(true, new KeyParameterImpl(this._Key));
        for (int i = 0; i <= output.length / out.length; ++i) {
            int bytesToCopy;
            int n = bytesToCopy = output.length - i * out.length > out.length ? out.length : output.length - i * this._V.length;
            if (bytesToCopy == 0) continue;
            this.addOneTo(this._V);
            this._engine.processBlock(this._V, 0, out, 0);
            System.arraycopy(out, 0, output, i * out.length, bytesToCopy);
        }
        this.CTR_DRBG_Update(seedMaterial);
        Arrays.fill(seedMaterial, (byte)0);
        ++this._reseedCounter;
        return output.length * 8;
    }

    public void reseed(byte[] additionalInput) {
        this.CTR_DRBG_Reseed_algorithm(additionalInput);
    }

    private byte[] getEntropy() {
        byte[] entropy = this._entropySource.getEntropy();
        if (entropy == null || entropy.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return entropy;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Arrays.fill(this._Key, (byte)0);
        Arrays.fill(this._V, (byte)0);
    }

    public VariantInternalKatTest createSelfTest(FipsAlgorithm algorithm) {
        return new VariantInternalKatTest(algorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] origKey = CTRSP800DRBG.this._Key;
                byte[] origV = CTRSP800DRBG.this._V;
                long origReseedCounter = CTRSP800DRBG.this._reseedCounter;
                EntropySource origEntropySource = CTRSP800DRBG.this._entropySource;
                try {
                    int entropyStrength;
                    byte[] nonce;
                    byte[] personalization;
                    block16: {
                        block15: {
                            block14: {
                                personalization = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                nonce = Hex.decode("2021222324");
                                entropyStrength = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                                byte[][] expected = (byte[][])kats.get(this.algorithm.getName());
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.KATEntropyProvider().get(entropyStrength), personalization, nonce);
                                byte[] output = new byte[expected[0].length];
                                CTRSP800DRBG.this.generate(output, null, true);
                                if (!Arrays.areEqual(expected[0], output)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                output = new byte[expected[1].length];
                                CTRSP800DRBG.this.generate(output, null, true);
                                if (!Arrays.areEqual(expected[1], output)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(entropyStrength), personalization, nonce);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException e) {
                                    if (e.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(20), personalization, nonce);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException e) {
                                if (e.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(entropyStrength);
                            CTRSP800DRBG.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException e) {
                            if (e.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        CTRSP800DRBG.this.init(entropyStrength + 1, new DRBGUtils.KATEntropyProvider().get(entropyStrength), personalization, nonce);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException e) {
                        if (!e.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, origKey);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, origV);
                    CTRSP800DRBG.this._reseedCounter = origReseedCounter;
                    CTRSP800DRBG.this._entropySource = origEntropySource;
                }
            }
        };
    }

    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm algorithm) {
        return new VariantInternalKatTest(algorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] origKey = CTRSP800DRBG.this._Key;
                byte[] origV = CTRSP800DRBG.this._V;
                long origReseedCounter = CTRSP800DRBG.this._reseedCounter;
                EntropySource origEntropySource = CTRSP800DRBG.this._entropySource;
                try {
                    byte[] additionalInput = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int entropyStrength = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                    byte[][] expected = (byte[][])reseedKats.get(this.algorithm.getName());
                    byte[][] internalValues = (byte[][])reseedValues.get(this.algorithm.getName());
                    byte[] iv0 = internalValues[0];
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, new byte[CTRSP800DRBG.this.getExpandedKeySizeInBytes()]);
                    System.arraycopy(iv0, 0, CTRSP800DRBG.this._Key, 0, iv0.length);
                    CTRSP800DRBG.this.expandKey(CTRSP800DRBG.this._Key);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, Arrays.clone(internalValues[1]));
                    CTRSP800DRBG.this._entropySource = new DRBGUtils.KATEntropyProvider().get(entropyStrength);
                    CTRSP800DRBG.this.reseed(additionalInput);
                    if (CTRSP800DRBG.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byte[] output = new byte[expected[0].length];
                    CTRSP800DRBG.this.generate(output, null, false);
                    if (!Arrays.areEqual(expected[0], output)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    output = new byte[expected[1].length];
                    CTRSP800DRBG.this.generate(output, null, false);
                    if (!Arrays.areEqual(expected[1], output)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(entropyStrength);
                        CTRSP800DRBG.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected");
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, origKey);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, origV);
                    CTRSP800DRBG.this._reseedCounter = origReseedCounter;
                    CTRSP800DRBG.this._entropySource = origEntropySource;
                }
            }
        };
    }

    private boolean isTDEA(BlockCipher cipher) {
        return cipher.getAlgorithmName().equals("DESede") || cipher.getAlgorithmName().equals("TDEA");
    }

    private int getMaxSecurityStrength(BlockCipher cipher, int keySizeInBits) {
        if (this.isTDEA(cipher) && keySizeInBits == 168) {
            return 112;
        }
        if (cipher.getAlgorithmName().equals("AES")) {
            return keySizeInBits;
        }
        return -1;
    }

    private void expandKey(byte[] key) {
        if (this._isTDEA) {
            byte[] tmp = new byte[24];
            this.padKey(key, 0, tmp, 0);
            this.padKey(key, 7, tmp, 8);
            this.padKey(key, 14, tmp, 16);
            System.arraycopy(tmp, 0, key, 0, 24);
            Arrays.fill(tmp, (byte)0);
        }
    }

    private int getExpandedKeySizeInBytes() {
        return this._isTDEA ? 24 : this.getKeySizeInBytes();
    }

    private int getKeySizeInBytes() {
        return (this._keySizeInBits + 7) / 8;
    }

    private void padKey(byte[] keyMaster, int keyOff, byte[] tmp, int tmpOff) {
        tmp[tmpOff + 0] = (byte)(keyMaster[keyOff + 0] & 0xFE);
        tmp[tmpOff + 1] = (byte)(keyMaster[keyOff + 0] << 7 | (keyMaster[keyOff + 1] & 0xFC) >>> 1);
        tmp[tmpOff + 2] = (byte)(keyMaster[keyOff + 1] << 6 | (keyMaster[keyOff + 2] & 0xF8) >>> 2);
        tmp[tmpOff + 3] = (byte)(keyMaster[keyOff + 2] << 5 | (keyMaster[keyOff + 3] & 0xF0) >>> 3);
        tmp[tmpOff + 4] = (byte)(keyMaster[keyOff + 3] << 4 | (keyMaster[keyOff + 4] & 0xE0) >>> 4);
        tmp[tmpOff + 5] = (byte)(keyMaster[keyOff + 4] << 3 | (keyMaster[keyOff + 5] & 0xC0) >>> 5);
        tmp[tmpOff + 6] = (byte)(keyMaster[keyOff + 5] << 2 | (keyMaster[keyOff + 6] & 0x80) >>> 6);
        tmp[tmpOff + 7] = (byte)(keyMaster[keyOff + 6] << 1);
        for (int i = tmpOff; i <= tmpOff + 7; ++i) {
            byte b = tmp[i];
            tmp[i] = (byte)(b & 0xFE | (b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7 ^ 1) & 1);
        }
    }

    static /* synthetic */ byte[] access$002(CTRSP800DRBG x0, byte[] x1) {
        x0._Key = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(CTRSP800DRBG x0, byte[] x1) {
        x0._V = x1;
        return x1;
    }

    static {
        kats.put("TRIPLEDES", new byte[][]{Hex.decode("09b2711937c5fc9fdf6f7e070625b41f74916ddb93b9f7a7c90091f86cdf2003a052e8d17bc37d86"), Hex.decode("b5c3c811e17247830be34f9461bf991401edbe99bc0dd6668b5d3f2501d2659bf99da71e38979e75")});
        kats.put("AES-128", new byte[][]{Hex.decode("314069e227a6e4c59c402ac0f9189f921ef19673d16b3fd401ded2f3b8b1d19a1c3b11f948ba8e2a"), Hex.decode("36ccfd81909865e88091079bbd408e9943dd3bedf8e7521e43cd639fed11f482bb17a794ed0265f1")});
        kats.put("AES-192", new byte[][]{Hex.decode("7ee353634fb8bd87bd4a2b292db7a049615bb8ae6a887efb8e81af7124453dac21949cfb51dd065f"), Hex.decode("8861d7165d9983a987e4ac39b9013ae41377f2134e5c7b57d6f8a3653e0ee616f0ddc9e11d85a8fd")});
        kats.put("AES-256", new byte[][]{Hex.decode("f5771b72bb3c3ceeea5d4327159f7bcf5d3aed67adaa039528b3d5f846961700734ac1aa5d401709"), Hex.decode("a6b09617644ea00b797ce09060d23682b89a09c293fb5fac71ba77943421a7559557bd957bce64c9")});
        reseedValues.put("TRIPLEDES", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415"), Hex.decode("0807060504030201")});
        reseedValues.put("AES-128", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-192", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415161718"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-256", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f100102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedKats.put("TRIPLEDES", new byte[][]{Hex.decode("48ce7cefb4ec0f4a5a3b50c09a309675a9827404e01e0adff50a6d8d895d0308f6fffaf5e8159a8a"), Hex.decode("19d8a900cf51f131070cbbf22a7028edb42d79c836feb0a270e6703bf7d64ffa7bab66922bc7597b")});
        reseedKats.put("AES-128", new byte[][]{Hex.decode("af649344a18257a1448aca5e7014c784cf01618ac354a4dd9b63b83f10fd4d31eff645b737619fd7"), Hex.decode("c63ff00c3f966108d53270633a945b87fd11d8344946589f1533617323895593229d060c0b25f53e")});
        reseedKats.put("AES-192", new byte[][]{Hex.decode("544c683bd1538f349b62135813dc752ee329244ec83e037039dc35beb12a28ea505cdb81ec4bd61e"), Hex.decode("58dda13ba129e5ea009c8d0dac7cc5c998b84d52f759acfffa9bdd08d7cdbedc185114e270679e99")});
        reseedKats.put("AES-256", new byte[][]{Hex.decode("e20e7e3e5fc4876ac58b412c20b0cd173e0c934762f32d558f84c7a533efcee1b1571253afe18551"), Hex.decode("bae2554712e8143be922d97125c7b88fd768dd7c359fc1fe413f6ba5cb83892fe4a407c8aec04762")});
        K_BITS = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
    }
}

