/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import java.security.Permission;
import java.security.SecureRandom;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

class KeyUtils {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    KeyUtils() {
    }

    static BigInteger validated(DHDomainParameters dhParams, BigInteger y) {
        if (y.compareTo(TWO) < 0 || y.compareTo(dhParams.getP().subtract(TWO)) > 0) {
            throw new IllegalArgumentException("Y value is out of range");
        }
        if (dhParams.getQ() != null) {
            if (BigInteger.ONE.equals(y.modPow(dhParams.getQ(), dhParams.getP()))) {
                return y;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return y;
    }

    static BigInteger validated(DSADomainParameters dsaParams, BigInteger y) {
        if (dsaParams != null) {
            if (TWO.compareTo(y) <= 0 && dsaParams.getP().subtract(TWO).compareTo(y) >= 0 && BigInteger.ONE.equals(y.modPow(dsaParams.getQ(), dsaParams.getP()))) {
                return y;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return y;
    }

    static BigInteger validated(BigInteger modulus, BigInteger publicExponent) {
        if ((publicExponent.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA publicExponent is even");
        }
        return KeyUtils.validatedModulus(modulus);
    }

    static BigInteger validatedModulus(BigInteger modulus) {
        if (!AsymmetricRSAKey.isAlreadySeen(modulus)) {
            if ((modulus.intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA modulus is even");
            }
            if (!modulus.gcd(new BigInteger("1451887755777639901511587432083070202422614380984889313550570919659315177065956574359078912654149167643992684236991305777574330831666511589145701059710742276692757882915756220901998212975756543223550490431013061082131040808010565293748926901442915057819663730454818359472391642885328171302299245556663073719855")).equals(BigInteger.ONE)) {
                throw new IllegalArgumentException("RSA modulus has a small prime factor");
            }
            int bits = modulus.bitLength() / 2;
            int iterations = bits >= 1536 ? 3 : (bits >= 1024 ? 4 : (bits >= 512 ? 7 : 50));
            FipsSecureRandom testRandom = FipsDRBG.SHA256.fromEntropySource(new SecureRandom(), false).build(Pack.longToBigEndian(System.currentTimeMillis()), false, Strings.toByteArray(Thread.currentThread().toString()));
            Primes.MROutput mr = Primes.enhancedMRProbablePrimeTest(modulus, testRandom, iterations);
            if (!mr.isProvablyComposite()) {
                throw new IllegalArgumentException("RSA modulus is not composite");
            }
            if (!mr.isNotPrimePower()) {
                throw new IllegalArgumentException("RSA modulus is a power of a prime");
            }
        }
        return modulus;
    }

    static ECPoint validated(ECCurve c, ECPoint q) {
        if (q == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if ((q = ECAlgorithms.importPoint(c, q).normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        if (!q.isValid()) {
            throw new IllegalArgumentException("Point not on curve");
        }
        return q;
    }

    static ECPoint validated(ECCurve c, byte[] encodedPoint) {
        if (encodedPoint == null) {
            throw new IllegalArgumentException("Point encoding has null value");
        }
        ECPoint q = c.decodePoint(encodedPoint);
        if (q == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if ((q = q.normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        return q;
    }

    static boolean isNotNull(ASN1Encodable parameters) {
        return parameters != null && !DERNull.INSTANCE.equals(parameters.toASN1Primitive());
    }

    static X962Parameters buildCurveParameters(ECDomainParameters curveParams) {
        X962Parameters params;
        if (curveParams instanceof NamedECDomainParameters) {
            params = new X962Parameters(((NamedECDomainParameters)curveParams).getID());
        } else if (curveParams instanceof ECImplicitDomainParameters) {
            params = new X962Parameters(DERNull.INSTANCE);
        } else {
            X9ECParameters ecP = new X9ECParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH(), curveParams.getSeed());
            params = new X962Parameters(ecP);
        }
        return params;
    }

    static int getOrderBitLength(ECDomainParameters curveParams) {
        return curveParams.getN().bitLength();
    }

    static boolean isDHPKCSParam(ASN1Encodable params) {
        ASN1Sequence seq = ASN1Sequence.getInstance(params);
        if (seq.size() == 2) {
            return true;
        }
        if (seq.size() > 3) {
            return false;
        }
        ASN1Integer l = ASN1Integer.getInstance(seq.getObjectAt(2));
        ASN1Integer p = ASN1Integer.getInstance(seq.getObjectAt(0));
        return l.getValue().compareTo(BigInteger.valueOf(p.getValue().bitLength())) <= 0;
    }

    static byte[] getEncodedInfo(ASN1Object info) {
        try {
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }

    static byte[] getEncodedSubjectPublicKeyInfo(AlgorithmIdentifier algId, ASN1Encodable pubKey) {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algId, pubKey.toASN1Primitive());
            return KeyUtils.getEncodedInfo(info);
        }
        catch (Exception e) {
            return null;
        }
    }

    static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algId, ASN1Encodable privKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(algId, privKey.toASN1Primitive());
            return KeyUtils.getEncodedInfo(info);
        }
        catch (Exception e) {
            return null;
        }
    }

    static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algId, ASN1Encodable privKey, ASN1Set attributes, byte[] publicKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(algId, privKey.toASN1Primitive(), attributes, publicKey);
            return KeyUtils.getEncodedInfo(info);
        }
        catch (Exception e) {
            return null;
        }
    }

    static void checkDestroyed(Destroyable destroyable) {
        if (destroyable.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }

    static void checkPermission(Permission keyPermission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(keyPermission);
        }
    }

    static boolean isValidPrefix(byte[] prefix, byte[] encoding) {
        if (encoding.length < prefix.length) {
            return !KeyUtils.isValidPrefix(prefix, prefix);
        }
        int nonEqual = 0;
        for (int i = 0; i != prefix.length; ++i) {
            nonEqual |= prefix[i] ^ encoding[i];
        }
        return nonEqual == 0;
    }

    static boolean isFieldEqual(Object a, Object b) {
        return a != null && a.equals(b);
    }
}

