/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricGOST3410PrivateKey
extends AsymmetricGOST3410Key<GOST3410DomainParameters>
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<GOST3410DomainParameters> params, BigInteger x) {
        super(algorithm, params);
        this.x = x;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, byte[] enc) {
        this(algorithm, PrivateKeyInfo.getInstance(enc));
    }

    public AsymmetricGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_94, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo info) {
        try {
            ASN1OctetString derX = ASN1OctetString.getInstance(info.parsePrivateKey());
            byte[] keyEnc = derX.getOctets();
            byte[] keyBytes = new byte[keyEnc.length];
            for (int i = 0; i != keyEnc.length; ++i) {
                keyBytes[i] = keyEnc[keyEnc.length - 1 - i];
            }
            return new BigInteger(1, keyBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + e.getMessage(), e);
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final GOST3410Parameters<GOST3410DomainParameters> getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    @Override
    public final byte[] getEncoded() {
        byte[] keyEnc = this.getX().toByteArray();
        byte[] keyBytes = keyEnc[0] == 0 ? new byte[keyEnc.length - 1] : new byte[keyEnc.length];
        for (int i = 0; i != keyBytes.length; ++i) {
            keyBytes[i] = keyEnc[keyEnc.length - 1 - i];
        }
        GOST3410Parameters<GOST3410DomainParameters> params = this.getParameters();
        if (params.getEncryptionParamSet() != null) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(params.getPublicKeyParamSet(), params.getDigestParamSet(), params.getEncryptionParamSet())), new DEROctetString(keyBytes));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(params.getPublicKeyParamSet(), params.getDigestParamSet())), new DEROctetString(keyBytes));
    }

    public BigInteger getX() {
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger xVal = this.x;
        KeyUtils.checkDestroyed(this);
        return xVal;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricGOST3410PrivateKey other = (AsymmetricGOST3410PrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        return KeyUtils.isFieldEqual(this.x, other.x) && KeyUtils.isFieldEqual(this.domainParameters, other.domainParameters);
    }
}

