/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.ua.DSTU4145ECBinary;
import org.bouncycastle.asn1.ua.DSTU4145Params;
import org.bouncycastle.asn1.ua.UAObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145Key;
import org.bouncycastle.crypto.asymmetric.DSTU4145Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.math.ec.ECCurve;

public final class AsymmetricDSTU4145PrivateKey
extends AsymmetricDSTU4145Key
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private PrivateKeyInfo privKeyInfo;
    private BigInteger d;

    public AsymmetricDSTU4145PrivateKey(Algorithm algorithm, DSTU4145Parameters parameters, BigInteger s) {
        super(algorithm, parameters);
        this.d = s;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm ecAlg, byte[] encoding) {
        this(ecAlg, PrivateKeyInfo.getInstance(encoding));
    }

    public AsymmetricDSTU4145PrivateKey(Algorithm ecAlg, PrivateKeyInfo privateKeyInfo) {
        super(ecAlg, privateKeyInfo.getPrivateKeyAlgorithm());
        this.privKeyInfo = privateKeyInfo;
        this.d = AsymmetricDSTU4145PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1Encodable privKey = privateKeyInfo.parsePrivateKey();
            if (privKey instanceof ASN1Integer) {
                ASN1Integer derD = ASN1Integer.getInstance(privKey);
                return derD.getValue();
            }
            return ECPrivateKey.getInstance(privKey).getKey();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid info structure in DSTU4145 private key");
        }
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (this.privKeyInfo != null) {
            return KeyUtils.getEncodedInfo(this.privKeyInfo);
        }
        DSTU4145Parameters dstu4145Parameters = this.getParameters();
        int orderBitLength = KeyUtils.getOrderBitLength(dstu4145Parameters.getDomainParameters());
        if (dstu4145Parameters.getDomainParameters() instanceof NamedECDomainParameters) {
            NamedECDomainParameters namedECDomainParameters = (NamedECDomainParameters)dstu4145Parameters.getDomainParameters();
            DSTU4145Params params = new DSTU4145Params(namedECDomainParameters.getID(), dstu4145Parameters.getDKE());
            ECPrivateKey keyStructure = new ECPrivateKey(orderBitLength, this.getS(), params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, params), keyStructure);
        }
        if (dstu4145Parameters.getDomainParameters().getCurve() instanceof ECCurve.AbstractF2m) {
            DSTU4145ECBinary binary = new DSTU4145ECBinary(dstu4145Parameters.getDomainParameters());
            DSTU4145Params params = new DSTU4145Params(binary);
            ECPrivateKey keyStructure = new ECPrivateKey(orderBitLength, this.getS(), params);
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, params), keyStructure);
        }
        throw new IllegalArgumentException("Unable to encode binary parameters");
    }

    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public final DSTU4145Parameters getParameters() {
        DSTU4145Parameters parameters = super.getParameters();
        KeyUtils.checkDestroyed(this);
        return parameters;
    }

    public final BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger dVal = this.d;
        KeyUtils.checkDestroyed(this);
        return dVal;
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.d = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricDSTU4145PrivateKey)) {
            return false;
        }
        AsymmetricDSTU4145PrivateKey other = (AsymmetricDSTU4145PrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        return KeyUtils.isFieldEqual(this.d, other.d) && KeyUtils.isFieldEqual(this.parameters, other.parameters);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.d.hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

