/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

public final class SymmetricSecretKey
implements SymmetricKey,
Destroyable {
    private final boolean approvedModeOnly;
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);

    public SymmetricSecretKey(Algorithm algorithm, byte[] bytes) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])bytes.clone();
    }

    public SymmetricSecretKey(Parameters parameterSet, byte[] bytes) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = parameterSet.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])bytes.clone();
    }

    public Algorithm getAlgorithm() {
        this.checkDestroyed();
        return this.algorithm;
    }

    private void zeroize() {
        for (int i = 0; i != this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        byte[] clone = Arrays.clone(this.bytes);
        this.checkDestroyed();
        return clone;
    }

    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey other = (SymmetricSecretKey)o;
        other.checkApprovedOnlyModeStatus();
        return this.algorithm != null && this.algorithm.equals(other.algorithm) && Arrays.constantTimeAreEqual(this.bytes, other.bytes);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }

    public void destroy() throws DestroyFailedException {
        if (this.hasBeenDestroyed.compareAndSet(false, true)) {
            this.zeroize();
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }
}

