/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.test;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;

public class FixedEntropySourceProvider
implements EntropySourceProvider {
    private final byte[] data;
    private final boolean isPredictionResistant;

    public FixedEntropySourceProvider(byte[] data, boolean isPredictionResistant) {
        this.data = data;
        this.isPredictionResistant = isPredictionResistant;
    }

    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){
            boolean first = true;
            int index = 0;

            public boolean isPredictionResistant() {
                return FixedEntropySourceProvider.this.isPredictionResistant;
            }

            public byte[] getEntropy() {
                byte[] rv = new byte[(bitsRequired + 7) / 8];
                System.arraycopy(FixedEntropySourceProvider.this.data, this.index, rv, 0, rv.length);
                if (this.first) {
                    int i = 0;
                    while (i != rv.length) {
                        int n = i++;
                        rv[n] = (byte)(rv[n] ^ 0xFF);
                    }
                    this.first = false;
                } else {
                    this.index += (bitsRequired + 7) / 8;
                }
                return rv;
            }

            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

