/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.internal;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat128 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] x, int[] y, int[] z) {
        long c = 0L;
        z[0] = (int)(c += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL));
        c >>>= 32;
        z[1] = (int)(c += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL));
        c >>>= 32;
        z[2] = (int)(c += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL));
        c >>>= 32;
        z[3] = (int)(c += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL));
        return (int)(c >>>= 32);
    }

    public static int addBothTo(int[] x, int[] y, int[] z) {
        long c = 0L;
        z[0] = (int)(c += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        c >>>= 32;
        z[1] = (int)(c += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        c >>>= 32;
        z[2] = (int)(c += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        c >>>= 32;
        z[3] = (int)(c += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        return (int)(c >>>= 32);
    }

    public static void copy(int[] x, int[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
    }

    public static void copy(int[] x, int xOff, int[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
    }

    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
    }

    public static void copy64(long[] x, int xOff, long[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
    }

    public static int[] create() {
        return new int[4];
    }

    public static long[] create64() {
        return new long[2];
    }

    public static int[] createExt() {
        return new int[8];
    }

    public static long[] createExt64() {
        return new long[4];
    }

    public static boolean eq(int[] x, int[] y) {
        for (int i = 3; i >= 0; --i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] x, long[] y) {
        for (int i = 1; i >= 0; --i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        int[] z = Nat128.create();
        int i = 0;
        while (x.signum() != 0) {
            z[i++] = x.intValue();
            x = x.shiftRight(32);
        }
        return z;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        long[] z = Nat128.create64();
        int i = 0;
        while (x.signum() != 0) {
            z[i++] = x.longValue();
            x = x.shiftRight(64);
        }
        return z;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int w = bit >> 5;
        if (w < 0 || w >= 4) {
            return 0;
        }
        int b = bit & 0x1F;
        return x[w] >>> b & 1;
    }

    public static boolean gte(int[] x, int[] y) {
        for (int i = 3; i >= 0; --i) {
            int x_i = x[i] ^ Integer.MIN_VALUE;
            int y_i = y[i] ^ Integer.MIN_VALUE;
            if (x_i < y_i) {
                return false;
            }
            if (x_i <= y_i) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            if (x[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        for (int i = 1; i < 2; ++i) {
            if (x[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x) {
        for (int i = 0; i < 4; ++i) {
            if (x[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        for (int i = 0; i < 2; ++i) {
            if (x[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        long y_0 = (long)y[0] & 0xFFFFFFFFL;
        long y_1 = (long)y[1] & 0xFFFFFFFFL;
        long y_2 = (long)y[2] & 0xFFFFFFFFL;
        long y_3 = (long)y[3] & 0xFFFFFFFFL;
        long c = 0L;
        long x_0 = (long)x[0] & 0xFFFFFFFFL;
        zz[0] = (int)(c += x_0 * y_0);
        c >>>= 32;
        zz[1] = (int)(c += x_0 * y_1);
        c >>>= 32;
        zz[2] = (int)(c += x_0 * y_2);
        c >>>= 32;
        zz[3] = (int)(c += x_0 * y_3);
        zz[4] = (int)(c >>>= 32);
        for (int i = 1; i < 4; ++i) {
            long c2 = 0L;
            long x_i = (long)x[i] & 0xFFFFFFFFL;
            zz[i + 0] = (int)(c2 += x_i * y_0 + ((long)zz[i + 0] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 1] = (int)(c2 += x_i * y_1 + ((long)zz[i + 1] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 2] = (int)(c2 += x_i * y_2 + ((long)zz[i + 2] & 0xFFFFFFFFL));
            c2 >>>= 32;
            zz[i + 3] = (int)(c2 += x_i * y_3 + ((long)zz[i + 3] & 0xFFFFFFFFL));
            zz[i + 4] = (int)(c2 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x, int[] y, int[] zz) {
        long y_0 = (long)y[0] & 0xFFFFFFFFL;
        long y_1 = (long)y[1] & 0xFFFFFFFFL;
        long y_2 = (long)y[2] & 0xFFFFFFFFL;
        long y_3 = (long)y[3] & 0xFFFFFFFFL;
        long zc = 0L;
        for (int i = 0; i < 4; ++i) {
            long c = 0L;
            long x_i = (long)x[i] & 0xFFFFFFFFL;
            zz[i + 0] = (int)(c += x_i * y_0 + ((long)zz[i + 0] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 1] = (int)(c += x_i * y_1 + ((long)zz[i + 1] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 2] = (int)(c += x_i * y_2 + ((long)zz[i + 2] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 3] = (int)(c += x_i * y_3 + ((long)zz[i + 3] & 0xFFFFFFFFL));
            c >>>= 32;
            zz[i + 4] = (int)(c += zc + ((long)zz[i + 4] & 0xFFFFFFFFL));
            zc = c >>> 32;
        }
        return (int)zc;
    }

    public static void square(int[] x, int[] zz) {
        long x_0 = (long)x[0] & 0xFFFFFFFFL;
        int c = 0;
        int i = 3;
        int j = 8;
        do {
            long xVal = (long)x[i--] & 0xFFFFFFFFL;
            long p = xVal * xVal;
            zz[--j] = c << 31 | (int)(p >>> 33);
            zz[--j] = (int)(p >>> 1);
            c = (int)p;
        } while (i > 0);
        long p = x_0 * x_0;
        long zz_1 = (long)(c << 31) & 0xFFFFFFFFL | p >>> 33;
        zz[0] = (int)p;
        c = (int)(p >>> 32) & 1;
        long x_1 = (long)x[1] & 0xFFFFFFFFL;
        long zz_2 = (long)zz[2] & 0xFFFFFFFFL;
        int w = (int)(zz_1 += x_1 * x_0);
        zz[1] = w << 1 | c;
        c = w >>> 31;
        zz_2 += zz_1 >>> 32;
        long x_2 = (long)x[2] & 0xFFFFFFFFL;
        long zz_3 = (long)zz[3] & 0xFFFFFFFFL;
        long zz_4 = (long)zz[4] & 0xFFFFFFFFL;
        w = (int)(zz_2 += x_2 * x_0);
        zz[2] = w << 1 | c;
        c = w >>> 31;
        zz_3 &= 0xFFFFFFFFL;
        long x_3 = (long)x[3] & 0xFFFFFFFFL;
        long zz_5 = ((long)zz[5] & 0xFFFFFFFFL) + ((zz_4 += (zz_3 += (zz_2 >>> 32) + x_2 * x_1) >>> 32) >>> 32);
        zz_4 &= 0xFFFFFFFFL;
        long zz_6 = ((long)zz[6] & 0xFFFFFFFFL) + (zz_5 >>> 32);
        zz_5 &= 0xFFFFFFFFL;
        w = (int)(zz_3 += x_3 * x_0);
        zz[3] = w << 1 | c;
        c = w >>> 31;
        zz_6 += (zz_5 += ((zz_4 += (zz_3 >>> 32) + x_3 * x_1) >>> 32) + x_3 * x_2) >>> 32;
        w = (int)zz_4;
        zz[4] = w << 1 | c;
        c = w >>> 31;
        w = (int)(zz_5 &= 0xFFFFFFFFL);
        zz[5] = w << 1 | c;
        c = w >>> 31;
        w = (int)zz_6;
        zz[6] = w << 1 | c;
        c = w >>> 31;
        w = zz[7] + (int)(zz_6 >>> 32);
        zz[7] = w << 1 | c;
    }

    public static int sub(int[] x, int[] y, int[] z) {
        long c = 0L;
        z[0] = (int)(c += ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        c >>= 32;
        z[1] = (int)(c += ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        c >>= 32;
        z[2] = (int)(c += ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        c >>= 32;
        z[3] = (int)(c += ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        return (int)(c >>= 32);
    }

    public static int subFrom(int[] x, int[] z) {
        long c = 0L;
        z[0] = (int)(c += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL));
        c >>= 32;
        z[1] = (int)(c += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL));
        c >>= 32;
        z[2] = (int)(c += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL));
        c >>= 32;
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL));
        return (int)(c >>= 32);
    }

    public static BigInteger toBigInteger(int[] x) {
        byte[] bs = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int x_i = x[i];
            if (x_i == 0) continue;
            Pack.intToBigEndian(x_i, bs, 3 - i << 2);
        }
        return new BigInteger(1, bs);
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] bs = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long x_i = x[i];
            if (x_i == 0L) continue;
            Pack.longToBigEndian(x_i, bs, 1 - i << 3);
        }
        return new BigInteger(1, bs);
    }

    public static void zero(int[] z) {
        z[0] = 0;
        z[1] = 0;
        z[2] = 0;
        z[3] = 0;
    }
}

