/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.jcajce.spec.PrfUtils;

public class PBKDF2KeySpec
extends PBEKeySpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private AlgorithmIdentifier prf;

    public PBKDF2KeySpec(char[] password, byte[] salt, int iterationCount, int keySize) {
        this(password, salt, iterationCount, keySize, defaultPRF);
    }

    public PBKDF2KeySpec(char[] password, byte[] salt, int iterationCount, int keySize, DigestAlgorithm prfAlgorithm) {
        this(password, salt, iterationCount, keySize, PrfUtils.getAlgorithmIdentifier(prfAlgorithm));
    }

    public PBKDF2KeySpec(char[] password, byte[] salt, int iterationCount, int keySize, AlgorithmIdentifier prf) {
        super(password, salt, iterationCount, keySize);
        this.prf = prf;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

