/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.pkcs.PBEParameter;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.jcajce.PBKDF1Key;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;

class ProvPBEPBKDF1
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBEPBKDF1.class.getName();

    ProvPBEPBKDF1() {
    }

    public void configure(BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("AlgorithmParameters.PBKDF1", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new AlgParams();
            }
        }));
    }

    static byte[] getSecretKey(SecretKey pbeKey, PBEParameterSpec pbeSpec, DigestAlgorithm prf, PasswordBasedDeriver.KeyType keyType, int keySizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(prf, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKey(keyType, (keySizeInBits + 7) / 8);
    }

    static byte[][] getSecretKeyAndIV(SecretKey pbeKey, PBEParameterSpec pbeSpec, DigestAlgorithm prf, PasswordBasedDeriver.KeyType keyType, int keySizeInBits, int ivvSizeInBits) {
        PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(prf, pbeKey.getEncoded()).withIterationCount(pbeSpec.getIterationCount()).withSalt(pbeSpec.getSalt()));
        return deriver.deriveKeyAndIV(keyType, (keySizeInBits + 7) / 8, (ivvSizeInBits + 7) / 8);
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBEParameter params;

        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF1 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            try {
                this.params = new PBEParameter(pbeSpec.getSalt(), pbeSpec.getIterationCount());
            }
            catch (Exception e) {
                throw new InvalidParameterSpecException(e.getMessage());
            }
        }

        protected void localInit(byte[] params) throws IOException {
            this.params = PBEParameter.getInstance(params);
        }

        protected String engineToString() {
            return "PBKDF1 Parameters";
        }
    }

    public static class FixedPBKDF1
    extends BaseKDFSecretKeyFactory {
        private final String algorithm;
        private final PasswordConverter passwordConverter;
        private final DigestAlgorithm prfAlg;
        private final int keySizeInBits;

        public FixedPBKDF1(String algorithm, PasswordConverter passwordConverter, DigestAlgorithm prfAlg, int keySizeInBits) {
            this.algorithm = algorithm;
            this.passwordConverter = passwordConverter;
            this.prfAlg = prfAlg;
            this.keySizeInBits = keySizeInBits;
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    return new PBKDF1Key(((PBEKeySpec)keySpec).getPassword(), this.passwordConverter);
                }
                PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(this.prfAlg, this.passwordConverter, pbeSpec.getPassword()).withSalt(pbeSpec.getSalt()).withIterationCount(pbeSpec.getIterationCount()));
                return new PBKDFPBEKey(deriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, (this.keySizeInBits + 7) / 8), this.algorithm, pbeSpec);
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

