/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.ProvEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.ProvXDHPrivateKey;
import org.bouncycastle.jcajce.provider.ProvXDHPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;

class ProvEdEC
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalEdDSAAttributes = new HashMap<String, String>();
    private static final Map<String, String> generalXDHAttributes = new HashMap<String, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.edec.";
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private static final PublicKeyConverter<AsymmetricEdDSAPublicKey> edPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricEdDSAPrivateKey> edPrivateKeyConverter;
    private static final PublicKeyConverter<AsymmetricXDHPublicKey> xPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricXDHPrivateKey> xPrivateKeyConverter;

    ProvEdEC() {
    }

    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyFactory.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.XDH();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.X448();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.X25519();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$EdDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.EdDSA();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.Ed448();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.Ed25519();
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$EdDSA", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, null);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, EdEC.Ed448);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, EdEC.Ed25519);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, null);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, EdEC.X448);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, EdEC.X25519);
            }
        }));
        provider.addAlgorithmImplementation("Signature.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$EDDSA", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.EdDSA);
            }
        }));
        provider.addAlgorithmImplementation("Signature.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed448", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed448);
            }
        }));
        provider.addAlias("Signature", "ED448", EdECObjectIdentifiers.id_Ed448);
        provider.addAlgorithmImplementation("Signature.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed25519);
            }
        }));
        provider.addAlias("Signature", "ED25519", EdECObjectIdentifiers.id_Ed25519);
        this.addKeyAgreementAlgorithm(provider, "XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$XDH", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
            }
        }));
        this.addKeyAgreementAlgorithm(provider, "X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
            }
        }));
        provider.addAlias("KeyAgreement", "X448", EdECObjectIdentifiers.id_X448);
        this.addKeyAgreementAlgorithm(provider, "X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X25519));
            }
        }));
        provider.addAlias("KeyAgreement", "X25519", EdECObjectIdentifiers.id_X25519);
        this.registerOid(provider, EdECObjectIdentifiers.id_X448, "X448", new KeyFactorySpi.X448());
        this.registerOid(provider, EdECObjectIdentifiers.id_X25519, "X25519", new KeyFactorySpi.X25519());
        this.registerOid(provider, EdECObjectIdentifiers.id_Ed448, "ED448", new KeyFactorySpi.Ed448());
        this.registerOid(provider, EdECObjectIdentifiers.id_Ed25519, "ED25519", new KeyFactorySpi.Ed25519());
    }

    static {
        generalEdDSAAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.EdDSAKey");
        generalEdDSAAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        generalXDHAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.XDHKey");
        generalXDHAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        edPublicKeyConverter = new PublicKeyConverter<AsymmetricEdDSAPublicKey>(){

            @Override
            public AsymmetricEdDSAPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof ProvEdDSAPublicKey) {
                    return ((ProvEdDSAPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPublicKey(Utils.getKeyEncoding(key));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EdDSA public key: " + e.getMessage(), e);
                }
            }
        };
        edPrivateKeyConverter = new PrivateKeyConverter<AsymmetricEdDSAPrivateKey>(){

            @Override
            public AsymmetricEdDSAPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof ProvEdDSAPrivateKey) {
                    return ((ProvEdDSAPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EdDSA private key: " + e.getMessage(), e);
                }
            }
        };
        xPublicKeyConverter = new PublicKeyConverter<AsymmetricXDHPublicKey>(){

            @Override
            public AsymmetricXDHPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof ProvXDHPublicKey) {
                    return ((ProvXDHPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPublicKey(Utils.getKeyEncoding(key));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify XDH public key: " + e.getMessage(), e);
                }
            }
        };
        xPrivateKeyConverter = new PrivateKeyConverter<AsymmetricXDHPrivateKey>(){

            @Override
            public AsymmetricXDHPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof ProvXDHPrivateKey) {
                    return ((ProvXDHPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify XDH private key: " + e.getMessage(), e);
                }
            }
        };
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;
        private final boolean isXdh;
        private final int specificBase;

        public KeyFactorySpi(String algorithm, boolean isXdh, int specificBase) {
            this.algorithm = algorithm;
            this.isXdh = isXdh;
            this.specificBase = specificBase;
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                if (this.isXdh) {
                    GeneralAlgorithm alg = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPublicKey((AsymmetricXDHPublicKey)xPublicKeyConverter.convertKey(alg, (PublicKey)key));
                }
                GeneralAlgorithm alg = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                return new ProvEdDSAPublicKey((AsymmetricEdDSAPublicKey)edPublicKeyConverter.convertKey(alg, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                if (this.isXdh) {
                    GeneralAlgorithm alg = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPrivateKey((AsymmetricXDHPrivateKey)xPrivateKeyConverter.convertKey(alg, (PrivateKey)key));
                }
                GeneralAlgorithm alg = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                return new ProvEdDSAPrivateKey((AsymmetricEdDSAPrivateKey)edPrivateKeyConverter.convertKey(alg, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, spec);
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
                if (this.specificBase == 0 || this.specificBase == enc[8]) {
                    switch (enc[8]) {
                        case 111: {
                            return new ProvXDHPublicKey(enc);
                        }
                        case 110: {
                            return new ProvXDHPublicKey(enc);
                        }
                        case 113: {
                            return new ProvEdDSAPublicKey(enc);
                        }
                        case 112: {
                            return new ProvEdDSAPublicKey(enc);
                        }
                    }
                    return super.engineGeneratePublic(keySpec);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPrivateKey(keyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPrivateKey(keyInfo);
                }
            } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPrivateKey(keyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPrivateKey(keyInfo);
                }
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPublicKey(keyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPublicKey(keyInfo.getEncoded());
                }
            } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPublicKey(keyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPublicKey(keyInfo.getEncoded());
                }
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }

        static class Ed25519
        extends KeyFactorySpi {
            public Ed25519() {
                super("Ed25519", false, 112);
            }
        }

        static class Ed448
        extends KeyFactorySpi {
            public Ed448() {
                super("Ed448", false, 113);
            }
        }

        static class EdDSA
        extends KeyFactorySpi {
            public EdDSA() {
                super("EdDSA", false, 0);
            }
        }

        static class X25519
        extends KeyFactorySpi {
            public X25519() {
                super("X25519", true, 110);
            }
        }

        static class X448
        extends KeyFactorySpi {
            public X448() {
                super("X448", true, 111);
            }
        }

        static class XDH
        extends KeyFactorySpi {
            public XDH() {
                super("XDH", true, 0);
            }
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        private final boolean isXDH;
        private EdEC.Parameters params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider provider, boolean isXDH, EdEC.Parameters params) {
            super(params != null ? ((GeneralAlgorithm)params.getAlgorithm()).getName() : (isXDH ? "XDH" : "EdDSA"));
            this.params = params;
            this.provider = provider;
            this.isXDH = isXDH;
        }

        public void initialize(int strength) {
            this.initialize(strength, this.provider.getDefaultSecureRandom());
        }

        public void initialize(int strength, SecureRandom secureRandom) {
            this.random = secureRandom;
            switch (strength) {
                case 255: 
                case 256: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X25519) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X25519;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed25519) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed25519;
                    break;
                }
                case 448: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X448) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X448;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed448) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed448;
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown key size.");
                }
            }
        }

        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.provider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECGenParameterSpec) {
                this.params = this.getParams(((ECGenParameterSpec)params).getName());
            } else if (!this.isXDH && params instanceof EdDSAParameterSpec) {
                this.params = this.getParams(((EdDSAParameterSpec)params).getCurveName());
            } else if (this.isXDH && params instanceof XDHParameterSpec) {
                this.params = this.getParams(((XDHParameterSpec)params).getCurveName());
            } else {
                if (params == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            this.random = random;
        }

        private EdEC.Parameters getParams(String name) throws InvalidAlgorithmParameterException {
            if (this.isXDH) {
                if (name.equalsIgnoreCase("X448") || name.equals(EdECObjectIdentifiers.id_X448.getId())) {
                    return EdEC.X448;
                }
                if (name.equalsIgnoreCase("X25519") || name.equals(EdECObjectIdentifiers.id_X25519.getId())) {
                    return EdEC.X25519;
                }
                throw new InvalidAlgorithmParameterException("unknown curve name: " + name);
            }
            if (name.equalsIgnoreCase("Ed448") || name.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
                return EdEC.Ed448;
            }
            if (name.equalsIgnoreCase("Ed25519") || name.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
                return EdEC.Ed25519;
            }
            throw new InvalidAlgorithmParameterException("unknown curve name: " + name);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                if (this.params == null) {
                    throw new IllegalStateException("generator not correctly initialized");
                }
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = this.isXDH ? new EdEC.XDHKeyPairGenerator(this.params, this.random) : new EdEC.EdDSAKeyPairGenerator(this.params, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair pair = this.engine.generateKeyPair();
            if (this.isXDH) {
                AsymmetricXDHPublicKey pub = (AsymmetricXDHPublicKey)pair.getPublicKey();
                AsymmetricXDHPrivateKey priv = (AsymmetricXDHPrivateKey)pair.getPrivateKey();
                return new KeyPair(new ProvXDHPublicKey(pub), new ProvXDHPrivateKey(priv));
            }
            AsymmetricEdDSAPublicKey pub = (AsymmetricEdDSAPublicKey)pair.getPublicKey();
            AsymmetricEdDSAPrivateKey priv = (AsymmetricEdDSAPrivateKey)pair.getPrivateKey();
            return new KeyPair(new ProvEdDSAPublicKey(pub), new ProvEdDSAPrivateKey(priv));
        }
    }

    static class XDHParametersCreator
    implements ParametersCreator {
        private final EdEC.Parameters params;

        XDHParametersCreator(EdEC.Parameters params) {
            this.params = params;
        }

        public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("unable to take parameter specs");
            }
            return this.params;
        }
    }
}

