/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.EC;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvECPrivateKey;
import org.bouncycastle.jcajce.provider.ProvECPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509AlgorithmParameters;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Properties;

class ProvEC
extends AsymmetricAlgorithmProvider {
    private static final AgreementFactory fipsDHFactory;
    private static final AgreementFactory fipsDHUFactory;
    private static final AgreementFactory fipsMQVFactory;
    private static final SignatureOperatorFactory fipsDsaFactory;
    private static final Map<String, String> generalEcAttributes;
    private static final String PREFIX;
    private static SignatureOperatorFactory genDsaFactory;
    private static final PublicKeyConverter<AsymmetricECPublicKey> publicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricECPrivateKey> privateKeyConverter;

    ProvEC() {
    }

    private static SignatureOperatorFactory getGeneralDSAFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (genDsaFactory == null) {
            genDsaFactory = new EC.DSAOperatorFactory();
        }
        return genDsaFactory;
    }

    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("AlgorithmParameters.EC", PREFIX + "AlgorithmParametersSpi$EC", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECAlgParams();
            }
        });
        final ParametersCreator dhParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                if (spec != null && !(spec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.DH;
            }
        };
        final ParametersCreator cdhParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                if (spec != null && !(spec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECCDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.CDH;
            }
        };
        ParametersCreator cdhuParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                try {
                    if (!(spec instanceof DHUParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("ECCDHU can only take an MQVParameterSpec");
                    }
                    DHUParameterSpec dhuSpec = (DHUParameterSpec)spec;
                    if (dhuSpec.getEphemeralPublicKey() != null) {
                        return FipsEC.CDHU.using((AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dhuSpec.getEphemeralPublicKey()), (AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dhuSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dhuSpec.getOtherPartyEphemeralKey()));
                    }
                    return FipsEC.CDHU.using((AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dhuSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.CDHU.getAlgorithm(), dhuSpec.getOtherPartyEphemeralKey()));
                }
                catch (InvalidKeyException e) {
                    throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + e.getMessage(), e);
                }
            }
        };
        provider.addAlgorithmImplementation("KeyFactory.EC", PREFIX + "KeyFactorySpi$EC", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyFactory(FipsEC.ALGORITHM);
            }
        });
        provider.addAlgorithmImplementation("KeyFactory.ECDSA", PREFIX + "KeyFactorySpi$ECDSA", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyFactory(FipsEC.DSA);
            }
        });
        provider.addAlgorithmImplementation("KeyFactory.ECDH", PREFIX + "KeyFactorySpi$ECDH", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyFactory(FipsEC.DH);
            }
        });
        provider.addAlgorithmImplementation("KeyFactory.ECCDH", PREFIX + "KeyFactorySpi$ECCDH", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyFactory(FipsEC.CDH);
            }
        });
        provider.addAlgorithmImplementation("KeyFactory.ECMQV", PREFIX + "KeyFactorySpi$ECMQV", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyFactory(FipsEC.MQV);
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.EC", PREFIX + "KeyPairGeneratorSpi$EC", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyPairGenerator(provider, FipsEC.ALGORITHM);
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.ECDSA", PREFIX + "KeyPairGeneratorSpi$ECDSA", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyPairGenerator(provider, FipsEC.DSA);
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.ECDH", PREFIX + "KeyPairGeneratorSpi$ECDH", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyPairGenerator(provider, FipsEC.DH);
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.ECCDH", PREFIX + "KeyPairGeneratorSpi$ECCDH", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyPairGenerator(provider, FipsEC.CDH);
            }
        });
        provider.addAlgorithmImplementation("KeyPairGenerator.ECMQV", PREFIX + "KeyPairGeneratorSpi$ECMQV", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ECKeyPairGenerator(provider, FipsEC.MQV);
            }
        });
        this.registerOid(provider, X9ObjectIdentifiers.id_ecPublicKey, "EC", new ECKeyFactory(FipsEC.DSA.getAlgorithm()));
        this.addKeyAgreementAlgorithm(provider, "ECDH", PREFIX + "KeyAgreementSpi$DH", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, dhParametersCreator);
            }
        });
        this.addKeyAgreementAlgorithm(provider, "ECCDH", PREFIX + "KeyAgreementSpi$CDH", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, cdhParametersCreator);
            }
        });
        provider.addAlias("Alg.Alias.KeyAgreement.ECDHC", "ECCDH");
        ECKeyFactory converter = new ECKeyFactory(FipsEC.DH);
        this.addDHAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, converter, dhParametersCreator);
        this.addDHAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, converter, dhParametersCreator);
        this.addDHAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, converter, dhParametersCreator);
        this.addDHAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, converter, dhParametersCreator);
        this.addDHAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, converter, dhParametersCreator);
        converter = new ECKeyFactory(FipsEC.CDH);
        this.addCDHAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, converter, cdhParametersCreator);
        this.addCDHAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, converter, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, cdhParametersCreator);
        this.addConcatCDHAlgorithm(provider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, cdhParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, cdhuParametersCreator);
        this.addCDHUAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, cdhuParametersCreator);
        this.addConcatCDHUAlgorithm(provider, "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, cdhuParametersCreator);
        provider.addAlgorithmImplementation("Signature.NONEWITHECDSA", PREFIX + "SignatureSpi$ecDSAwithNONE", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(null));
            }
        });
        provider.addAlias("Signature", "NONEWITHECDSA", "RAWECDSA");
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("Signature.SHA1WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA224WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA256WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA384WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA384", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA512WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA512(224)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA512(256)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA3-224WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA3-256WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA3-384WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_384", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384));
                }
            }));
            provider.addAlgorithmImplementation("Signature.SHA3-512WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA3_512", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512));
                }
            }));
            provider.addAlias("Alg.Alias.Signature.ECDDSA", "SHA1WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.DETECDSA", "SHA1WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA1WITHDETECDSA", "SHA1WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA224WITHDETECDSA", "SHA224WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA256WITHDETECDSA", "SHA256WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA384WITHDETECDSA", "SHA384WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA512WITHDETECDSA", "SHA512WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA512(224)WITHDETECDSA", "SHA512(224)WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA512(256)WITHDETECDSA", "SHA512(256)WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA3-224WITHDETECDSA", "SHA3-224WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA3-256WITHDETECDSA", "SHA3-256WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA3-384WITHDETECDSA", "SHA3-384WITHECDDSA");
            provider.addAlias("Alg.Alias.Signature.SHA3-512WITHDETECDSA", "SHA3-512WITHECDDSA");
        }
        this.addSignatureAlgorithm(provider, "SHA1", "ECDSA", PREFIX + "SignatureSpi$ecDSA1", X9ObjectIdentifiers.ecdsa_with_SHA1, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
            }
        });
        provider.addAlias("Signature", "SHA1WITHECDSA", "ECDSA");
        provider.addAlias("Signature", "SHA1WITHECDSA", TeleTrusTObjectIdentifiers.ecSignWithSha1);
        this.addSignatureAlgorithm(provider, "SHA224", "ECDSA", PREFIX + "SignatureSpi$ecDSA224", X9ObjectIdentifiers.ecdsa_with_SHA224, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA256", "ECDSA", PREFIX + "SignatureSpi$ecDSA256", X9ObjectIdentifiers.ecdsa_with_SHA256, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA384", "ECDSA", PREFIX + "SignatureSpi$ecDSA384", X9ObjectIdentifiers.ecdsa_with_SHA384, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA512", "ECDSA", PREFIX + "SignatureSpi$ecDSA512", X9ObjectIdentifiers.ecdsa_with_SHA512, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA512(224)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_224", null, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA512(256)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_256", null, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA3-224", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_224", NISTObjectIdentifiers.id_ecdsa_with_sha3_224, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA3-256", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_256", NISTObjectIdentifiers.id_ecdsa_with_sha3_256, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA3-384", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_384", NISTObjectIdentifiers.id_ecdsa_with_sha3_384, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384));
            }
        });
        this.addSignatureAlgorithm(provider, "SHA3-512", "ECDSA", PREFIX + "SignatureSpi$ecDSA3_512", NISTObjectIdentifiers.id_ecdsa_with_sha3_512, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512));
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addSignatureAlgorithm(provider, "RIPEMD160", "ECDSA", PREFIX + "SignatureSpi$ecDSARipeMD160", TeleTrusTObjectIdentifiers.ecSignWithRipemd160, generalEcAttributes, new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseSignature(provider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DSA.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160));
                }
            }));
        }
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv")) {
            converter = new ECKeyFactory(FipsEC.MQV.getAlgorithm());
            final ParametersCreator mqvParametersCreator = new ParametersCreator(){

                public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                    try {
                        if (!(spec instanceof MQVParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("ECMQV can only take an MQVParameterSpec");
                        }
                        MQVParameterSpec mqvSpec = (MQVParameterSpec)spec;
                        if (mqvSpec.getEphemeralPublicKey() != null) {
                            return FipsEC.MQV.using((AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mqvSpec.getEphemeralPublicKey()), (AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mqvSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mqvSpec.getOtherPartyEphemeralKey()));
                        }
                        return FipsEC.MQV.using((AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mqvSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mqvSpec.getOtherPartyEphemeralKey()));
                    }
                    catch (InvalidKeyException e) {
                        throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + e.getMessage(), e);
                    }
                }
            };
            this.addKeyAgreementAlgorithm(provider, "ECMQV", PREFIX + "KeyAgreementSpi$ECMQV", generalEcAttributes, new EngineCreator(){

                public Object createInstance(Object constructorParameter) {
                    return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator);
                }
            });
            this.addMQVAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, converter, mqvParametersCreator);
            this.addMQVAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, converter, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, mqvParametersCreator);
            this.addConcatMQVAlgorithm(provider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, mqvParametersCreator);
        }
    }

    private void addDHAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, ASN1ObjectIdentifier algOid, AsymmetricKeyInfoConverter converter, final ParametersCreator dhParametersCreator) {
        String algorithm = "ECDHWITH" + digestName + "KDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, dhParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
        if (algOid != null) {
            provider.addAlias("KeyAgreement", algorithm, algOid);
            this.registerOid(provider, algOid, "ECDH", converter);
            provider.addAlias("AlgorithmParameters", "EC", algOid);
        }
    }

    private void addCDHAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, ASN1ObjectIdentifier algOid, AsymmetricKeyInfoConverter converter, final ParametersCreator cdhParametersCreator) {
        String algorithm = "ECCDHWITH" + digestName + "KDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, cdhParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
        if (algOid != null) {
            provider.addAlias("KeyAgreement", algorithm, algOid);
            this.registerOid(provider, algOid, "ECCDH", converter);
            provider.addAlias("AlgorithmParameters", "EC", algOid);
        }
    }

    private void addConcatCDHAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, final ParametersCreator cdhParametersCreator) {
        String algorithm = "ECCDHWITH" + digestName + "CKDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, cdhParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    private void addCDHUAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, final ParametersCreator cdhParametersCreator) {
        String algorithm = "ECCDHUWITH" + digestName + "KDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHUFactory, publicKeyConverter, privateKeyConverter, cdhParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
    }

    private void addConcatCDHUAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, final ParametersCreator cdhParametersCreator) {
        String algorithm = "ECCDHUWITH" + digestName + "CKDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsDHUFactory, publicKeyConverter, privateKeyConverter, cdhParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    private void addMQVAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, ASN1ObjectIdentifier algOid, AsymmetricKeyInfoConverter converter, final ParametersCreator mqvParametersCreator) {
        String algorithm = "ECMQVWITH" + digestName + "KDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.X963.withPRF(prf));
            }
        });
        if (algOid != null) {
            provider.addAlias("KeyAgreement", algorithm, algOid);
            this.registerOid(provider, algOid, "EC", converter);
            provider.addAlias("AlgorithmParameters", "EC", algOid);
        }
    }

    private void addConcatMQVAlgorithm(BouncyCastleFipsProvider provider, String digestName, final FipsKDF.AgreementKDFPRF prf, final ParametersCreator mqvParametersCreator) {
        String algorithm = "ECMQVWITH" + digestName + "CKDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, PREFIX + "KeyAgreementSpi$" + algorithm, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        });
    }

    private static ECDomainParameters getDomainParametersFromGenSpec(ECGenParameterSpec genSpec) {
        NamedECDomainParameters domainParameters;
        String curveName = genSpec.getName();
        try {
            if (curveName.charAt(0) >= '0' && curveName.charAt(0) <= '2') {
                ASN1ObjectIdentifier oidID = new ASN1ObjectIdentifier(curveName);
                domainParameters = ECDomainParametersIndex.lookupDomainParameters(oidID);
            } else if (curveName.indexOf(32) > 0) {
                curveName = curveName.substring(curveName.indexOf(32) + 1);
                domainParameters = ProvEC.getNamedECDomainParametersFromName(curveName);
            } else {
                domainParameters = ProvEC.getNamedECDomainParametersFromName(curveName);
            }
        }
        catch (IllegalArgumentException ex) {
            domainParameters = ProvEC.getNamedECDomainParametersFromName(curveName);
        }
        return domainParameters;
    }

    private static NamedECDomainParameters getNamedECDomainParametersFromName(final String curveName) {
        return ECDomainParametersIndex.lookupDomainParameters(new ECDomainParametersID(){

            public String getCurveName() {
                return curveName;
            }
        });
    }

    static {
        generalEcAttributes = new HashMap<String, String>();
        PREFIX = ProvEC.class.getName() + ".";
        generalEcAttributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalEcAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        if (Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            fipsDHFactory = null;
            fipsDHUFactory = null;
            fipsMQVFactory = null;
            fipsDsaFactory = null;
        } else {
            fipsDHFactory = new FipsEC.DHAgreementFactory();
            fipsDHUFactory = new FipsEC.DHUAgreementFactory();
            fipsMQVFactory = Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv") ? null : new FipsEC.MQVAgreementFactory();
            fipsDsaFactory = new FipsEC.DSAOperatorFactory();
        }
        publicKeyConverter = new PublicKeyConverter<AsymmetricECPublicKey>(){

            @Override
            public AsymmetricECPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof ECPublicKey) {
                    if (key instanceof ProvECPublicKey) {
                        return ((ProvECPublicKey)key).getBaseKey();
                    }
                    return new ProvECPublicKey(algorithm, (ECPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricECPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EC public key: " + e.getMessage(), e);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricECPrivateKey>(){

            @Override
            public AsymmetricECPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof ECPrivateKey) {
                    if (key instanceof ProvECPrivateKey) {
                        return ((ProvECPrivateKey)key).getBaseKey();
                    }
                    return new ProvECPrivateKey(algorithm, (ECPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricECPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EC private key: " + e.getMessage(), e);
                }
            }
        };
    }

    static class ECAlgParams
    extends X509AlgorithmParameters {
        private ECDomainParameters domainParameters = ECDomainParametersIndex.lookupDomainParameters(SECObjectIdentifiers.secp521r1);

        ECAlgParams() {
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (ECParameterSpec.class.isAssignableFrom(paramSpec) || paramSpec == AlgorithmParameterSpec.class) {
                return ECUtil.convertToSpec(this.domainParameters);
            }
            if (ECGenParameterSpec.class.isAssignableFrom(paramSpec)) {
                if (this.domainParameters instanceof NamedECDomainParameters) {
                    return new ECGenParameterSpec(((NamedECDomainParameters)this.domainParameters).getID().getId());
                }
                ASN1ObjectIdentifier oid = ECDomainParametersIndex.lookupOID(this.domainParameters);
                if (oid != null) {
                    return new ECGenParameterSpec(oid.getId());
                }
                throw new InvalidParameterSpecException("Cannot identify curve in AlgorithmParameters by name");
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ECGenParameterSpec spec = (ECGenParameterSpec)algorithmParameterSpec;
                this.domainParameters = ProvEC.getDomainParametersFromGenSpec(spec);
                if (this.domainParameters == null) {
                    throw new InvalidParameterSpecException("EC AlgorithmParameters cannot recognize curve " + spec.getName());
                }
            } else if (algorithmParameterSpec instanceof ECDomainParameterSpec) {
                this.domainParameters = ((ECDomainParameterSpec)algorithmParameterSpec).getDomainParameters();
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                this.domainParameters = ECUtil.convertFromSpec((ECParameterSpec)algorithmParameterSpec);
            } else {
                throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
            }
        }

        protected void localInit(byte[] encoding) throws IOException {
            this.domainParameters = ECAlgParams.decodeCurveParameters(encoding);
        }

        protected byte[] localGetEncoded() throws IOException {
            X962Parameters params;
            if (this.domainParameters instanceof NamedECDomainParameters) {
                params = new X962Parameters(((NamedECDomainParameters)this.domainParameters).getID());
            } else if (this.domainParameters instanceof ECImplicitDomainParameters) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                X9ECParameters ecP = new X9ECParameters(this.domainParameters.getCurve(), this.domainParameters.getG(), this.domainParameters.getN(), this.domainParameters.getH(), this.domainParameters.getSeed());
                params = new X962Parameters(ecP);
            }
            return params.getEncoded();
        }

        private static ECDomainParameters decodeCurveParameters(byte[] encoding) throws IOException {
            X962Parameters params = X962Parameters.getInstance(encoding);
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                return ECDomainParametersIndex.lookupDomainParameters(oid);
            }
            if (!params.isImplicitlyCA()) {
                X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
                return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            ECDomainParameters ecDomainParameters = (ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA);
            if (ecDomainParameters == null) {
                throw new IOException("Encoding indicates implicitlyCA but CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA) returns null");
            }
            return new ECImplicitDomainParameters(ecDomainParameters);
        }

        protected String engineToString() {
            return "EC AlgorithmParameters " + this.domainParameters;
        }
    }

    static class ECKeyFactory
    extends BaseKeyFactory
    implements AsymmetricKeyInfoConverter {
        private final Algorithm algorithm;

        ECKeyFactory(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        ECKeyFactory(Parameters parameters) {
            this.algorithm = parameters.getAlgorithm();
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvECPublicKey((AsymmetricECPublicKey)publicKeyConverter.convertKey(this.algorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvECPrivateKey((AsymmetricECPrivateKey)privateKeyConverter.convertKey(this.algorithm, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            ECPrivateKey k;
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (spec.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
                ECPublicKey k2 = (ECPublicKey)key;
                if (k2.getParams() != null) {
                    return new ECPublicKeySpec(k2.getW(), k2.getParams());
                }
            } else if (spec.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof ECPrivateKey && (k = (ECPrivateKey)key).getParams() != null) {
                return new ECPrivateKeySpec(k.getS(), k.getParams());
            }
            return super.engineGetKeySpec(key, spec);
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPrivateKeySpec) {
                try {
                    return new ProvECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidKeySpecException(e.getMessage(), e);
                }
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPublicKeySpec) {
                try {
                    return new ProvECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidKeySpecException(e.getMessage(), e);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            return new ProvECPrivateKey(new AsymmetricECPrivateKey(this.algorithm, keyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            return new ProvECPublicKey(new AsymmetricECPublicKey(this.algorithm, keyInfo));
        }
    }

    static class ECKeyPairGenerator
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm algorithmType;
        private final Parameters parameters;
        private AsymmetricKeyPairGenerator engine;
        private int strength = 224;
        private boolean initialised = false;
        private static Hashtable ecParameters = new Hashtable();

        public ECKeyPairGenerator(BouncyCastleFipsProvider fipsProvider, Algorithm algorithmType) {
            this(fipsProvider, algorithmType, null);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider fipsProvider, Parameters parameters) {
            this(fipsProvider, parameters.getAlgorithm(), parameters);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider fipsProvider, Algorithm algorithmType, Parameters parameters) {
            super(algorithmType.getName());
            this.fipsProvider = fipsProvider;
            this.algorithmType = algorithmType;
            this.parameters = parameters;
        }

        public void initialize(int strength) {
            this.initialize(strength, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            ECGenParameterSpec ecParams = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(strength));
            if (ecParams != null) {
                try {
                    this.initialize(ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("Key size " + strength + " bits not available");
            }
        }

        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            ECDomainParameters domainParameters;
            if (params instanceof ECParameterSpec) {
                domainParameters = ECUtil.convertFromSpec((ECParameterSpec)params);
            } else if (params instanceof ECGenParameterSpec) {
                domainParameters = ProvEC.getDomainParametersFromGenSpec((ECGenParameterSpec)params);
                if (domainParameters == null) {
                    throw new InvalidAlgorithmParameterException("unknown curve ID: " + ((ECGenParameterSpec)params).getName());
                }
            } else if (params == null) {
                domainParameters = (ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA);
                if (domainParameters == null) {
                    throw new InvalidAlgorithmParameterException("null AlgorithmParameterSpec passed but no implicit CA set");
                }
                domainParameters = new ECImplicitDomainParameters(domainParameters);
            } else {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            this.engine = this.algorithmType instanceof FipsAlgorithm ? (this.parameters != null ? (this.parameters instanceof FipsEC.DSAParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.DSAParameters)this.parameters, domainParameters), random) : (this.parameters instanceof FipsEC.AgreementParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.AgreementParameters)this.parameters, domainParameters), random) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.MQVAgreementParametersBuilder)this.parameters, domainParameters), random))) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(domainParameters), random)) : (this.parameters != null ? new EC.KeyPairGenerator(new EC.KeyGenParameters((EC.DSAParameters)this.parameters, domainParameters), random) : new EC.KeyPairGenerator(new EC.KeyGenParameters(domainParameters), random));
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, this.fipsProvider.getDefaultSecureRandom());
            }
            AsymmetricKeyPair pair = this.engine.generateKeyPair();
            AsymmetricECPublicKey pubKey = (AsymmetricECPublicKey)pair.getPublicKey();
            AsymmetricECPrivateKey privKey = (AsymmetricECPrivateKey)pair.getPrivateKey();
            return new KeyPair(new ProvECPublicKey(pubKey), new ProvECPrivateKey(privKey));
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }
}

