/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.Agreement;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KDFOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.provider.DESUtil;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvDHPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseAgreement
extends KeyAgreementSpi {
    private static final Map<String, ASN1ObjectIdentifier> defaultOids = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<String, String> nameTable = new HashMap<String, String>();
    private static final KeyIvSizeProvider keySizeProvider = new KeyIvSizeProvider();
    private final AgreementFactory agreementFactory;
    private final PublicKeyConverter publicKeyConverter;
    private final PrivateKeyConverter privateKeyConverter;
    private final ParametersCreator parametersCreator;
    private final KDFOperatorFactory kdfOperatorFactory;
    private final FipsKDF.AgreementKDFParametersBuilder kdfAlgorithm;
    protected Agreement agreement;
    protected byte[] result;
    private Parameters parameters;
    private byte[] userKeyingMaterial;

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator) {
        this(agreementFactory, publicKeyConverter, privateKeyConverter, parametersCreator, null);
    }

    protected BaseAgreement(AgreementFactory agreementFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, ParametersCreator parametersCreator, FipsKDF.AgreementKDFParametersBuilder kdfAlgorithm) {
        this.agreementFactory = agreementFactory;
        this.publicKeyConverter = publicKeyConverter;
        this.privateKeyConverter = privateKeyConverter;
        this.parametersCreator = parametersCreator;
        this.kdfAlgorithm = kdfAlgorithm;
        this.kdfOperatorFactory = new FipsKDF.AgreementOperatorFactory();
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(PublicKey.class) + " for doPhase");
        }
        PublicKey publicKey = (PublicKey)key;
        if (algorithm.equals(FipsDH.ALGORITHM)) {
            Object pubKey = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
            this.result = this.calculateAgreement((AsymmetricPublicKey)pubKey);
            return new ProvDHPublicKey(new AsymmetricDHPublicKey(FipsDH.ALGORITHM, ((AsymmetricDHKey)pubKey).getDomainParameters(), new BigInteger(1, this.result)));
        }
        if (!lastPhase) {
            throw new IllegalStateException(algorithm.getName() + " can only be between two parties.");
        }
        Object pubKey = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
        this.result = this.calculateAgreement((AsymmetricPublicKey)pubKey);
        return null;
    }

    private byte[] calculateAgreement(AsymmetricPublicKey pubKey) throws InvalidKeyException {
        try {
            return this.agreement.calculate(pubKey);
        }
        catch (IllegalKeyException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        if (this.kdfAlgorithm != null) {
            byte[] secret = this.result;
            byte[] keyBytes = new byte[this.result.length];
            FipsKDF.AgreementKDFParameters params = this.kdfAlgorithm.using(secret).withIV(this.userKeyingMaterial);
            KDFCalculator<FipsKDF.AgreementKDFParameters> kdf = this.kdfOperatorFactory.createKDFCalculator(params);
            kdf.generateBytes(keyBytes, 0, keyBytes.length);
            Arrays.fill(secret, (byte)0);
            this.result = keyBytes;
        }
        byte[] rv = this.result;
        this.result = null;
        return rv;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret = this.engineGenerateSecret();
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException(this.parameters.getAlgorithm().getName() + " key agreement: need " + secret.length + " bytes");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws NoSuchAlgorithmException {
        if (this.result == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        byte[] secret = this.result;
        this.result = null;
        String algKey = Strings.toUpperCase(algorithm);
        if (algKey.indexOf(47) < 0) {
            int keySize;
            String oidAlgorithm = algorithm;
            if (defaultOids.containsKey(algKey)) {
                oidAlgorithm = defaultOids.get(algKey).getId();
            }
            if ((keySize = BaseAgreement.getKeySize(oidAlgorithm)) < 0) {
                if (algorithm.equals("TlsPremasterSecret") && this.agreement.getParameters().getAlgorithm().getName().equals("DH")) {
                    return new SecretKeySpec(BaseAgreement.trimZeroes(secret), algorithm);
                }
                return new SecretKeySpec(secret, BaseAgreement.getAlgorithm(oidAlgorithm));
            }
            if (this.kdfAlgorithm != null) {
                byte[] keyBytes = new byte[keySize];
                FipsKDF.AgreementKDFParameters params = this.kdfAlgorithm.using(secret).withIV(this.userKeyingMaterial);
                KDFCalculator<FipsKDF.AgreementKDFParameters> kdf = this.kdfOperatorFactory.createKDFCalculator(params);
                kdf.generateBytes(keyBytes, 0, keyBytes.length);
                Arrays.fill(secret, (byte)0);
                secret = keyBytes;
            } else {
                byte[] key = new byte[keySize];
                System.arraycopy(secret, 0, key, 0, key.length);
                Arrays.fill(secret, (byte)0);
                secret = key;
            }
            if (DESUtil.isDES(oidAlgorithm)) {
                DESUtil.setOddParity(secret);
            }
            return new SecretKeySpec(secret, BaseAgreement.getAlgorithm(oidAlgorithm));
        }
        String macDetails = algKey.substring(0, algKey.indexOf(47));
        String encDetails = algKey.substring(algKey.indexOf(47) + 1);
        int macKeyLength = BaseAgreement.getKeySize(macDetails);
        int encKeyLength = BaseAgreement.getKeySize(encDetails);
        byte[] macKeyBytes = new byte[macKeyLength];
        byte[] encKeyBytes = new byte[encKeyLength];
        if (this.kdfAlgorithm == null) {
            throw new IllegalStateException("KDF is required for key agreement with confirmation");
        }
        byte[] keyBytes = new byte[macKeyLength + encKeyLength];
        FipsKDF.AgreementKDFParameters params = this.kdfAlgorithm.using(secret).withIV(this.userKeyingMaterial);
        KDFCalculator<FipsKDF.AgreementKDFParameters> kdf = this.kdfOperatorFactory.createKDFCalculator(params);
        kdf.generateBytes(keyBytes, 0, keyBytes.length);
        System.arraycopy(keyBytes, 0, macKeyBytes, 0, macKeyLength);
        System.arraycopy(keyBytes, macKeyLength, encKeyBytes, 0, encKeyLength);
        Arrays.fill(secret, (byte)0);
        Arrays.fill(keyBytes, (byte)0);
        return new AgreedKeyWithMacKey(new SecretKeySpec(encKeyBytes, BaseAgreement.getAlgorithm(encDetails)), BaseAgreement.getAlgorithm(macDetails), macKeyBytes);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initFromKey(key, params, random);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initFromKey(key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Issue processing null paramSpec: " + e.getMessage(), e);
        }
    }

    private void initFromKey(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.parameters = this.parametersCreator.createParameters(true, params, random);
        this.userKeyingMaterial = params instanceof MQVParameterSpec ? ((MQVParameterSpec)params).getUserKeyingMaterial() : (params instanceof DHUParameterSpec ? ((DHUParameterSpec)params).getUserKeyingMaterial() : (byte[])(params instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)params).getUserKeyingMaterial() : null));
        Algorithm algorithm = this.parameters.getAlgorithm();
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(algorithm.getName() + " key agreement requires " + BaseAgreement.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        PrivateKey privateKey = (PrivateKey)key;
        Object k = this.privateKeyConverter.convertKey(algorithm, privateKey);
        try {
            this.agreement = this.agreementFactory.createAgreement((AsymmetricPrivateKey)k, this.parameters);
        }
        catch (IllegalKeyException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        catch (FipsUnapprovedOperationError e) {
            throw new InvalidKeyException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private static byte[] trimZeroes(byte[] secret) {
        int ind;
        if (secret[0] != 0) {
            return secret;
        }
        for (ind = 0; ind < secret.length && secret[ind] == 0; ++ind) {
        }
        byte[] rv = new byte[secret.length - ind];
        System.arraycopy(secret, ind, rv, 0, rv.length);
        return rv;
    }

    private static String getSimpleName(Class<?> clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    private static int getKeySize(String algDetails) {
        if (algDetails.indexOf(91) > 0) {
            return (Integer.parseInt(algDetails.substring(algDetails.indexOf(91) + 1, algDetails.indexOf(93))) + 7) / 8;
        }
        return keySizeProvider.getKeySize(algDetails);
    }

    private static String getAlgorithm(String algDetails) {
        if (algDetails.indexOf(91) > 0) {
            return algDetails.substring(0, algDetails.indexOf(91));
        }
        if (algDetails.startsWith(NISTObjectIdentifiers.aes.getId())) {
            return "AES";
        }
        if (algDetails.startsWith(GNUObjectIdentifiers.Serpent.getId())) {
            return "Serpent";
        }
        String name = nameTable.get(algDetails);
        if (name != null) {
            return name;
        }
        return algDetails;
    }

    static {
        defaultOids.put("DESEDE", PKCSObjectIdentifiers.des_EDE3_CBC);
        defaultOids.put("AES", NISTObjectIdentifiers.id_aes256_CBC);
        defaultOids.put("CAMELLIA", NTTObjectIdentifiers.id_camellia256_cbc);
        defaultOids.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        defaultOids.put("DES", OIWObjectIdentifiers.desCBC);
        nameTable.put(MiscObjectIdentifiers.cast5CBC.getId(), "CAST5");
        nameTable.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC.getId(), "IDEA");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB.getId(), "Blowfish");
        nameTable.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB.getId(), "Blowfish");
        nameTable.put(OIWObjectIdentifiers.desECB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCBC.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desCFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desOFB.getId(), "DES");
        nameTable.put(OIWObjectIdentifiers.desEDE.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), "DESede");
        nameTable.put(PKCSObjectIdentifiers.id_alg_CMSRC2wrap.getId(), "RC2");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA1.getId(), "HmacSHA1");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA224.getId(), "HmacSHA224");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA256.getId(), "HmacSHA256");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA384.getId(), "HmacSHA384");
        nameTable.put(PKCSObjectIdentifiers.id_hmacWithSHA512.getId(), "HmacSHA512");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_cbc.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia128_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia192_wrap.getId(), "Camellia");
        nameTable.put(NTTObjectIdentifiers.id_camellia256_wrap.getId(), "Camellia");
        nameTable.put(KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedCBC.getId(), "SEED");
        nameTable.put(KISAObjectIdentifiers.id_seedMAC.getId(), "SEED");
        nameTable.put(CryptoProObjectIdentifiers.gostR28147_gcfb.getId(), "GOST28147");
        nameTable.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
        nameTable.put(NISTObjectIdentifiers.id_aes128_CCM.getId(), "AES");
    }
}

