/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

public final class AES {
    public static final Algorithm ALGORITHM = FipsAES.ALGORITHM;
    public static final Parameters OpenPGPCFB = new Parameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.OpenPGPCFB));
    public static final AuthParameters OCB = new AuthParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.OCB));
    public static final AuthParameters EAX = new AuthParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.EAX));
    public static final WrapParameters RFC3211_WRAP = new WrapParameters(new GeneralAlgorithm(FipsAES.ALGORITHM.getName(), (Enum)Mode.RFC3211_WRAP));

    private AES() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, Algorithm algorithm) {
        ValidatedSymmetricKey sKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = sKey.getKeySizeInBits();
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalKeyException("AES key must be of length 128, 192, or 256");
        }
        Utils.checkKeyAlgorithm(sKey, FipsAES.ALGORITHM, algorithm);
        return sKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardAEADCipher(forEncryption, AES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), (AuthenticationParametersWithIV)parameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm algorithm, byte[] iv, int tagLenInBits) {
            super(algorithm, 16, iv, tagLenInBits);
        }

        AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 128));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, iv, macSizeInBits);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final FipsAES.KeyGenerator keyGen;

        public KeyGenerator(GeneralParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this.algorithm = (GeneralAlgorithm)parameterSet.getAlgorithm();
            this.keyGen = new FipsAES.KeyGenerator(keySizeInBits, random);
        }

        public SymmetricKey doGenerateKey() {
            return new SymmetricSecretKey(this.algorithm, this.keyGen.generateKey().getKeyBytes());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean forWrapping, SymmetricKey key, WrapParameters parameters, SecureRandom random) {
            return CipherUtils.createStandardWrapper(forWrapping, AES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), parameters, random);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardCipher(forEncryption, AES.validateKey(key, parameters.getAlgorithm()), FipsRegister.getProvider(FipsAES.ALGORITHM), (ParametersWithIV)parameters, random);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        private Parameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm, 16, iv);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 16);
        }

        @Override
        Parameters create(GeneralAlgorithm algorithm, byte[] iv) {
            return new Parameters(algorithm, iv);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WrapParameters
    extends GeneralParametersWithIV<WrapParameters> {
        WrapParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        private WrapParameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm, 16, iv);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 16);
        }

        @Override
        WrapParameters create(GeneralAlgorithm algorithm, byte[] iv) {
            return new WrapParameters(algorithm, iv);
        }
    }
}

