/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.DesEdeEngine;
import org.bouncycastle.crypto.fips.DesEdeKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.params.DesEdeParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsTripleDES {
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("TripleDES");
    static final FipsEngineProvider<BlockCipher> ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final WrapParameters TKW;
    public static final AuthParameters CMAC;

    private FipsTripleDES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm algorithm) {
        FipsEngineProvider<Mac> macProvider;
        switch ((Mode)algorithm.basicVariation()) {
            case CMAC: {
                macProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES MAC Provider: " + algorithm);
            }
        }
        return macProvider;
    }

    static Mac makeMAC(AuthParameters authParameters) {
        CMac mac;
        switch ((Mode)authParameters.getAlgorithm().basicVariation()) {
            case CMAC: {
                mac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), authParameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES.OperatorFactory.createMACCalculator: " + authParameters.getAlgorithm());
            }
        }
        return mac;
    }

    private static void validateKeySize(Algorithm algorithm, int keySize) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (keySize != 168 && keySize != 192) {
                throw new IllegalKeyException("Key must be of length 192 bits: " + algorithm.getName());
            }
        } else if (keySize != 112 && keySize != 168 && keySize != 128 && keySize != 192) {
            throw new IllegalKeyException("Key must be of length 128 or 192 bits: " + algorithm.getName());
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, org.bouncycastle.crypto.Parameters parameters, boolean forReading) {
        Algorithm algorithm;
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (!forReading || keyLength != 128) {
            FipsTripleDES.validateKeySize(key.getAlgorithm(), keyLength);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && !forReading && !DesEdeParameters.isReal3Key(vKey.getKeyBytes())) {
                throw new IllegalKeyException("Key not real 3-Key DESEDE key");
            }
        }
        if (!Properties.isOverrideSet("org.bouncycastle.tripledes.allow_weak") && !forReading) {
            if (DesEdeParameters.isActuallyDesKey(vKey.getKeyBytes())) {
                throw new IllegalKeyException("Attempt to use repeated DES key: " + key.getAlgorithm().getName());
            }
            if (DesEdeParameters.isWeakKey(vKey.getKeyBytes(), 0, vKey.getKeyBytes().length)) {
                throw new IllegalKeyException("Attempt to use weak key: " + key.getAlgorithm().getName());
            }
        }
        if (!(algorithm = key.getAlgorithm()).equals(ALGORITHM) && !algorithm.equals(parameters.getAlgorithm())) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return vKey;
    }

    private static void cmacStartUpTest(EngineProvider provider) {
        SelfTestExecutor.validate(ALGORITHM, provider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider provider) throws Exception {
                byte[] input16 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] output_k128_m16 = Hex.decode("c0b9bbee139722ab");
                CMac mac = new CMac(provider.createEngine(), 64);
                KeyParameterImpl key = new KeyParameterImpl(Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619"));
                mac.init(key);
                mac.update(input16, 0, input16.length);
                byte[] out = new byte[8];
                mac.doFinal(out, 0);
                return Arrays.areEqual(out, output_k128_m16);
            }
        });
    }

    static {
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        TKW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        FipsTripleDES.cmacStartUpTest(provider);
        ENGINE_PROVIDER = provider;
        FipsRegister.registerEngineProvider(ALGORITHM, provider);
    }

    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 64));
        }

        private AuthParameters(FipsAlgorithm algorithm, byte[] iv, int macLenInBits) {
            super(algorithm);
            this.iv = iv;
            this.macLenInBits = macLenInBits;
        }

        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public AuthParameters withIV(byte[] iv) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(iv), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom random) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(8, random), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom random, int ivLen) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(ivLen, random), this.macLenInBits);
        }

        public AuthParameters withMACSize(int macSizeInBits) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), macSizeInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    extends FipsEngineProvider<BlockCipher> {
        private static byte[] input = Hex.decode("4e6f772069732074");
        private static byte[] output = Hex.decode("f7cfbe5e6c38b35a");
        private static final byte[] keyBytes = Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619");

        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new DesEdeEngine(), new VariantKatTest<DesEdeEngine>(){

                @Override
                public void evaluate(DesEdeEngine tripleDesEngine) {
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(keyBytes);
                    tripleDesEngine.init(true, key);
                    tripleDesEngine.processBlock(input, 0, tmp, 0);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    tripleDesEngine.init(false, key);
                    tripleDesEngine.processBlock(tmp, 0, tmp, 0);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int keySizeInBits, SecureRandom random) {
            this(ALGORITHM, keySizeInBits, random);
        }

        public KeyGenerator(FipsParameters parameterSet, int keySizeInBits, SecureRandom random) {
            this(parameterSet.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(FipsAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(random, 112, algorithm);
                if (keySizeInBits != 168 && keySizeInBits != 192) {
                    throw new IllegalArgumentException("Attempt to create key with unapproved key size [" + keySizeInBits + "]: " + algorithm.getName());
                }
            } else if (keySizeInBits != 112 && keySizeInBits != 168 && keySizeInBits != 128 && keySizeInBits != 192) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + keySizeInBits + "]: " + algorithm.getName());
            }
            this.algorithm = algorithm;
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        public SymmetricKey generateKey() {
            DesEdeKeyGenerator cipherKeyGenerator = new DesEdeKeyGenerator(this.algorithm);
            ((CipherKeyGenerator)cipherKeyGenerator).init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, ((CipherKeyGenerator)cipherKeyGenerator).generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm algorithm, boolean useInverse) {
            SP80038FWrapEngine cipher;
            switch ((Mode)algorithm.basicVariation()) {
                case WRAP: {
                    cipher = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), useInverse);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsDESEDE.KeyWrapOperatorFactory: " + algorithm.getName());
                }
            }
            return cipher;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(true, new KeyParameterImpl(sKey.getKeyBytes()));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] wrap(byte[] in, int inOff, int inLen) throws PlainInputProcessingException {
                    try {
                        return wrapper.wrap(in, inOff, inLen);
                    }
                    catch (Exception e) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + e.getMessage(), e);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey key, final WrapParameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final Wrapper wrapper = this.createWrapper(parameters.getAlgorithm(), parameters.useInverse);
            wrapper.init(false, new KeyParameterImpl(sKey.getKeyBytes()));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(in, inOff, inLen);
                    }
                    catch (InvalidCipherTextException e) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return FipsTripleDES.makeMAC(parameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            Mac mac = FipsTripleDES.makeMAC(parameters);
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            if (parameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(sKey, parameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(sKey));
            }
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey key, Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, false);
            return new OutEncryptor(sKey, parameters, null);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, null);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int inputLen) {
                    return cipher.getOutputSize(inputLen);
                }

                @Override
                public int getUpdateOutputSize(int inputLen) {
                    return cipher.getUpdateOutputSize(inputLen);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream out) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherOutputStreamImpl(out, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return new CipherOutputStreamImpl(out, cipher);
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey key, final Parameters parameters) {
            ValidatedSymmetricKey sKey = FipsTripleDES.validateKey(key, parameters, true);
            final BufferedBlockCipher cipher = BlockCipherUtils.createStandardCipher(false, sKey, ENGINE_PROVIDER, parameters, null);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream in) {
                    if (cipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(in, (StreamCipher)((Object)cipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(in, cipher);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey key, Parameters parameters, SecureRandom random) {
                this.key = key;
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createStandardCipher(true, key, ENGINE_PROVIDER, parameters, random);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream out) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return new CipherOutputStreamImpl(out, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return new CipherOutputStreamImpl(out, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom random) {
                return new OutEncryptor(this.key, this.parameters, random);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return this.cipher.getOutputSize(inputLen);
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return this.cipher.getUpdateOutputSize(inputLen);
            }
        }
    }

    public static final class Parameters
    extends FipsParameters
    implements ParametersWithIV {
        private final byte[] iv;

        Parameters(FipsAlgorithm algorithm) {
            this(algorithm, null);
        }

        private Parameters(FipsAlgorithm algorithm, byte[] iv) {
            super(algorithm);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 8);
            this.iv = iv;
        }

        public Parameters withIV(byte[] iv) {
            return new Parameters(this.getAlgorithm(), Arrays.clone(iv));
        }

        public Parameters withIV(SecureRandom random) {
            return new Parameters(this.getAlgorithm(), ((Mode)this.getAlgorithm().basicVariation()).createDefaultIvIfNecessary(8, random));
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm algorithm) {
            this(algorithm, false);
        }

        private WrapParameters(FipsAlgorithm algorithm, boolean useInverse) {
            super(algorithm);
            this.useInverse = useInverse;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean useInverse) {
            return new WrapParameters(this.getAlgorithm(), useInverse);
        }
    }
}

