/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PublicKey;
import org.bouncycastle.jcajce.provider.DSTU4145Util;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.DSTU4145PublicKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSTU4145PublicKey
implements DSTU4145PublicKey,
ProvKey<AsymmetricDSTU4145PublicKey> {
    private static final long serialVersionUID = 7026240464295649314L;
    private transient AsymmetricDSTU4145PublicKey baseKey;

    ProvDSTU4145PublicKey(Algorithm algorithm, DSTU4145PublicKey key) {
        DSTU4145ParameterSpec params = key.getParams();
        this.baseKey = new AsymmetricDSTU4145PublicKey(algorithm, DSTU4145Util.convertToECParams(params), ECUtil.convertPoint(params, key.getW()));
    }

    ProvDSTU4145PublicKey(Algorithm algorithm, DSTU4145PublicKeySpec keySpec) {
        DSTU4145ParameterSpec params = keySpec.getParams();
        this.baseKey = new AsymmetricDSTU4145PublicKey(algorithm, DSTU4145Util.convertToECParams(params), ECUtil.convertPoint(params, keySpec.getW()));
    }

    ProvDSTU4145PublicKey(AsymmetricDSTU4145PublicKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricDSTU4145PublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public DSTU4145ParameterSpec getParams() {
        return DSTU4145Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("DSTU4145", this.baseKey.getW().normalize(), this.baseKey.getParameters().getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvDSTU4145PublicKey)) {
            return false;
        }
        ProvDSTU4145PublicKey other = (ProvDSTU4145PublicKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDSTU4145PublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

