/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.DerUtil;

public class DEROtherInfo {
    private final ASN1Sequence sequence;

    private DEROtherInfo(DERSequence sequence) {
        this.sequence = sequence;
    }

    public DEROtherInfo(byte[] encoding) {
        this.sequence = ASN1Sequence.getInstance(encoding);
    }

    public byte[] getEncoded() throws IOException {
        return this.sequence.getEncoded("DER");
    }

    public static final class Builder {
        private final AlgorithmIdentifier algorithmID;
        private final ASN1OctetString partyUVInfo;
        private final ASN1OctetString partyVInfo;
        private ASN1TaggedObject suppPubInfo;
        private ASN1TaggedObject suppPrivInfo;

        public Builder(DEROtherInfo otherInfo) {
            ASN1Sequence seq = otherInfo.sequence;
            this.algorithmID = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
            this.partyUVInfo = ASN1OctetString.getInstance(seq.getObjectAt(1));
            this.partyVInfo = ASN1OctetString.getInstance(seq.getObjectAt(2));
            if (seq.size() == 5) {
                this.suppPubInfo = ASN1TaggedObject.getInstance(seq.getObjectAt(3));
                this.suppPrivInfo = ASN1TaggedObject.getInstance(seq.getObjectAt(4));
            } else if (seq.size() == 4) {
                ASN1TaggedObject suppInfo = ASN1TaggedObject.getInstance(seq.getObjectAt(3));
                if (suppInfo.getTagNo() == 0) {
                    this.suppPubInfo = suppInfo;
                } else {
                    this.suppPrivInfo = suppInfo;
                }
            }
        }

        public Builder(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo) {
            this.algorithmID = algorithmID;
            this.partyUVInfo = DerUtil.getOctetString(partyUInfo);
            this.partyVInfo = DerUtil.getOctetString(partyVInfo);
        }

        public Builder withSuppPubInfo(byte[] suppPubInfo) {
            this.suppPubInfo = new DERTaggedObject(false, 0, DerUtil.getOctetString(suppPubInfo));
            return this;
        }

        public Builder withSuppPrivInfo(byte[] suppPrivInfo) {
            this.suppPrivInfo = new DERTaggedObject(false, 1, DerUtil.getOctetString(suppPrivInfo));
            return this;
        }

        public DEROtherInfo build() {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.algorithmID);
            v.add(this.partyUVInfo);
            v.add(this.partyVInfo);
            if (this.suppPubInfo != null) {
                v.add(this.suppPubInfo);
            }
            if (this.suppPrivInfo != null) {
                v.add(this.suppPrivInfo);
            }
            return new DEROtherInfo(new DERSequence(v));
        }
    }
}

