/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.general.Salsa20Engine;
import org.bouncycastle.util.Pack;

class ChaCha7539Engine
extends Salsa20Engine {
    public String getAlgorithmName() {
        return "ChaCha7539-" + this.rounds;
    }

    protected int getNonceSize() {
        return 12;
    }

    protected void advanceCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi > 0) {
            throw new IllegalStateException("attempt to increase counter past 2^32.");
        }
        int oldState = this.engineState[12];
        this.engineState[12] = this.engineState[12] + lo;
        if (oldState != 0 && this.engineState[12] < oldState) {
            throw new IllegalStateException("attempt to increase counter past 2^32.");
        }
    }

    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        if (this.engineState[12] == 0) {
            throw new IllegalStateException("attempt to increase counter past 2^32.");
        }
    }

    protected void retreatCounter(long diff) {
        int hi = (int)(diff >>> 32);
        int lo = (int)diff;
        if (hi != 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) < ((long)lo & 0xFFFFFFFFL)) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - lo;
    }

    protected void retreatCounter() {
        if (this.engineState[12] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - 1;
    }

    protected long getCounter() {
        return (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    protected void resetCounter() {
        this.engineState[12] = 0;
    }

    protected void setKey(byte[] keyBytes, byte[] ivBytes) {
        if (keyBytes != null) {
            if (keyBytes.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 256 bit key");
            }
            this.packTauOrSigma(keyBytes.length, this.engineState, 0);
            Pack.littleEndianToInt(keyBytes, 0, this.engineState, 4, 8);
        }
        Pack.littleEndianToInt(ivBytes, 0, this.engineState, 13, 3);
    }

    protected void generateKeyStream(byte[] output) {
        ChaCha7539Engine.chachaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, output, 0);
    }

    private static void chachaCore(int rounds, int[] input, int[] x) {
        if (input.length != 16) {
            throw new IllegalArgumentException();
        }
        if (x.length != 16) {
            throw new IllegalArgumentException();
        }
        if (rounds % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int x00 = input[0];
        int x01 = input[1];
        int x02 = input[2];
        int x03 = input[3];
        int x04 = input[4];
        int x05 = input[5];
        int x06 = input[6];
        int x07 = input[7];
        int x08 = input[8];
        int x09 = input[9];
        int x10 = input[10];
        int x11 = input[11];
        int x12 = input[12];
        int x13 = input[13];
        int x14 = input[14];
        int x15 = input[15];
        for (int i = rounds; i > 0; i -= 2) {
            x12 = ChaCha7539Engine.rotl(x12 ^ (x00 += x04), 16);
            x04 = ChaCha7539Engine.rotl(x04 ^ (x08 += x12), 12);
            x12 = ChaCha7539Engine.rotl(x12 ^ (x00 += x04), 8);
            x04 = ChaCha7539Engine.rotl(x04 ^ (x08 += x12), 7);
            x13 = ChaCha7539Engine.rotl(x13 ^ (x01 += x05), 16);
            x05 = ChaCha7539Engine.rotl(x05 ^ (x09 += x13), 12);
            x13 = ChaCha7539Engine.rotl(x13 ^ (x01 += x05), 8);
            x05 = ChaCha7539Engine.rotl(x05 ^ (x09 += x13), 7);
            x14 = ChaCha7539Engine.rotl(x14 ^ (x02 += x06), 16);
            x06 = ChaCha7539Engine.rotl(x06 ^ (x10 += x14), 12);
            x14 = ChaCha7539Engine.rotl(x14 ^ (x02 += x06), 8);
            x06 = ChaCha7539Engine.rotl(x06 ^ (x10 += x14), 7);
            x15 = ChaCha7539Engine.rotl(x15 ^ (x03 += x07), 16);
            x07 = ChaCha7539Engine.rotl(x07 ^ (x11 += x15), 12);
            x15 = ChaCha7539Engine.rotl(x15 ^ (x03 += x07), 8);
            x07 = ChaCha7539Engine.rotl(x07 ^ (x11 += x15), 7);
            x15 = ChaCha7539Engine.rotl(x15 ^ (x00 += x05), 16);
            x05 = ChaCha7539Engine.rotl(x05 ^ (x10 += x15), 12);
            x15 = ChaCha7539Engine.rotl(x15 ^ (x00 += x05), 8);
            x05 = ChaCha7539Engine.rotl(x05 ^ (x10 += x15), 7);
            x12 = ChaCha7539Engine.rotl(x12 ^ (x01 += x06), 16);
            x06 = ChaCha7539Engine.rotl(x06 ^ (x11 += x12), 12);
            x12 = ChaCha7539Engine.rotl(x12 ^ (x01 += x06), 8);
            x06 = ChaCha7539Engine.rotl(x06 ^ (x11 += x12), 7);
            x13 = ChaCha7539Engine.rotl(x13 ^ (x02 += x07), 16);
            x07 = ChaCha7539Engine.rotl(x07 ^ (x08 += x13), 12);
            x13 = ChaCha7539Engine.rotl(x13 ^ (x02 += x07), 8);
            x07 = ChaCha7539Engine.rotl(x07 ^ (x08 += x13), 7);
            x14 = ChaCha7539Engine.rotl(x14 ^ (x03 += x04), 16);
            x04 = ChaCha7539Engine.rotl(x04 ^ (x09 += x14), 12);
            x14 = ChaCha7539Engine.rotl(x14 ^ (x03 += x04), 8);
            x04 = ChaCha7539Engine.rotl(x04 ^ (x09 += x14), 7);
        }
        x[0] = x00 + input[0];
        x[1] = x01 + input[1];
        x[2] = x02 + input[2];
        x[3] = x03 + input[3];
        x[4] = x04 + input[4];
        x[5] = x05 + input[5];
        x[6] = x06 + input[6];
        x[7] = x07 + input[7];
        x[8] = x08 + input[8];
        x[9] = x09 + input[9];
        x[10] = x10 + input[10];
        x[11] = x11 + input[11];
        x[12] = x12 + input[12];
        x[13] = x13 + input[13];
        x[14] = x14 + input[14];
        x[15] = x15 + input[15];
    }
}

