/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

public final class AsymmetricEdDSAPrivateKey
extends AsymmetricEdDSAKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private boolean hasPublicKey;
    private byte[] publicData;
    private ASN1Set attributes;
    private int hashCode;

    public AsymmetricEdDSAPrivateKey(Algorithm algorithm, byte[] keyData, byte[] publicData) {
        super(algorithm);
        this.keyData = Arrays.clone(keyData);
        this.hashCode = this.calculateHashCode();
        this.attributes = null;
        if (publicData == null) {
            this.hasPublicKey = false;
            this.publicData = EdEC.computePublicData(algorithm, keyData);
        } else {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(publicData);
        }
    }

    public AsymmetricEdDSAPrivateKey(byte[] encoding) throws IOException {
        this(PrivateKeyInfo.getInstance(encoding));
    }

    public AsymmetricEdDSAPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        super(EdECObjectIdentifiers.id_Ed448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519);
        ASN1Encodable keyOcts = keyInfo.parsePrivateKey();
        this.keyData = Arrays.clone(ASN1OctetString.getInstance(keyOcts).getOctets());
        if (keyInfo.hasPublicKey()) {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(keyInfo.getPublicKeyData().getOctets());
        }
        if (EdECObjectIdentifiers.id_Ed448.equals(keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? this.keyData.length != 57 : this.keyData.length != 32) {
            throw new IllegalArgumentException("raw key data incorrect size");
        }
        this.attributes = keyInfo.getAttributes();
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.keyData);
    }

    public byte[] getPublicData() {
        KeyUtils.checkDestroyed(this);
        return Arrays.clone(this.publicData);
    }

    public byte[] getEncoded() {
        byte[] pubData;
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        byte[] byArray = pubData = this.hasPublicKey ? this.publicData : null;
        if (this.getAlgorithm().equals(EdEC.Algorithm.Ed448)) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), new DEROctetString(this.keyData), this.attributes, pubData);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(this.keyData), this.attributes, pubData);
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.hasPublicKey = false;
            this.attributes = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricEdDSAPrivateKey)) {
            return false;
        }
        AsymmetricEdDSAPrivateKey other = (AsymmetricEdDSAPrivateKey)o;
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        if (!Arrays.areEqual(this.keyData, other.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(other.getAlgorithm());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyData);
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

