/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImageZoomPanel
extends JScrollPane {
    protected BufferedImage img;
    ImagePanel panel = new ImagePanel();
    double scale = 1.0;

    public ImageZoomPanel(BufferedImage img) {
        this.img = img;
        this.setScale(1.0);
    }

    public ImageZoomPanel() {
        this.getViewport().setView(this.panel);
    }

    public void setScale(double scale) {
        Rectangle r = this.panel.getVisibleRect();
        double centerX = ((double)r.x + (double)r.width / 2.0) / this.scale;
        double centerY = ((double)r.y + (double)r.height / 2.0) / this.scale;
        this.scale = scale;
        int w = 0;
        int h = 0;
        if (this.img != null) {
            w = (int)Math.ceil((double)this.img.getWidth() * scale);
            h = (int)Math.ceil((double)this.img.getHeight() * scale);
        }
        this.panel.setPreferredSize(new Dimension(w, h));
        this.getViewport().setView(this.panel);
        this.centerView(centerX, centerY);
    }

    public void centerView(double cx, double cy) {
        Rectangle r = this.panel.getVisibleRect();
        int x = (int)(cx * this.scale - (double)(r.width / 2));
        int y = (int)(cy * this.scale - (double)(r.height / 2));
        this.getHorizontalScrollBar().setValue(x);
        this.getVerticalScrollBar().setValue(y);
    }

    public void setBufferedImage(BufferedImage image) {
        this.img = image;
        Dimension prev = this.getPreferredSize();
        int w = 0;
        int h = 0;
        if (this.img != null) {
            w = (int)Math.ceil((double)this.img.getWidth() * this.scale);
            h = (int)Math.ceil((double)this.img.getHeight() * this.scale);
        }
        if (prev.getWidth() != (double)w || prev.getHeight() != (double)h) {
            this.panel.setPreferredSize(new Dimension(w, h));
            this.getViewport().setView(this.panel);
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ImageZoomPanel.this.img == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tran = AffineTransform.getScaleInstance(ImageZoomPanel.this.scale, ImageZoomPanel.this.scale);
            g2.drawImage(ImageZoomPanel.this.img, tran, null);
        }
    }
}

