/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.image.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDisplayPanel
extends JPanel
implements ListSelectionListener {
    List<JPanel> panels = new ArrayList<JPanel>();
    private JPanel bodyPanel;
    private JList listPanel;
    DefaultListModel listModel = new DefaultListModel();
    JScrollPane scroll;

    public ListDisplayPanel() {
        this.setLayout(new BorderLayout());
        this.listPanel = new JList(this.listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.listPanel);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.scroll, "West");
        this.add(this.bodyPanel);
    }

    public void reset() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panels.clear();
            this.listModel.removeAllElements();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ListDisplayPanel.this.panels.clear();
                        ListDisplayPanel.this.listModel.removeAllElements();
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public int getListWidth() {
        return (int)this.listPanel.getPreferredSize().getWidth();
    }

    public void addImage(BufferedImage image, String name) {
        this.addItem(new ImagePanel(image, true), name);
    }

    public void addItem(final JPanel panel, final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListDisplayPanel.this.panels.add(panel);
                ListDisplayPanel.this.listModel.addElement(name);
                if (ListDisplayPanel.this.listModel.size() == 1) {
                    ListDisplayPanel.this.listPanel.setSelectedIndex(0);
                }
                Dimension d = ListDisplayPanel.this.listPanel.getMinimumSize();
                ListDisplayPanel.this.listPanel.setPreferredSize(new Dimension(d.width + ListDisplayPanel.this.scroll.getVerticalScrollBar().getWidth(), d.height));
                ListDisplayPanel.this.validate();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.listPanel.getSelectedIndex();
        if (index >= 0) {
            this.removeCenterBody();
            this.bodyPanel.add((Component)this.panels.get(index), "Center");
            this.bodyPanel.validate();
            this.bodyPanel.repaint();
        }
    }

    private void removeCenterBody() {
        Component old = ((BorderLayout)this.bodyPanel.getLayout()).getLayoutComponent("Center");
        if (old != null) {
            this.bodyPanel.remove(old);
        }
    }
}

