/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class TldVarianceFilter<T extends ImageSingleBand> {
    private double thresholdLower;
    private ImageSingleBand integral;
    private ImageSingleBand integralSq;

    public TldVarianceFilter(Class<T> imageType) {
        if (GeneralizedImageOps.isFloatingPoint(imageType)) {
            this.integral = new ImageFloat32(1, 1);
            this.integralSq = new ImageFloat64(1, 1);
        } else {
            this.integral = new ImageSInt32(1, 1);
            this.integralSq = new ImageSInt64(1, 1);
        }
    }

    protected TldVarianceFilter() {
    }

    public void setImage(T gray) {
        this.integral.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        this.integralSq.reshape(((ImageSingleBand)gray).width, ((ImageSingleBand)gray).height);
        GIntegralImageOps.transform(gray, (ImageSingleBand)this.integral);
        if (gray.getTypeInfo().isInteger()) {
            TldVarianceFilter.transformSq((ImageUInt8)gray, (ImageSInt64)this.integralSq);
        } else {
            TldVarianceFilter.transformSq((ImageFloat32)gray, (ImageFloat64)this.integralSq);
        }
    }

    public void selectThreshold(ImageRectangle r) {
        double variance = this.computeVarianceSafe(r.x0, r.y0, r.x1, r.y1);
        this.thresholdLower = variance * 0.5;
    }

    public boolean checkVariance(ImageRectangle r) {
        double sigma2 = this.computeVariance(r.x0, r.y0, r.x1, r.y1);
        return sigma2 >= this.thresholdLower;
    }

    protected double computeVariance(int x0, int y0, int x1, int y1) {
        double square = GIntegralImageOps.block_unsafe((ImageSingleBand)this.integralSq, (int)(x0 - 1), (int)(y0 - 1), (int)(x1 - 1), (int)(y1 - 1));
        double area = (x1 - x0) * (y1 - y0);
        double mean = GIntegralImageOps.block_unsafe((ImageSingleBand)this.integral, (int)(x0 - 1), (int)(y0 - 1), (int)(x1 - 1), (int)(y1 - 1)) / area;
        return square / area - mean * mean;
    }

    protected double computeVarianceSafe(int x0, int y0, int x1, int y1) {
        double square = GIntegralImageOps.block_zero((ImageSingleBand)this.integralSq, (int)(x0 - 1), (int)(y0 - 1), (int)(x1 - 1), (int)(y1 - 1));
        double area = (x1 - x0) * (y1 - y0);
        double mean = GIntegralImageOps.block_zero((ImageSingleBand)this.integral, (int)(x0 - 1), (int)(y0 - 1), (int)(x1 - 1), (int)(y1 - 1)) / area;
        return square / area - mean * mean;
    }

    public static void transformSq(ImageUInt8 input, ImageSInt64 transformed) {
        int indexSrc;
        int indexDst = transformed.startIndex;
        int end = indexSrc + input.width;
        long total = 0L;
        for (indexSrc = input.startIndex; indexSrc < end; ++indexSrc) {
            int value = input.data[indexSrc] & 0xFF;
            transformed.data[indexDst++] = total += (long)(value * value);
        }
        for (int y = 1; y < input.height; ++y) {
            indexDst = transformed.startIndex + transformed.stride * y;
            int indexPrev = indexDst - transformed.stride;
            end = indexSrc + input.width;
            total = 0L;
            for (indexSrc = input.startIndex + input.stride * y; indexSrc < end; ++indexSrc) {
                int value = input.data[indexSrc] & 0xFF;
                transformed.data[indexDst++] = transformed.data[indexPrev++] + (total += (long)(value * value));
            }
        }
    }

    public static void transformSq(ImageFloat32 input, ImageFloat64 transformed) {
        int indexSrc;
        int indexDst = transformed.startIndex;
        int end = indexSrc + input.width;
        double total = 0.0;
        for (indexSrc = input.startIndex; indexSrc < end; ++indexSrc) {
            float value = input.data[indexSrc];
            transformed.data[indexDst++] = total += (double)(value * value);
        }
        for (int y = 1; y < input.height; ++y) {
            indexDst = transformed.startIndex + transformed.stride * y;
            int indexPrev = indexDst - transformed.stride;
            end = indexSrc + input.width;
            total = 0.0;
            for (indexSrc = input.startIndex + input.stride * y; indexSrc < end; ++indexSrc) {
                float value = input.data[indexSrc];
                transformed.data[indexDst++] = transformed.data[indexPrev++] + (total += (double)(value * value));
            }
        }
    }

    public double getThresholdLower() {
        return this.thresholdLower;
    }
}

