/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.alg.tracker.tld.TldAdjustRegion;
import boofcv.alg.tracker.tld.TldDetection;
import boofcv.alg.tracker.tld.TldFernClassifier;
import boofcv.alg.tracker.tld.TldHelperFunctions;
import boofcv.alg.tracker.tld.TldLearning;
import boofcv.alg.tracker.tld.TldParameters;
import boofcv.alg.tracker.tld.TldRegion;
import boofcv.alg.tracker.tld.TldRegionTracker;
import boofcv.alg.tracker.tld.TldTemplateMatching;
import boofcv.alg.tracker.tld.TldVarianceFilter;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.shapes.RectangleCorner2D_F64;
import georegression.struct.shapes.RectangleCorner2D_I32;
import java.util.Random;
import org.ddogleg.struct.FastQueue;

public class TldTracker<T extends ImageSingleBand, D extends ImageSingleBand> {
    private TldParameters config;
    private RectangleCorner2D_F64 targetRegion = new RectangleCorner2D_F64();
    private RectangleCorner2D_F64 trackerRegion = new RectangleCorner2D_F64();
    private ImageRectangle trackerRegion_I32 = new ImageRectangle();
    private FastQueue<ImageRectangle> cascadeRegions = new FastQueue(ImageRectangle.class, true);
    private PyramidDiscrete<T> imagePyramid;
    private TldRegionTracker<T, D> tracking;
    private TldAdjustRegion adjustRegion;
    private TldVarianceFilter<T> variance;
    private TldFernClassifier<T> fern;
    private TldTemplateMatching<T> template;
    private TldDetection<T> detection;
    private boolean reacquiring;
    private boolean valid;
    private boolean strongMatch;
    private double previousTrackArea;
    private TldLearning<T> learning;
    private boolean performLearning = true;

    public TldTracker(TldParameters config, InterpolatePixelS<T> interpolate, ImageGradient<T, D> gradient, Class<T> imageType, Class<D> derivType) {
        this.config = config;
        Random rand = new Random(config.randomSeed);
        PyramidKltTracker tracker = FactoryTrackerAlg.kltPyramid((KltConfig)config.trackerConfig, imageType, derivType);
        this.tracking = new TldRegionTracker<T, D>(config.trackerGridWidth, config.trackerFeatureRadius, config.maximumErrorFB, gradient, tracker, imageType, derivType);
        this.adjustRegion = new TldAdjustRegion(config.motionIterations);
        this.variance = new TldVarianceFilter<T>(imageType);
        this.template = new TldTemplateMatching<T>(interpolate);
        this.fern = new TldFernClassifier<T>(rand, config.numFerns, config.fernSize, 20, 0.5f, interpolate);
        this.detection = new TldDetection<T>(this.fern, this.template, this.variance, config);
        this.learning = new TldLearning<T>(rand, config, this.template, this.variance, this.fern, this.detection);
    }

    public void initialize(T image, int x0, int y0, int x1, int y1) {
        if (this.imagePyramid == null || this.imagePyramid.getInputWidth() != ((ImageSingleBand)image).width || this.imagePyramid.getInputHeight() != ((ImageSingleBand)image).height) {
            int minSize = (this.config.trackerFeatureRadius * 2 + 1) * 5;
            int[] scales = TldTracker.selectPyramidScale(((ImageSingleBand)image).width, ((ImageSingleBand)image).height, minSize);
            this.imagePyramid = FactoryPyramid.discreteGaussian((int[])scales, (double)-1.0, (int)1, (boolean)true, image.getClass());
        }
        this.imagePyramid.process(image);
        this.reacquiring = false;
        this.targetRegion.set((double)x0, (double)y0, (double)x1, (double)y1);
        this.createCascadeRegion(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        this.template.reset();
        this.fern.reset();
        this.tracking.initialize(this.imagePyramid);
        this.variance.setImage(image);
        this.template.setImage(image);
        this.fern.setImage(image);
        this.adjustRegion.init(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        this.learning.initialLearning(this.targetRegion, this.cascadeRegions);
        this.strongMatch = true;
        this.previousTrackArea = this.targetRegion.area();
    }

    private void createCascadeRegion(int imageWidth, int imageHeight) {
        this.cascadeRegions.reset();
        int rectWidth = (int)(this.targetRegion.getWidth() + 0.5);
        int rectHeight = (int)(this.targetRegion.getHeight() + 0.5);
        for (int scaleInt = -this.config.scaleSpread; scaleInt <= this.config.scaleSpread; ++scaleInt) {
            double scale = Math.pow(1.2, scaleInt);
            int actualWidth = (int)((double)rectWidth * scale);
            int actualHeight = (int)((double)rectHeight * scale);
            if (actualWidth < this.config.detectMinimumSide || actualHeight < this.config.detectMinimumSide || actualWidth >= imageWidth || actualHeight >= imageHeight) continue;
            int stepWidth = (int)((double)rectWidth * scale * 0.1);
            int stepHeight = (int)((double)rectHeight * scale * 0.1);
            if (stepWidth < 1) {
                stepWidth = 1;
            }
            if (stepHeight < 1) {
                stepHeight = 1;
            }
            int maxX = imageWidth - actualWidth;
            int maxY = imageHeight - actualHeight;
            for (int y0 = 1; y0 < maxY; y0 += stepHeight) {
                for (int x0 = 1; x0 < maxX; x0 += stepWidth) {
                    ImageRectangle r = (ImageRectangle)this.cascadeRegions.grow();
                    r.x0 = x0;
                    r.y0 = y0;
                    r.x1 = x0 + actualWidth;
                    r.y1 = y0 + actualHeight;
                }
            }
        }
    }

    public boolean track(T image) {
        boolean success = true;
        this.valid = false;
        this.imagePyramid.process(image);
        this.template.setImage(image);
        this.variance.setImage(image);
        this.fern.setImage(image);
        if (this.reacquiring) {
            this.detection.detectionCascade(this.cascadeRegions);
            if (this.detection.isSuccess() && !this.detection.isAmbiguous()) {
                TldRegion region = this.detection.getBest();
                this.reacquiring = false;
                this.valid = false;
                ImageRectangle r = region.rect;
                this.targetRegion.set((double)r.x0, (double)r.y0, (double)r.x1, (double)r.y1);
                this.tracking.initialize(this.imagePyramid);
                this.checkNewTrackStrong(region.confidence);
            } else {
                success = false;
            }
        } else {
            this.detection.detectionCascade(this.cascadeRegions);
            this.trackerRegion.set(this.targetRegion);
            boolean trackingWorked = this.tracking.process((ImagePyramid<T>)this.imagePyramid, this.trackerRegion);
            TldHelperFunctions.convertRegion(this.trackerRegion, (RectangleCorner2D_I32)this.trackerRegion_I32);
            if (this.hypothesisFusion(trackingWorked &= this.adjustRegion.process(this.tracking.getPairs(), this.trackerRegion), this.detection.isSuccess())) {
                if (this.valid && this.performLearning) {
                    this.learning.updateLearning(this.targetRegion);
                }
            } else {
                this.reacquiring = true;
                success = false;
            }
        }
        if (this.strongMatch) {
            this.previousTrackArea = this.targetRegion.area();
        }
        return success;
    }

    private void checkNewTrackStrong(double confidence) {
        boolean bl = this.strongMatch = confidence > this.config.confidenceThresholdStrong;
        if (!this.strongMatch) {
            double similarity = Math.abs((this.targetRegion.area() - this.previousTrackArea) / this.previousTrackArea);
            this.strongMatch = similarity <= this.config.thresholdSimilarArea;
        }
    }

    protected boolean hypothesisFusion(boolean trackingWorked, boolean detectionWorked) {
        double confidenceTarget;
        this.valid = false;
        boolean uniqueDetection = detectionWorked && !this.detection.isAmbiguous();
        TldRegion detectedRegion = this.detection.getBest();
        if (trackingWorked) {
            double adjustment;
            double scoreTrack = this.template.computeConfidence(this.trackerRegion_I32);
            double scoreDetected = 0.0;
            if (uniqueDetection) {
                scoreDetected = detectedRegion.confidence;
            }
            double d = adjustment = this.strongMatch ? 0.07 : 0.02;
            if (uniqueDetection && scoreDetected > scoreTrack + adjustment) {
                TldHelperFunctions.convertRegion((RectangleCorner2D_I32)detectedRegion.rect, this.targetRegion);
                confidenceTarget = detectedRegion.confidence;
                this.checkNewTrackStrong(scoreDetected);
            } else {
                this.targetRegion.set(this.trackerRegion);
                confidenceTarget = scoreTrack;
                this.strongMatch |= confidenceTarget > this.config.confidenceThresholdStrong;
                if (this.strongMatch && confidenceTarget >= this.config.confidenceThresholdLower) {
                    this.valid = true;
                }
            }
        } else if (uniqueDetection) {
            detectedRegion = this.detection.getBest();
            TldHelperFunctions.convertRegion((RectangleCorner2D_I32)detectedRegion.rect, this.targetRegion);
            confidenceTarget = detectedRegion.confidence;
            this.strongMatch = confidenceTarget > this.config.confidenceThresholdStrong;
        } else {
            return false;
        }
        return confidenceTarget >= this.config.confidenceAccept;
    }

    public static int[] selectPyramidScale(int imageWidth, int imageHeight, int minSize) {
        int w = Math.max(imageWidth, imageHeight);
        int maxScale = w / minSize;
        int n = 1;
        int scale = 1;
        while (scale * 2 < maxScale) {
            ++n;
            scale *= 2;
        }
        int[] ret = new int[n];
        scale = 1;
        for (int i = 0; i < n; ++i) {
            ret[i] = scale;
            scale *= 2;
        }
        return ret;
    }

    public boolean isPerformLearning() {
        return this.performLearning;
    }

    public void setPerformLearning(boolean performLearning) {
        this.performLearning = performLearning;
    }

    public TldTemplateMatching<T> getTemplateMatching() {
        return this.template;
    }

    public RectangleCorner2D_F64 getTargetRegion() {
        return this.targetRegion;
    }

    public RectangleCorner2D_F64 getTrackerRegion() {
        return this.trackerRegion;
    }

    public TldParameters getConfig() {
        return this.config;
    }

    public TldDetection<T> getDetection() {
        return this.detection;
    }
}

