/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.tracker.tld.TldHelperFunctions;
import boofcv.alg.tracker.tld.TldRegion;
import georegression.struct.shapes.RectangleCorner2D_I32;
import org.ddogleg.struct.FastQueue;

public class TldNonMaximalSuppression {
    private double connectionThreshold;
    private FastQueue<Connections> conn = new FastQueue(Connections.class, true);
    private TldHelperFunctions helper = new TldHelperFunctions();

    public TldNonMaximalSuppression(double connectionThreshold) {
        this.connectionThreshold = connectionThreshold;
    }

    public void process(FastQueue<TldRegion> regions, FastQueue<TldRegion> output) {
        Connections ca;
        TldRegion ra;
        int i;
        int N = regions.size;
        this.conn.growArray(N);
        for (i = 0; i < N; ++i) {
            ((Connections[])this.conn.data)[i].reset();
        }
        for (i = 0; i < N; ++i) {
            ra = (TldRegion)regions.get(i);
            ca = ((Connections[])this.conn.data)[i];
            for (int j = i + 1; j < N; ++j) {
                TldRegion rb = (TldRegion)regions.get(j);
                Connections cb = ((Connections[])this.conn.data)[j];
                double overlap = this.helper.computeOverlap(ra.rect, rb.rect);
                if (overlap < this.connectionThreshold) continue;
                ca.maximum = ca.maximum & ra.confidence > rb.confidence;
                cb.maximum = cb.maximum & rb.confidence > ra.confidence;
                ++ra.connections;
                ++rb.connections;
            }
        }
        for (i = 0; i < N; ++i) {
            ra = (TldRegion)regions.get(i);
            ca = ((Connections[])this.conn.data)[i];
            if (ca.maximum) {
                TldRegion o = (TldRegion)output.grow();
                o.connections = ra.connections;
                o.confidence = ra.confidence;
                o.rect.set((RectangleCorner2D_I32)ra.rect);
                continue;
            }
            if (ra.connections != 0) continue;
            System.out.println("Not a maximum but has zero connections?");
        }
    }

    public FastQueue<Connections> getConnections() {
        return this.conn;
    }

    public static class Connections {
        boolean maximum;

        public void reset() {
            this.maximum = true;
        }
    }
}

