/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.sfm.robust.DistanceScaleTranslate2DSq;
import boofcv.alg.sfm.robust.GenerateScaleTranslate2D;
import boofcv.alg.sfm.robust.ModelManagerScaleTranslate2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.sfm.ScaleTranslate2D;
import georegression.struct.shapes.RectangleCorner2D_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.struct.FastQueue;

public class TldAdjustRegion {
    private LeastMedianOfSquares<ScaleTranslate2D, AssociatedPair> estimateMotion;
    int imageWidth;
    int imageHeight;

    public TldAdjustRegion(int numCycles) {
        ModelManagerScaleTranslate2D manager = new ModelManagerScaleTranslate2D();
        GenerateScaleTranslate2D generator = new GenerateScaleTranslate2D();
        DistanceScaleTranslate2DSq distance = new DistanceScaleTranslate2DSq();
        this.estimateMotion = new LeastMedianOfSquares(123123L, numCycles, Double.MAX_VALUE, 0.0, (ModelManager)manager, (ModelGenerator)generator, (DistanceFromModel)distance);
    }

    public void init(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public boolean process(FastQueue<AssociatedPair> pairs, RectangleCorner2D_F64 targetRectangle) {
        if (!this.estimateMotion.process(pairs.toList())) {
            return false;
        }
        ScaleTranslate2D motion = (ScaleTranslate2D)this.estimateMotion.getModelParameters();
        this.adjustRectangle(targetRectangle, motion);
        if (targetRectangle.x0 < 0.0 || targetRectangle.y0 < 0.0) {
            return false;
        }
        return !(targetRectangle.x1 >= (double)this.imageWidth) && !(targetRectangle.y1 >= (double)this.imageHeight);
    }

    protected void adjustRectangle(RectangleCorner2D_F64 rect, ScaleTranslate2D motion) {
        rect.x0 = rect.x0 * motion.scale + motion.transX;
        rect.y0 = rect.y0 * motion.scale + motion.transY;
        rect.x1 = rect.x1 * motion.scale + motion.transX;
        rect.y1 = rect.y1 * motion.scale + motion.transY;
    }
}

