/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.sfot;

import boofcv.alg.sfm.robust.DistanceScaleTranslateRotate2DSq;
import boofcv.alg.sfm.robust.GenerateScaleTranslateRotate2D;
import boofcv.alg.sfm.robust.ModelManagerScaleTranslateRotate2D;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.alg.tracker.sfot.SfotConfig;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.RectangleRotate_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.sfm.ScaleTranslateRotate2D;
import georegression.geometry.UtilPoint2D_F32;
import java.lang.reflect.Array;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.struct.FastQueue;

public class SparseFlowObjectTracker<Image extends ImageSingleBand, Derivative extends ImageSingleBand> {
    private ImagePyramid<Image> currentImage;
    private Derivative[] currentDerivX;
    private Derivative[] currentDerivY;
    private ImagePyramid<Image> previousImage;
    private Derivative[] previousDerivX;
    private Derivative[] previousDerivY;
    private PyramidKltTracker<Image, Derivative> klt;
    private PyramidKltFeature track;
    private FastQueue<AssociatedPair> pairs = new FastQueue(AssociatedPair.class, true);
    private LeastMedianOfSquares<ScaleTranslateRotate2D, AssociatedPair> estimateMotion;
    private boolean trackLost;
    private SfotConfig<Image, Derivative> config;
    private float maximumErrorFB;
    RectangleRotate_F64 region = new RectangleRotate_F64();

    public SparseFlowObjectTracker(SfotConfig<Image, Derivative> config) {
        this.config = config;
        this.maximumErrorFB = (float)(config.maximumErrorFB * config.maximumErrorFB);
        this.klt = FactoryTrackerAlg.kltPyramid((KltConfig)config.trackerConfig, config.imageType, config.derivType);
        ModelManagerScaleTranslateRotate2D manager = new ModelManagerScaleTranslateRotate2D();
        GenerateScaleTranslateRotate2D generator = new GenerateScaleTranslateRotate2D();
        DistanceScaleTranslateRotate2DSq distance = new DistanceScaleTranslateRotate2DSq();
        this.estimateMotion = new LeastMedianOfSquares(config.randSeed, config.robustCycles, Double.MAX_VALUE, 0.0, (ModelManager)manager, (ModelGenerator)generator, (DistanceFromModel)distance);
    }

    public void init(Image input, RectangleRotate_F64 region) {
        if (this.currentImage == null || this.currentImage.getInputWidth() != ((ImageSingleBand)input).width || this.currentImage.getInputHeight() != ((ImageSingleBand)input).height) {
            this.declarePyramid(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        this.previousImage.process(input);
        for (int i = 0; i < this.previousImage.getNumLayers(); ++i) {
            ImageSingleBand layer = (ImageSingleBand)this.previousImage.getLayer(i);
            this.config.gradient.process(layer, this.previousDerivX[i], this.previousDerivY[i]);
        }
        this.trackLost = false;
        this.region.set(region);
    }

    public boolean update(Image input, RectangleRotate_F64 output) {
        if (this.trackLost) {
            return false;
        }
        this.trackFeatures(input, this.region);
        if (this.pairs.size() < this.config.numberOfSamples) {
            System.out.println("Lack of sample pairs");
            this.trackLost = true;
            return false;
        }
        if (!this.estimateMotion.process(this.pairs.toList())) {
            System.out.println("estimate motion failed");
            this.trackLost = true;
            return false;
        }
        if (this.estimateMotion.getFitQuality() > this.config.robustMaxError) {
            System.out.println("exceeded Max estimation error");
            this.trackLost = true;
            return false;
        }
        ScaleTranslateRotate2D model = (ScaleTranslateRotate2D)this.estimateMotion.getModelParameters();
        this.region.width *= model.scale;
        this.region.height *= model.scale;
        double c = Math.cos(model.theta);
        double s = Math.sin(model.theta);
        double x = this.region.cx;
        double y = this.region.cy;
        this.region.cx = (x * c - y * s) * model.scale + model.transX;
        this.region.cy = (x * s + y * c) * model.scale + model.transY;
        this.region.theta += model.theta;
        output.set(this.region);
        this.swapImages();
        return true;
    }

    private void trackFeatures(Image input, RectangleRotate_F64 region) {
        this.pairs.reset();
        this.currentImage.process(input);
        for (int i = 0; i < this.currentImage.getNumLayers(); ++i) {
            ImageSingleBand layer = (ImageSingleBand)this.currentImage.getLayer(i);
            this.config.gradient.process(layer, this.currentDerivX[i], this.currentDerivY[i]);
        }
        float cx = (float)region.cx;
        float cy = (float)region.cy;
        float height = (float)region.height;
        float width = (float)region.width;
        float c = (float)Math.cos(region.theta);
        float s = (float)Math.sin(region.theta);
        float p = 1.0f / (float)(this.config.numberOfSamples - 1);
        for (int i = 0; i < this.config.numberOfSamples; ++i) {
            float y = (p * (float)i - 0.5f) * height;
            for (int j = 0; j < this.config.numberOfSamples; ++j) {
                float x = (p * (float)j - 0.5f) * width;
                float xx = cx + x * c - y * s;
                float yy = cy + x * s + y * c;
                this.track.x = xx;
                this.track.y = yy;
                this.klt.setImage(this.previousImage, this.previousDerivX, this.previousDerivY);
                if (!this.klt.setDescription(this.track)) continue;
                this.klt.setImage(this.currentImage, this.currentDerivX, this.currentDerivY);
                KltTrackFault fault = this.klt.track(this.track);
                if (fault != KltTrackFault.SUCCESS) continue;
                float xc = this.track.x;
                float yc = this.track.y;
                if (!this.klt.setDescription(this.track)) continue;
                this.klt.setImage(this.previousImage, this.previousDerivX, this.previousDerivY);
                fault = this.klt.track(this.track);
                if (fault != KltTrackFault.SUCCESS) continue;
                float error = UtilPoint2D_F32.distanceSq((float)this.track.x, (float)this.track.y, (float)xx, (float)yy);
                AssociatedPair a = (AssociatedPair)this.pairs.grow();
                a.p1.x = xx;
                a.p1.y = yy;
                a.p2.x = xc;
                a.p2.y = yc;
            }
        }
    }

    private void declarePyramid(int imageWidth, int imageHeight) {
        int minSize = (this.config.trackerFeatureRadius * 2 + 1) * 5;
        int[] scales = TldTracker.selectPyramidScale(imageWidth, imageHeight, minSize);
        this.currentImage = FactoryPyramid.discreteGaussian((int[])scales, (double)-1.0, (int)1, (boolean)false, this.config.imageType);
        this.currentImage.initialize(imageWidth, imageHeight);
        this.previousImage = FactoryPyramid.discreteGaussian((int[])scales, (double)-1.0, (int)1, (boolean)false, this.config.imageType);
        this.previousImage.initialize(imageWidth, imageHeight);
        int numPyramidLayers = this.currentImage.getNumLayers();
        this.previousDerivX = (ImageSingleBand[])Array.newInstance(this.config.derivType, numPyramidLayers);
        this.previousDerivY = (ImageSingleBand[])Array.newInstance(this.config.derivType, numPyramidLayers);
        this.currentDerivX = (ImageSingleBand[])Array.newInstance(this.config.derivType, numPyramidLayers);
        this.currentDerivY = (ImageSingleBand[])Array.newInstance(this.config.derivType, numPyramidLayers);
        for (int i = 0; i < numPyramidLayers; ++i) {
            int w = this.currentImage.getWidth(i);
            int h = this.currentImage.getHeight(i);
            this.previousDerivX[i] = GeneralizedImageOps.createSingleBand(this.config.derivType, (int)w, (int)h);
            this.previousDerivY[i] = GeneralizedImageOps.createSingleBand(this.config.derivType, (int)w, (int)h);
            this.currentDerivX[i] = GeneralizedImageOps.createSingleBand(this.config.derivType, (int)w, (int)h);
            this.currentDerivY[i] = GeneralizedImageOps.createSingleBand(this.config.derivType, (int)w, (int)h);
        }
        this.track = new PyramidKltFeature(numPyramidLayers, this.config.trackerFeatureRadius);
    }

    private void swapImages() {
        ImagePyramid<Image> tempP = this.currentImage;
        this.currentImage = this.previousImage;
        this.previousImage = tempP;
        Derivative[] tempD = this.previousDerivX;
        this.previousDerivX = this.currentDerivX;
        this.currentDerivX = tempD;
        tempD = this.previousDerivY;
        this.previousDerivY = this.currentDerivY;
        this.currentDerivY = tempD;
    }

    public boolean isTrackLost() {
        return this.trackLost;
    }

    public SfotConfig<Image, Derivative> getConfig() {
        return this.config;
    }
}

