/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.sfot;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageSingleBand;

public class SfotConfig<T extends ImageSingleBand, D extends ImageSingleBand> {
    public Class<T> imageType;
    public Class<D> derivType;
    public long randSeed = 65261L;
    public int robustCycles = 50;
    public double robustMaxError = 10.0;
    public int trackerFeatureRadius = 5;
    public int numberOfSamples = 15;
    public double maximumErrorFB = 10.0;
    public KltConfig trackerConfig;
    ImageGradient<T, D> gradient;

    public SfotConfig(Class<T> imageType) {
        this.imageType = imageType;
        this.derivType = GImageDerivativeOps.getDerivativeType(imageType);
        this.gradient = FactoryDerivative.sobel(imageType, this.derivType);
        this.trackerConfig = new KltConfig();
        this.trackerConfig.maxIterations = 50;
    }

    public SfotConfig() {
    }
}

