/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.RectangleCorner2D_F64;

public class Tld_to_TrackerObjectQuad<T extends ImageSingleBand, D extends ImageSingleBand>
implements TrackerObjectQuad<T> {
    RectangleCorner2D_F64 rect = new RectangleCorner2D_F64();
    TldTracker<T, D> tracker;
    ImageType<T> type;

    public Tld_to_TrackerObjectQuad(TldTracker<T, D> tracker, Class<T> imageType) {
        this.tracker = tracker;
        this.type = ImageType.single(imageType);
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (RectangleCorner2D_F64)this.rect);
        this.tracker.initialize(image, (int)this.rect.x0, (int)this.rect.y0, (int)this.rect.x1, (int)this.rect.y1);
        return true;
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 location) {
        if (!this.tracker.track(image)) {
            return false;
        }
        RectangleCorner2D_F64 rect = this.tracker.getTargetRegion();
        location.a.x = rect.x0;
        location.a.y = rect.y0;
        location.b.x = rect.x1;
        location.b.y = rect.y0;
        location.c.x = rect.x1;
        location.c.y = rect.y1;
        location.d.x = rect.x0;
        location.d.y = rect.y1;
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }
}

