/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftLikelihood;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import georegression.struct.shapes.RectangleCorner2D_F64;

public class Msl_to_TrackerObjectQuad<T extends ImageMultiBand>
implements TrackerObjectQuad<T> {
    TrackerMeanShiftLikelihood<T> tracker;
    PixelLikelihood<T> likelihood;
    ImageType<T> type;
    RectangleCorner2D_F64 rect = new RectangleCorner2D_F64();
    Rectangle2D_I32 target = new Rectangle2D_I32();

    public Msl_to_TrackerObjectQuad(TrackerMeanShiftLikelihood<T> tracker, PixelLikelihood<T> likelihood, ImageType<T> imageType) {
        this.tracker = tracker;
        this.likelihood = likelihood;
        this.type = imageType;
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (RectangleCorner2D_F64)this.rect);
        this.target.tl_x = (int)this.rect.x0;
        this.target.tl_y = (int)this.rect.y0;
        this.target.width = (int)this.rect.getWidth();
        this.target.height = (int)this.rect.getHeight();
        this.likelihood.setImage(image);
        this.likelihood.createModel(this.target);
        this.tracker.initialize(image, this.target);
        return true;
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 location) {
        if (!this.tracker.process(image)) {
            return false;
        }
        Rectangle2D_I32 rect = this.tracker.getLocation();
        location.a.x = rect.tl_x;
        location.a.y = rect.tl_y;
        location.b.x = rect.tl_x + rect.width;
        location.b.y = rect.tl_y;
        location.c.x = rect.tl_x + rect.width;
        location.c.y = rect.tl_y + rect.height;
        location.d.x = rect.tl_x;
        location.d.y = rect.tl_y + rect.height;
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }
}

